/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.unicode;

import com.prosc.fmkit.unicode.Compress;
import com.prosc.fmkit.unicode.Debug;
import com.prosc.fmkit.unicode.Display;
import com.prosc.fmkit.unicode.Expand;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Random;
import java.util.StringTokenizer;

public class CompressMain {
    private static int iMSB = 1;

    static void usage() {
        System.err.println("java CompressMain /?               : this usage information\n");
        System.err.println("java CompressMain /random    \t   : random test\n");
        System.err.println("java CompressMain /suite           : suite test\n");
        System.err.println("java CompressMain /suite <file>    : file test (file data may include \\uXXXX)\n");
        System.err.println("java CompressMain <string>    \t   : string test (string may include \\uXXXX)\n");
        System.err.println("java CompressMain /roundtrip <file>: check Unicode file for roundtrip\n");
        System.err.println("java CompressMain /compress <file> : compresses Unicode files (no \\uXXXX)\n");
        System.err.println("java CompressMain /expand <file>   : expands into Unicode files\n");
        System.err.println("java CompressMain /byteswap <files>: swaps byte order of Unicode files\n");
        System.err.println("java CompressMain /display <files> : like expand, but creates a dump instead\n");
        System.err.println("java CompressMain /parse <files>   : parses \\uXXXX into binary Unicode\n");
    }

    static void analyze(String text, int inlength, String result, int outlength, boolean fDebug) {
        boolean fSuccess = text.equals(result);
        System.out.println(fSuccess ? "Round trip OK" : "Round trip FAILED");
        if (!fSuccess && result != null) {
            int iLim = Math.min(text.length(), result.length());
            for (int i = 0; i < iLim; ++i) {
                if (text.charAt(i) == result.charAt(i)) continue;
                Debug.set(true);
                Debug.out("First Mismatch at  " + i + "=", result.charAt(i));
                Debug.out("Original character " + i + "=", text.charAt(i));
                Debug.set(fDebug);
                break;
            }
        } else {
            System.out.print("Compressed: " + inlength + " chars to " + outlength + " bytes.");
            System.out.println(" Ratio: " + (outlength == 0 ? 0 : outlength * 50 / inlength) + "%.");
        }
    }

    static void test2(String text, boolean fDebug) {
        byte[] bytes = null;
        String result = null;
        System.out.println("SCSU:\n");
        Compress compressor = new Compress();
        try {
            Debug.set(fDebug);
            bytes = compressor.compress(text);
            Debug.set(false);
            Display display = new Display();
            result = display.expand(bytes);
            Debug.set(true);
            Debug.out("Input:  ", text.toCharArray());
            Debug.out("Result: ", result.toCharArray());
            System.out.println();
            Debug.set(false);
            Expand expander = new Expand();
            result = expander.expand(bytes);
            Debug.set(fDebug);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        int inlength = compressor.charsRead();
        int outlength = compressor.bytesWritten();
        CompressMain.analyze(text, inlength, result, outlength, false);
    }

    static void test(String text) {
        CompressMain.test(text, false);
    }

    static void test(String text, boolean fDebug) {
        Debug.set(fDebug);
        Compress compressor = new Compress();
        byte[] bytes = null;
        String result = null;
        try {
            bytes = compressor.compress(text);
        }
        catch (Exception e) {
            if (fDebug) {
                e.printStackTrace(System.out);
            }
            System.out.println(e);
        }
        Expand expander = new Expand();
        try {
            result = expander.expand(bytes);
        }
        catch (Exception e) {
            if (fDebug) {
                e.printStackTrace(System.out);
            }
            System.out.println(e);
        }
        int inlength = compressor.charsRead();
        int outlength = compressor.bytesWritten();
        CompressMain.analyze(text, inlength, result, outlength, fDebug);
    }

    public static void display(byte[] input) {
        try {
            Display expand = new Display();
            String text = expand.expand(input);
            Debug.set(true);
            Debug.out(text.toCharArray());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static String parse(String input) {
        Debug.set(false);
        StringTokenizer st = new StringTokenizer(input, "\\", true);
        Debug.out("Input: ", input);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Debug.out("Token: ", token);
            if (token.charAt(0) == '\\' && token.length() == 1) {
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                }
                if (token.charAt(0) == 'u') {
                    String hexnum;
                    Debug.out("Token: " + token + " ", sb.toString());
                    if (token.length() > 5) {
                        hexnum = token.substring(1, 5);
                        token = token.substring(5);
                    } else {
                        hexnum = token.substring(1);
                        token = "";
                    }
                    sb.append((char)Integer.parseInt(hexnum, 16));
                }
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static void randomTest(int nTest) {
        Random random = new Random();
        for (int n = 0; n < nTest; ++n) {
            int iLen = (int)(20.0f * random.nextFloat());
            StringBuffer sb = new StringBuffer(iLen);
            for (int i = 0; i < iLen; ++i) {
                sb.append((char)(65535.0f * random.nextFloat()));
            }
            CompressMain.test(sb.toString());
        }
    }

    public static void fileTest(String name) throws IOException {
        String eachLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(name)));
        int iLine = 0;
        while ((eachLine = reader.readLine()) != null) {
            System.out.print("Line " + iLine++ + " " + eachLine);
            CompressMain.test(CompressMain.parse(eachLine), true);
        }
    }

    public static void displayFile(String name) throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(name));
        byte[] bytes = new byte[dis.available()];
        dis.read(bytes);
        CompressMain.display(bytes);
    }

    public static void decodeTest(String name, boolean fDebug) throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(name));
        byte[] bytes = new byte[dis.available()];
        dis.read(bytes);
        Expand expand = new Expand();
        char[] chars = null;
        try {
            String text = expand.expand(bytes);
            chars = text.toCharArray();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        int inlength = expand.bytesRead();
        int iDot = name.lastIndexOf(46);
        StringBuffer sb = new StringBuffer(name);
        sb.setLength(iDot + 1);
        sb.append("txt");
        String outName = sb.toString();
        int outlength = expand.charsWritten();
        System.out.print("Expanded " + name + ": " + inlength + " bytes to " + outName + " " + outlength + " chars.");
        System.out.println(" Ratio: " + (outlength == 0 ? 0 : outlength * 200 / inlength) + "%.");
        if (chars == null) {
            return;
        }
        CompressMain.writeUnicodeFile(outName, chars);
    }

    public static String readUnicodeFile(String name) {
        try {
            FileInputStream dis = new FileInputStream(name);
            byte[] b = new byte[2];
            StringBuffer sb = new StringBuffer();
            char ch = '\u0000';
            iMSB = 1;
            int i = 0;
            i = 0;
            while (dis.available() != 0) {
                b[i % 2] = (byte)dis.read();
                if ((i & 1) == 1) {
                    ch = Expand.charFromTwoBytes(b[(i + iMSB) % 2], b[(i + iMSB + 1) % 2]);
                    if (i != 1 || ch != '\ufeff') {
                        if (i == 1 && ch == '\ufffe') {
                            ++iMSB;
                        } else {
                            sb.append(ch);
                        }
                    }
                }
                ++i;
            }
            return sb.toString();
        }
        catch (IOException e) {
            System.err.println(e);
            return "";
        }
    }

    public static void writeUnicodeFile(String outName, char[] chars) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(outName));
        if ((iMSB & 1) == 1) {
            dos.writeByte(255);
            dos.writeByte(254);
        } else {
            dos.writeByte(254);
            dos.writeByte(255);
        }
        byte[] b = new byte[2];
        for (int ich = 0; ich < chars.length; ++ich) {
            b[(CompressMain.iMSB + 0) % 2] = (byte)(chars[ich] >>> 8);
            b[(CompressMain.iMSB + 1) % 2] = (byte)(chars[ich] & 0xFF);
            dos.write(b, 0, 2);
        }
    }

    static void byteswap(String name) throws IOException {
        String text = CompressMain.readUnicodeFile(name);
        char[] chars = text.toCharArray();
        CompressMain.writeUnicodeFile(name, chars);
    }

    public static void parseFile(String name) throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(name));
        byte[] bytes = new byte[dis.available()];
        dis.read(bytes);
        int bom = (char)bytes[0] + (char)bytes[1];
        if (bom == 131069) {
            System.out.println(name + " is already in Unicode!");
            return;
        }
        String text = new String(bytes, "US-ASCII");
        char[] chars = CompressMain.parse(text).toCharArray();
        CompressMain.writeUnicodeFile(name, chars);
    }

    public static void encodeTest(String name, boolean fDebug) throws IOException {
        String text = CompressMain.readUnicodeFile(name);
        Compress compressor = new Compress();
        byte[] bytes = null;
        try {
            bytes = compressor.compress(text);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        int inlength = compressor.charsRead();
        int iDot = name.lastIndexOf(46);
        StringBuffer sb = new StringBuffer(name);
        sb.setLength(iDot + 1);
        sb.append("csu");
        String outName = sb.toString();
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(outName));
        dos.write(bytes, 0, bytes.length);
        int outlength = compressor.bytesWritten();
        System.out.print("Compressed " + name + ": " + inlength + " chars to " + outName + " " + outlength + " bytes.");
        System.out.println(" Ratio: " + (outlength == 0 ? 0 : outlength * 50 / inlength) + "%.");
    }

    public static void roundtripTest(String name) {
        CompressMain.test(CompressMain.readUnicodeFile(name), false);
    }

    public static void main(String[] args) {
        int iArg = args.length;
        try {
            if (iArg != 0) {
                if (args[0].equalsIgnoreCase("/compress")) {
                    while (--iArg > 0) {
                        CompressMain.encodeTest(args[args.length - iArg], false);
                    }
                } else if (args[0].equalsIgnoreCase("/parse")) {
                    while (--iArg > 0) {
                        CompressMain.parseFile(args[args.length - iArg]);
                    }
                } else if (args[0].equalsIgnoreCase("/expand")) {
                    while (--iArg > 0) {
                        CompressMain.decodeTest(args[args.length - iArg], false);
                    }
                } else if (args[0].equalsIgnoreCase("/display")) {
                    while (--iArg > 0) {
                        CompressMain.displayFile(args[args.length - iArg]);
                    }
                } else if (args[0].equalsIgnoreCase("/roundtrip")) {
                    while (--iArg > 0) {
                        CompressMain.roundtripTest(args[args.length - iArg]);
                    }
                } else if (args[0].equalsIgnoreCase("/byteswap")) {
                    while (--iArg > 0) {
                        CompressMain.byteswap(args[args.length - iArg]);
                    }
                } else if (args[0].equalsIgnoreCase("/random")) {
                    CompressMain.randomTest(8);
                } else if (args[0].equalsIgnoreCase("/suite")) {
                    if (iArg == 1) {
                        CompressMain.suiteTest();
                    } else {
                        while (--iArg > 0) {
                            CompressMain.fileTest(args[args.length - iArg]);
                        }
                    }
                } else if (args[0].equalsIgnoreCase("/?")) {
                    CompressMain.usage();
                } else {
                    while (iArg > 0) {
                        CompressMain.test2(CompressMain.parse(args[--iArg]), false);
                    }
                }
            } else {
                CompressMain.usage();
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        try {
            System.err.println("Done. Press enter to exit");
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void suiteTest() {
        System.out.println("Standard Compression test suite:");
        Debug.set(false);
        CompressMain.test("Hello \u9292 \u9192 World!");
        CompressMain.test("Hell\u0429o \u9292 \u9192 W\u2030rld!");
        CompressMain.test("Hell\u0429o \u9292 \u9292W\u2030rld!");
        CompressMain.test("\u0648\u06c8");
        CompressMain.test("\u0648\u06c8");
        CompressMain.test("\u4444\ue001");
        CompressMain.test("\u4444\uf2ff");
        CompressMain.test("\u4444\uf188\u4444");
        CompressMain.test("\u4444\uf188\uf288");
        CompressMain.test("\u4444\uf188abc\"9\uf288");
        CompressMain.test("\u9292\u2222");
        CompressMain.test("Hell\u0429\u04230o \u9292 \u9292W\u2030\u0192rld!");
        CompressMain.test("Hell\u0429o \u9292 \u9292W\u2030rld!");
        CompressMain.test("Hello World!123456");
        CompressMain.test("Hello W\u0081\u011f\u0082!");
        CompressMain.test("abc\u0301\u0302");
        CompressMain.test("abc\u4411d");
        CompressMain.test("abc\u4411\u4412d");
        CompressMain.test("abc\u0401\u0402\u047f\u00a5\u0405");
        CompressMain.test("\u9191\u9191\u3041\u9191\u3041\u3041\u3000");
        CompressMain.test("\u9292\u2222");
        CompressMain.test("\u9191\u9191\u3041\u9191\u3041\u3041\u3000");
        CompressMain.test("\u9999\u3051\u300c\u9999\u9999\u3060\u9999\u3065\u3065\u3065\u300c");
        CompressMain.test("\u3000\u266a\u30ea\u30f3\u30b4\u53ef\u611b\u3044\u3084\u53ef\u611b\u3044\u3084\u30ea\u30f3\u30b4\u3002");
        CompressMain.test("");
        CompressMain.test("\u0000");
        CompressMain.test("\uffff");
        CompressMain.test("\ud800\udc00");
        CompressMain.test("\ud8ff\udcff");
        System.out.println("\nTHESE TESTS ARE SUPPOSED TO FAIL:");
        CompressMain.test("\ud800 \udc00");
        CompressMain.test("\udc00");
        CompressMain.test("\ud800");
    }
}

