/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fmkit.Configurable;
import com.prosc.fmkit.FmCalculationException;
import com.prosc.fmkit.LicenseKeyEntryDialog;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.ProscPlugin;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMType;
import com.prosc.license.client.InvalidLicenseException;
import com.prosc.license.client.Registration;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public abstract class RegisterablePlugin
extends ProscPlugin
implements Configurable {
    private static final Logger log = Logger.getLogger(RegisterablePlugin.class.getName());
    private Registration registration;
    private Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    protected static final String LICENSE_KEY = "licenseKey";
    protected static final String COMPANY_NAME = "companyName";
    private long lastUserCheck = 0L;
    protected long userCheckFrequency = 600000L;
    private boolean showLicenseKey = true;
    private Boolean isWPE = null;

    public void init() {
        super.init();
        try {
            log.fine("Checking license key at init");
            this.getRegistration().checkLicense();
        }
        catch (InvalidLicenseException invalidLicenseException) {
            // empty catch block
        }
    }

    public FMType invokeFunction(PluginFunction whichFunction, Object[] parameters) throws Exception {
        if (this.isRegistrationRequired(whichFunction)) {
            this.checkLicense();
        }
        try {
            return super.invokeFunction(whichFunction, parameters);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof InvalidLicenseException) {
                InvalidLicenseException licenseException = (InvalidLicenseException)e.getCause();
                return this.handleLicenseException(licenseException);
            }
            throw e;
        }
    }

    public void configure() {
        Registration potentialRegistration = this.getRegistration();
        if (this.showConfigurationDialog(potentialRegistration, this.showLicenseKey)) {
            try {
                this.defaultRegister(potentialRegistration.getLicenseKey(), potentialRegistration.getCompanyName());
                this.prefs.put(this.licenseKeyPrefKey(), potentialRegistration.getLicenseKey());
                this.prefs.put(this.companyNamePrefKey(), potentialRegistration.getCompanyName());
                this.prefs.sync();
            }
            catch (BackingStoreException e) {
                String message = "Registration preferences could not be saved because an error occurred: " + e.getMessage();
                log.log(Level.SEVERE, message, e);
                JOptionPane.showMessageDialog(null, message, "Preferences error", 0);
            }
            catch (InternalError e) {
                log.log(Level.SEVERE, "Couldn't display preferences dialog because we need Java 5 release 4 or later.", e);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Error while configuring plugin preferences", t);
            }
        }
    }

    public void checkLicense() throws InvalidLicenseException {
        this.getRegistration().checkLicense();
        this.checkWebAccess();
        this.checkPortfolioAccess();
    }

    protected void checkUserLimit() throws InvalidLicenseException {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUserCheck > this.userCheckFrequency) {
            log.fine("Checking user limit");
            switch (this.getRegistration().getLicense().getVariant()) {
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    String userCountFunction = "Get( UserCount )";
                    try {
                        long userCount = this.getContext().evaluateExpression(userCountFunction).getLongData();
                        if (userCount > 12L) {
                            throw new InvalidLicenseException("This license code is only valid for 10 users; there are currently " + userCount + " user connected to the server. " + "Visit http://www.360works.com to purchase a different license code.", this.getRegistration().getLicense());
                        }
                        break;
                    }
                    catch (FmCalculationException e) {
                        log.log(Level.WARNING, "Couldn't determine user count because user count function failed: " + userCountFunction, e);
                    }
                }
            }
            this.lastUserCheck = currentTime;
        }
    }

    protected void checkWebAccess() throws InvalidLicenseException {
        switch (this.getRegistration().getLicense().getVariant()) {
            case 0: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                if (this.getApplicationType() == 3) {
                    throw new InvalidLicenseException("Deployment with FileMaker Server is not allowed with Workgroup or Developer licenses. Visit http://www.360works.com to upgrade to an Enterprise License.", this.getRegistration().getLicense());
                }
                if (this.getApplicationType() != 4) break;
                String webLicenseMessage = "Deployment in the Web Publishing Engine is not allowed with Workgroup or Developer licenses. Visit http://www.360works.com to upgrade to an Enterprise License.";
                if (this.isWPE == null) {
                    try {
                        String appVersion = this.getContext().evaluateExpression("Get( ApplicationVersion )").getStringData();
                        this.isWPE = appVersion.indexOf("Web Publishing Engine") >= 0;
                    }
                    catch (FmCalculationException e) {
                        log.log(Level.WARNING, "Couldn't check whether we're running in WPE - deny access.", e);
                        throw new InvalidLicenseException("Deployment in the Web Publishing Engine is not allowed with Workgroup or Developer licenses. Visit http://www.360works.com to upgrade to an Enterprise License.", this.getRegistration().getLicense());
                    }
                }
                if (!this.isWPE.booleanValue()) break;
                throw new InvalidLicenseException("Deployment in the Web Publishing Engine is not allowed with Workgroup or Developer licenses. Visit http://www.360works.com to upgrade to an Enterprise License.", this.getRegistration().getLicense());
            }
        }
    }

    protected void checkPortfolioAccess() throws InvalidLicenseException {
        if (this.getRegistration().getLicense().isPortfolio()) {
            if (!this.coveredByPortfolioLicense()) {
                throw new InvalidLicenseException("This product is not covered by portfolio licenses", this.getRegistration().getLicense());
            }
            if (this.getVersion().majorReleaseDate.getTime() > this.getRegistration().getExpirationDate()) {
                DateFormat df = DateFormat.getDateInstance();
                throw new InvalidLicenseException("The portfolio license renewal date of " + df.format(new Date(this.getRegistration().getExpirationDate())) + " is before the major release date of " + df.format(this.getVersion().majorReleaseDate) + " for " + this.getName(), this.getRegistration().getLicense());
            }
        }
    }

    public boolean coveredByPortfolioLicense() {
        return true;
    }

    protected boolean showConfigurationDialog(Registration userPrefsRegistration, boolean showLicenseKey) {
        Frame owner = JOptionPane.getRootFrame();
        return new LicenseKeyEntryDialog(owner, userPrefsRegistration, this).showDialog(showLicenseKey);
    }

    protected boolean isRegistrationRequired(PluginFunction whichFunction) {
        String name = whichFunction.getName();
        return !name.endsWith("Register") && !name.endsWith("Version") && !name.endsWith("LicenseInfo") && !name.endsWith("Error");
    }

    protected abstract short getProductCode();

    protected FMType defaultRegister(String licenseKey, String registeredTo) throws InvalidLicenseException {
        if (licenseKey == null) {
            throw new InvalidLicenseException("'licenseKey' must not be empty.", licenseKey);
        }
        if (registeredTo == null) {
            throw new InvalidLicenseException("'registeredTo' must not be empty.", licenseKey);
        }
        try {
            Registration newLicense = new Registration(this.getVersion().licenseVersion, this.getProductCode());
            newLicense.setLicenseKey(licenseKey);
            newLicense.setCompanyName(registeredTo);
            newLicense.checkLicense();
            if (this.getRegistration().getLicense() == null || this.getRegistration().getLicense().compareTo(newLicense.getLicense()) < 0) {
                this.showLicenseKey = false;
                this.getRegistration().setCompanyName(registeredTo);
                this.getRegistration().setLicenseKey(licenseKey);
                this.getRegistration().checkLicense();
            }
            log.log(Level.INFO, "Successfully registered " + this.getName() + ": " + this.getRegistration().getLicenseInfo());
            return this.successValue();
        }
        catch (InvalidLicenseException e) {
            return this.handleLicenseException(e);
        }
    }

    protected FMText defaultLicenseInfo() {
        String info = this.getName() + " v" + this.getVersion().stringVersion;
        try {
            this.getRegistration().checkLicense();
            info = info + "\n" + this.getRegistration().getLicenseInfo();
        }
        catch (InvalidLicenseException e) {
            info = info + "\n*UNLICENSED*";
        }
        return new FMText(PluginUtils.convertLineBreaksToFileMaker(info));
    }

    public Registration getRegistration() {
        if (this.registration == null) {
            this.registration = this.createRegistrationFromPrefs();
        }
        return this.registration;
    }

    protected void setRegistration(Registration registration) {
        this.registration = registration;
    }

    private Registration createRegistrationFromPrefs() {
        Registration result = new Registration(this.getVersion().licenseVersion, this.getProductCode());
        String licenseKey = this.prefs.get(this.licenseKeyPrefKey(), null);
        String companyName = this.prefs.get(this.companyNamePrefKey(), null);
        result.setLicenseKey(licenseKey);
        result.setCompanyName(companyName);
        return result;
    }

    protected String licenseKeyPrefKey() {
        return this.getClass().getName() + LICENSE_KEY;
    }

    protected String companyNamePrefKey() {
        return this.getClass().getName() + COMPANY_NAME;
    }

    protected FMText handleLicenseException(InvalidLicenseException e) throws InvalidLicenseException {
        throw e;
    }
}

