/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fmkit.BugReporter;
import com.prosc.fmkit.LicenseKeyEntryPanel;
import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.ProscPlugin;
import com.prosc.license.client.InvalidLicenseException;
import com.prosc.license.client.Registration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class LicenseKeyEntryDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(LicenseKeyEntryDialog.class.getName());
    private final Registration registration;
    private boolean hitOK = false;
    private ProscPlugin whichPlugin;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private LicenseKeyEntryPanel panel;
    private JPanel panel1;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private JButton bugButton;

    public LicenseKeyEntryDialog(Frame owner, Registration registration, ProscPlugin whichPlugin) {
        super(owner);
        this.registration = registration;
        this.whichPlugin = whichPlugin;
        this.setModal(true);
        this.setResizable(false);
        this.initComponents();
    }

    public boolean showDialog(boolean showLicenseKey) {
        this.panel.setRegistration(this.registration, showLicenseKey);
        this.pack();
        this.setLocation(150, 150);
        this.setVisible(true);
        this.toBack();
        this.toFront();
        return this.hitOK;
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel = new LicenseKeyEntryPanel();
        this.panel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.helpButton = new JButton();
        this.bugButton = new JButton();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.add((Component)this.panel, "Center");
        this.panel1.setLayout(new FlowLayout(4));
        this.okButton.setText("OK");
        this.panel1.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.panel1.add(this.cancelButton);
        this.helpButton.setText("Ask a question");
        this.panel1.add(this.helpButton);
        this.bugButton.setText("Report a bug");
        this.panel1.add(this.bugButton);
        this.contentPanel.add((Component)this.panel1, "South");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    LicenseKeyEntryDialog.this.panel.checkLicense();
                    LicenseKeyEntryDialog.this.hitOK = true;
                    LicenseKeyEntryDialog.this.dispose();
                }
                catch (InvalidLicenseException e) {
                    log.info("Registration failed with exception: " + e.getMessage());
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LicenseKeyEntryDialog.this.dispose();
            }
        });
        if (this.whichPlugin.getSupportUrl() == null) {
            this.helpButton.setVisible(false);
        }
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LicenseKeyEntryDialog.this.dispose();
                LicenseKeyEntryDialog.this.launch(LicenseKeyEntryDialog.this.whichPlugin.getSupportUrl());
            }
        });
        this.bugButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BugReporter reporter = new BugReporter((Dialog)LicenseKeyEntryDialog.this, (Plugin)LicenseKeyEntryDialog.this.whichPlugin, LicenseKeyEntryDialog.this.registration);
                reporter.pack();
                reporter.setVisible(true);
            }
        });
    }

    public int launch(String url) {
        try {
            boolean isWindows = System.getProperty("os.name").indexOf("Windows") >= 0;
            String[] cmd = isWindows ? new String[]{"cmd.exe", "/C", "start", url} : new String[]{"open", url};
            Process process = Runtime.getRuntime().exec(cmd);
            process.waitFor();
            return process.exitValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

