/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionSignature {
    private final String signature;
    private final String prototype;
    private final List<String> argNames;

    public FunctionSignature(String signature) {
        this.signature = signature.trim();
        this.argNames = new ArrayList<String>();
        int index = signature.indexOf(40);
        if (index != -1) {
            String[] sigParts;
            this.prototype = signature.substring(index + 1, signature.length() - 1).trim();
            for (String sigPart : sigParts = this.prototype.split(";")) {
                String eachSigPart = sigPart.trim();
                if (!eachSigPart.matches("\\w+")) {
                    throw new IllegalArgumentException("Invalid parameter name '" + eachSigPart + "': parameter names can only contain alphanumeric characters and underscores");
                }
                if (Character.isDigit(eachSigPart.charAt(0))) {
                    throw new IllegalArgumentException("Invalid parameter name '" + eachSigPart + "': parameter names cannot start with a digit");
                }
                this.argNames.add(eachSigPart.trim());
            }
        } else {
            this.prototype = "";
        }
    }

    public String getSignature() {
        return this.signature;
    }

    public String getPrototype() {
        return this.prototype;
    }

    public List<String> getArgNames() {
        return this.argNames;
    }

    public int getMinArgs() {
        return this.argNames.size();
    }

    public int getMaxArgs() {
        return this.argNames.size();
    }

    public String getName() {
        int index = this.signature.indexOf(40);
        return index == -1 ? this.signature : this.signature.substring(0, index).trim();
    }
}

