/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class FMFileUtils {
    private static String bootVolumeName = null;
    private static final Logger log = Logger.getLogger(FMFileUtils.class.getName());
    private static final String VOLUMES = "/Volumes";
    public static final boolean isMac = System.getProperty("os.name").toLowerCase().startsWith("mac");

    public static String convertToFileMaker(String file) {
        return FMFileUtils.convertToFileMaker(new File(file));
    }

    public static String convertToFileMaker(File file) {
        StringBuffer result = new StringBuffer();
        if (isMac) {
            if (file.getAbsolutePath().startsWith(VOLUMES)) {
                result.append(file.getAbsolutePath().substring(VOLUMES.length()));
            } else {
                result.append("/" + FMFileUtils.getBootVolumeName());
                result.append(file.getAbsolutePath());
            }
        } else {
            result.append("/" + file.getAbsolutePath().replace('\\', '/'));
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBootVolumeName() {
        try {
            block11: {
                if (bootVolumeName == null) {
                    if (System.getProperty("os.name").toLowerCase().startsWith("mac")) {
                        String[] cmd = new String[]{"/bin/ls", "-l", VOLUMES};
                        Process p = Runtime.getRuntime().exec(cmd);
                        if (p.waitFor() != 0) {
                            throw new RuntimeException("ls command exited with status " + p.exitValue());
                        }
                        InputStream stream = p.getInputStream();
                        try {
                            String eachLine;
                            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                            while ((eachLine = reader.readLine()) != null) {
                                if (!eachLine.endsWith(" -> /")) continue;
                                StringTokenizer st = new StringTokenizer(eachLine);
                                for (int n = 0; n < 8; ++n) {
                                    st.nextToken();
                                }
                                String temp = st.nextToken("");
                                bootVolumeName = temp.substring(1, temp.length() - 5);
                                break;
                            }
                            if (bootVolumeName == null) {
                                throw new RuntimeException("Couldn't determine boot volume name from ls output");
                            }
                            break block11;
                        }
                        finally {
                            stream.close();
                        }
                    }
                    bootVolumeName = "C:";
                }
            }
            return bootVolumeName;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't get boot volume name");
        }
    }
}

