/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.xml;

import com.prosc.shared.Bool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class DomUtils {
    private static final Logger log = Logger.getLogger(DomUtils.class.getName());

    public static String getRecursiveChildText(Element xml, String childTag) {
        NodeList nodeList = xml.getElementsByTagName(childTag);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0).getTextContent();
    }

    public static String getChildText(Element xml, String childTag) {
        return DomUtils.getChildText(xml, childTag, true);
    }

    public static String getChildText(Element xml, String childTag, boolean validateThatRecursiveCallMatches) {
        String recursiveResult;
        List<Element> elementsByTagName = DomUtils.getChildElements(xml, childTag);
        String result = elementsByTagName.size() == 0 ? null : elementsByTagName.get(0).getTextContent();
        if (validateThatRecursiveCallMatches && !Bool.equals(result, recursiveResult = DomUtils.getRecursiveChildText(xml, childTag))) {
            log.log(Level.INFO, "Recursive result for child tag '" + childTag + "' is not the same as shallow result. This is not generally a problem, but it could be for legacy classes that assumed that all calls are recursive." + "\nShallow result: " + result + "\nRecursive result: " + recursiveResult + "\nXML input: " + DomUtils.dumpXml(xml.getOwnerDocument(), xml), new RuntimeException("Stack trace"));
        }
        return result;
    }

    public static List<Element> getChildElements(Element parent, String name) {
        if (parent == null) {
            return Collections.emptyList();
        }
        NodeList nodeList = parent.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>(nodeList.getLength());
        for (int n = 0; n < nodeList.getLength(); ++n) {
            Node item = nodeList.item(n);
            if (!(item instanceof Element) || !name.equals(item.getNodeName())) continue;
            result.add((Element)item);
        }
        return result;
    }

    public static String dumpXml(Document document, @Nullable Element element) {
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        return lsSerializer.writeToString(element == null ? document : element);
    }
}

