/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.thread;

import com.prosc.shared.ExceptionUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class ThreadUtil {
    private static final Logger log = Logger.getLogger(ThreadUtil.class.getName());

    public static <T> T get(Future<T> future, boolean cancelOnInterrupt) {
        return ThreadUtil.get(future, cancelOnInterrupt, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable> T get(Future<T> future, boolean cancelOnInterrupt, @NotNull Class<E1> exceptionClass1) throws E1 {
        if (exceptionClass1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass1", "com/prosc/thread/ThreadUtil", "get"));
        }
        return ThreadUtil.get(future, cancelOnInterrupt, exceptionClass1, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable> T get(Future<T> future, boolean cancelOnInterrupt, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2) throws E1, E2 {
        if (exceptionClass1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass1", "com/prosc/thread/ThreadUtil", "get"));
        }
        if (exceptionClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass2", "com/prosc/thread/ThreadUtil", "get"));
        }
        return ThreadUtil.get(future, cancelOnInterrupt, exceptionClass1, exceptionClass2, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> T get(Future<T> future, boolean cancelOnInterrupt, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3) throws E1, E2, E3 {
        if (exceptionClass1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass1", "com/prosc/thread/ThreadUtil", "get"));
        }
        if (exceptionClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass2", "com/prosc/thread/ThreadUtil", "get"));
        }
        if (exceptionClass3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass3", "com/prosc/thread/ThreadUtil", "get"));
        }
        return ThreadUtil.get(future, cancelOnInterrupt, exceptionClass1, exceptionClass2, exceptionClass3, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable> T get(Future<T> future, boolean cancelOnInterrupt, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4, @NotNull Class<E5> exceptionClass5, @NotNull Class<E6> exceptionClass6) throws E1, E2, E3, E4, E5, E6 {
        if (exceptionClass1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass1", "com/prosc/thread/ThreadUtil", "get"));
        }
        if (exceptionClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass2", "com/prosc/thread/ThreadUtil", "get"));
        }
        if (exceptionClass3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass3", "com/prosc/thread/ThreadUtil", "get"));
        }
        if (exceptionClass4 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass4", "com/prosc/thread/ThreadUtil", "get"));
        }
        if (exceptionClass5 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass5", "com/prosc/thread/ThreadUtil", "get"));
        }
        if (exceptionClass6 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass6", "com/prosc/thread/ThreadUtil", "get"));
        }
        boolean isInterrupted = false;
        while (true) {
            try {
                T t = ThreadUtil.getInterruptible(future, exceptionClass1, exceptionClass2, exceptionClass3, exceptionClass4, exceptionClass5, exceptionClass6);
                return t;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                isInterrupted = true;
                if (cancelOnInterrupt) {
                    future.cancel(true);
                    log.log(Level.WARNING, "Interruption was received on thread " + Thread.currentThread().getName() + ", but will be ignored until task completes or is canceled");
                    continue;
                }
                log.log(Level.WARNING, "Interruption was received on thread " + Thread.currentThread().getName() + ", but will be ignored until task completes");
                continue;
            }
            break;
        }
        finally {
            if (isInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T, E1 extends Throwable> T getInterruptible(Future<T> future, Class<E1> exceptionClass1) throws E1, InterruptedException {
        return ThreadUtil.getInterruptible(future, exceptionClass1, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable> T getInterruptible(Future<T> future, Class<E1> exceptionClass1, Class<E2> exceptionClass2) throws E1, E2, InterruptedException {
        return ThreadUtil.getInterruptible(future, exceptionClass1, exceptionClass2, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> T getInterruptible(Future<T> future, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3) throws E1, E2, E3, InterruptedException {
        if (exceptionClass1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass1", "com/prosc/thread/ThreadUtil", "getInterruptible"));
        }
        if (exceptionClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass2", "com/prosc/thread/ThreadUtil", "getInterruptible"));
        }
        if (exceptionClass3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass3", "com/prosc/thread/ThreadUtil", "getInterruptible"));
        }
        return ThreadUtil.getInterruptible(future, exceptionClass1, exceptionClass2, exceptionClass3, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable> T getInterruptible(Future<T> future, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4, @NotNull Class<E5> exceptionClass5, @NotNull Class<E6> exceptionClass6) throws E1, E2, E3, E4, E5, E6, InterruptedException {
        if (exceptionClass1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass1", "com/prosc/thread/ThreadUtil", "getInterruptible"));
        }
        if (exceptionClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass2", "com/prosc/thread/ThreadUtil", "getInterruptible"));
        }
        if (exceptionClass3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass3", "com/prosc/thread/ThreadUtil", "getInterruptible"));
        }
        if (exceptionClass4 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass4", "com/prosc/thread/ThreadUtil", "getInterruptible"));
        }
        if (exceptionClass5 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass5", "com/prosc/thread/ThreadUtil", "getInterruptible"));
        }
        if (exceptionClass6 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass6", "com/prosc/thread/ThreadUtil", "getInterruptible"));
        }
        if (future == null) {
            throw new IllegalArgumentException("Null future object was passed to ThreadUtil.getInterruptible()");
        }
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (exceptionClass1.isAssignableFrom(cause.getClass())) {
                throw cause;
            }
            if (exceptionClass2.isAssignableFrom(cause.getClass())) {
                throw cause;
            }
            if (exceptionClass3.isAssignableFrom(cause.getClass())) {
                throw cause;
            }
            if (exceptionClass4.isAssignableFrom(cause.getClass())) {
                throw cause;
            }
            if (exceptionClass5.isAssignableFrom(cause.getClass())) {
                throw cause;
            }
            if (exceptionClass6.isAssignableFrom(cause.getClass())) {
                throw cause;
            }
            throw ExceptionUtils.rethrowUnchecked(e.getCause());
        }
    }
}

