/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import com.prosc.io.IOUtils;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class StringParser {
    protected String theText;
    protected String lowercaseText;
    protected int currentMarker = 0;
    protected int tokenStart = 0;
    protected int tokenEnd = 0;

    public StringParser(String theText) {
        this.theText = theText;
    }

    public static String stripTags(String input) {
        if (input == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        char[] chars = input.toCharArray();
        boolean omit = false;
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '<': {
                    omit = true;
                    continue block4;
                }
                case '>': {
                    omit = false;
                    continue block4;
                }
                default: {
                    if (omit) continue block4;
                    out.append(chars[i]);
                }
            }
        }
        return out.toString();
    }

    protected String lowercaseText() {
        if (this.lowercaseText == null) {
            this.lowercaseText = this.theText.toLowerCase();
        }
        return this.lowercaseText;
    }

    public String getStringAfter(String startMark, boolean includeMarkers) {
        return this.getStringAfter(this.currentMarker, startMark, includeMarkers);
    }

    public String getStringAfter(int startFrom, String startMark, boolean includeMarkers) {
        return this.getStringBetween(startFrom, startMark, null, includeMarkers);
    }

    public String getStringBetween(String startMark, String endMark, boolean includeMarkers) {
        return this.getStringBetween(this.currentMarker, startMark, endMark, includeMarkers);
    }

    public String getStringBetween(int startFrom, String startMark, String endMark, boolean includeMarkers) {
        int startCursor;
        if (startFrom == -1) {
            return null;
        }
        boolean caseSensitive = false;
        int endCursor = -1;
        int tempMarker = 0;
        int startMarkLength = 0;
        int endMarkLength = 0;
        if (startMark == null) {
            startCursor = startFrom;
        } else {
            startCursor = this.indexOf(startMark, startFrom, caseSensitive);
            startMarkLength = startMark.length();
        }
        if (startCursor != -1) {
            tempMarker = startCursor + startMarkLength;
            if (endMark == null) {
                endCursor = this.theText.length();
            } else {
                endCursor = this.indexOf(endMark, tempMarker, caseSensitive);
                endMarkLength = endMark.length();
            }
        }
        if (startCursor == -1 || endCursor == -1) {
            return null;
        }
        this.currentMarker = endMark == null ? tempMarker : endCursor + endMarkLength;
        if (includeMarkers) {
            endCursor += endMarkLength;
        } else {
            startCursor = tempMarker;
        }
        return this.theText.substring(startCursor, endCursor);
    }

    public boolean hasMoreTokens(String searchString) {
        return true;
    }

    public boolean hasMoreTokens(String startString, String endString) {
        this.tokenStart = this.indexOf(startString, this.currentMarker);
        if (this.tokenStart == -1) {
            return false;
        }
        this.tokenEnd = this.indexOf(endString, this.tokenStart) + endString.length();
        if (this.tokenEnd == -1) {
            return false;
        }
        this.currentMarker = this.tokenEnd;
        return true;
    }

    public String nextToken() {
        return this.theText.substring(this.tokenStart, this.tokenEnd);
    }

    public int tokenStart() {
        return this.tokenStart;
    }

    public int tokenEnd() {
        return this.tokenEnd;
    }

    public int findAndReplace(char searchChar, String replaceString) {
        int occurrences = 0;
        int currentPosition = 0;
        currentPosition = this.theText.indexOf(searchChar);
        if (currentPosition != -1) {
            int textLength = this.theText.length();
            int previousMarker = 0;
            StringBuffer tempBuffer = new StringBuffer(textLength + replaceString.length());
            do {
                tempBuffer.append(this.theText.substring(previousMarker, currentPosition) + replaceString);
                previousMarker = currentPosition + 1;
                ++occurrences;
            } while (previousMarker < textLength && (currentPosition = this.theText.indexOf(searchChar, previousMarker)) != -1);
            if (previousMarker < textLength) {
                tempBuffer.append(this.theText.substring(previousMarker));
            }
            this.theText = tempBuffer.toString();
        }
        return occurrences;
    }

    public int indexOf(String searchString) {
        return this.indexOf(searchString, 0, false);
    }

    public int indexOf(String searchString, boolean caseSensitive) {
        return this.indexOf(searchString, 0, caseSensitive);
    }

    public int indexOf(String searchString, int startPoint) {
        return this.indexOf(searchString, startPoint, false);
    }

    public int indexOf(String searchString, int startPoint, boolean caseSensitive) {
        if (caseSensitive) {
            return this.theText.indexOf(searchString, startPoint);
        }
        return this.lowercaseText().indexOf(searchString.toLowerCase(), startPoint);
    }

    public String toString() {
        return this.theText;
    }

    public int currentMarker() {
        return this.currentMarker;
    }

    public void setCurrentMarker(int newMarker) {
        this.currentMarker = newMarker;
    }

    public void incrementCurrentMarker(int increment) {
        this.currentMarker += increment;
    }

    public String getString() {
        return this.theText;
    }

    public String encodeFileURL() {
        if (this.theText == null) {
            return null;
        }
        this.theText = IOUtils.encode(this.theText);
        return this.translate(new String[]{"+", "%2F"}, new String[]{"%20", "/"});
    }

    public String trim(String characterList) {
        this.rtrim(characterList);
        return this.ltrim(characterList);
    }

    public String ltrim(String characterList) {
        char c;
        int i;
        if (this.theText == null) {
            return null;
        }
        for (i = 0; i < this.theText.length() && characterList.indexOf(c = this.theText.charAt(i)) != -1; ++i) {
        }
        if (i == this.theText.length()) {
            this.theText = "";
        } else if (i != 0) {
            this.theText = this.theText.substring(i);
        }
        return this.theText;
    }

    public String rtrim(String characterList) {
        char c;
        int i;
        if (this.theText == null) {
            return null;
        }
        for (i = this.theText.length() - 1; i >= 0 && characterList.indexOf(c = this.theText.charAt(i)) != -1; --i) {
        }
        if (i == -1) {
            this.theText = "";
        } else if (i != this.theText.length() - 1) {
            this.theText = this.theText.substring(0, i + 1);
        }
        return this.theText;
    }

    public String translate(String[] from, String[] to) {
        String in = this.theText;
        if (in == null || in.length() == 0) {
            return in;
        }
        if (from.length != to.length) {
            throw new IllegalArgumentException("The length of the from array must equal the length of the to array");
        }
        StringBuffer out = new StringBuffer(in.length() + 32);
        char[][] patterns = new char[from.length][];
        boolean len = false;
        for (int i = 0; i < from.length; ++i) {
            patterns[i] = from[i].toCharArray();
        }
        int lastMatch = 0;
        int length = in.length();
        int patternsLength = patterns.length;
        block1: for (int i = 0; i < length; ++i) {
            block2: for (int patternIndex = 0; patternIndex < patternsLength; ++patternIndex) {
                for (int letter = 0; letter < patterns[patternIndex].length; ++letter) {
                    if (patterns[patternIndex][letter] != in.charAt(i + letter)) continue block2;
                }
                out.append(in.substring(lastMatch, i));
                out.append(to[patternIndex]);
                lastMatch = (i += patterns[patternIndex].length - 1) + 1;
                continue block1;
            }
        }
        if (lastMatch == 0) {
            return in;
        }
        out.append(in.substring(lastMatch));
        this.theText = out.toString();
        return this.theText;
    }

    public String stripTags(String[] allowedTags) {
        Arrays.sort(allowedTags);
        String raw = this.theText.toLowerCase();
        StringBuffer out = new StringBuffer(raw.length());
        int index = 0;
        int match = 0;
        int tmpMatch = 0;
        while ((match = raw.indexOf("<", index)) != -1) {
            out.append(raw.substring(index, match));
            index = match + 1;
            match = raw.indexOf(">", index);
            if (match == -1) break;
            String aTag = raw.substring(index, match);
            if (aTag.charAt(0) == '/') {
                aTag = aTag.substring(1);
            }
            if ((tmpMatch = aTag.indexOf(" ")) > 0) {
                aTag = aTag.substring(0, tmpMatch);
            }
            System.out.println("Found a tag: " + aTag);
            if (Arrays.binarySearch(allowedTags, aTag) >= 0) {
                out.append(this.theText.substring(index - 1, match + 1));
            }
            index = match + 1;
        }
        if (out.length() > 0) {
            this.theText = out.toString();
        }
        return this.theText;
    }

    public List split(String separator) {
        if (this.theText == null || separator == null) {
            return null;
        }
        LinkedList<String> out = new LinkedList<String>();
        int begin = 0;
        int end = 0;
        end = this.theText.indexOf(separator);
        while (end >= 0) {
            out.add(this.theText.substring(begin, end));
            begin = end + 1;
            end = this.theText.indexOf(separator, begin);
        }
        out.add(this.theText.substring(begin));
        return out;
    }
}

