/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import com.prosc.shared.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionUtils {
    public static <K, V> boolean putInMultiMapSet(Map<K, Set<V>> map, K key, V newValue) {
        Set<V> set = map.get(key);
        if (set == null) {
            set = new LinkedHashSet<V>();
            map.put(key, set);
        }
        return set.add(newValue);
    }

    public static <K, V> void putInMultiMap(Map<K, List<V>> map, K key, V newValue) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.add(newValue);
    }

    public static <E> void incrementCountingMap(Map<E, Integer> countingMap, E key, int incrementBy) {
        Integer oldCount = countingMap.get(key);
        if (oldCount == null) {
            countingMap.put(key, incrementBy);
        } else {
            countingMap.put(key, oldCount + incrementBy);
        }
    }

    public static void sort(final @Nullable Comparator comparator, List<?> ... inputs) {
        ListIterator[] iterators = new ListIterator[inputs.length];
        int inputSize = inputs[0].size();
        for (int i = 0; i < iterators.length; ++i) {
            if (inputs[i].size() != inputSize) {
                throw new IllegalArgumentException("All lists must contain the same number of elements, but the first list has " + inputSize + " elements and the current list does not: " + inputs[i]);
            }
            iterators[i] = inputs[i].listIterator();
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>(inputs[0].size());
        while (iterators[0].hasNext()) {
            Object[] row = new Object[iterators.length];
            for (int i = 0; i < iterators.length; ++i) {
                row[i] = iterators[i].next();
            }
            rows.add(row);
        }
        Collections.sort(rows, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                if (comparator == null) {
                    return ((Comparable)o1[0]).compareTo(o2[0]);
                }
                return comparator.compare(o1[0], o2[0]);
            }
        });
        iterators = new ListIterator[inputs.length];
        for (int i = 0; i < iterators.length; ++i) {
            iterators[i] = inputs[i].listIterator();
        }
        for (Object[] row : rows) {
            for (int i = 0; i < iterators.length; ++i) {
                ListIterator listIterator = iterators[i];
                listIterator.next();
                listIterator.set(row[i]);
            }
        }
    }

    @NotNull
    public static <E> E last(List<E> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("List is empty");
        }
        E e = list.get(list.size() - 1);
        if (e == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/shared/CollectionUtils", "last"));
        }
        return e;
    }

    public static <E> E last(List<E> list, @Nullable E valueWhenEmpty) {
        if (list.isEmpty()) {
            return valueWhenEmpty;
        }
        return list.get(list.size() - 1);
    }

    public static <T> Collection<T> addAll(Collection<T> collection, T ... elements) {
        Collections.addAll(collection, elements);
        return collection;
    }

    public static <E> ArrayList<E> newArrayList(E ... object) {
        ArrayList result = new ArrayList();
        Collections.addAll(result, object);
        return result;
    }

    public static <In, Out> List<Out> transform(List<In> input, Function<In, Out> function) {
        ArrayList<Out> result = new ArrayList<Out>(input.size());
        for (In in : input) {
            result.add(function.invoke(in));
        }
        return result;
    }

    public static <E> List<E> filter(Collection<E> input, Function<E, Boolean> filter) {
        ArrayList<E> result = new ArrayList<E>(input.size());
        for (E e : input) {
            if (!filter.invoke(e).booleanValue()) continue;
            result.add(e);
        }
        return result;
    }
}

