/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.license.client.network;

import com.prosc.io.IOUtils;
import com.prosc.license.client.InvalidLicenseException;
import com.prosc.license.client.LicenseExceededException;
import com.prosc.license.client.Registration;
import com.prosc.license.client.network.LicenseParams;
import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class OnlineModel {
    private static final Logger log = Logger.getLogger(OnlineModel.class.getName());
    private static final String ACTION_HANDSHAKE = "handshake";
    private static final String ACTION_HEARTBEAT = "heartbeat";
    private static final String ACTION_DISCONNECT = "disconnect";
    private final URL serverBaseUrl;
    private final LicenseParams params;
    private int _heartbeat = 40000;
    public String _licenseKey;
    private String _lastResponse;
    private static Set<String> callingThreads = new HashSet<String>();
    private static final AtomicInteger threadCount = new AtomicInteger(0);

    public OnlineModel(LicenseParams params) {
        this(params, "https://secure2.360works.com/WSMRegister/LicenseCheck/");
    }

    OnlineModel(LicenseParams params, String spec) {
        this.params = params;
        this.serverBaseUrl = IOUtils.toUrl(spec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String contactServer(@Nullable String optionalSessionId) throws IOException, InvalidLicenseException {
        String result;
        String response;
        boolean doHandshake;
        HttpURLConnection conn;
        block24: {
            conn = null;
            doHandshake = true;
            response = null;
            if (optionalSessionId != null) {
                conn = OnlineModel.createUrlConnection(this.serverBaseUrl, ACTION_HEARTBEAT, 6000);
                log.fine("Connecting to server URL " + conn.getURL() + " for heartbeat request");
                if (this.params.updateFromDatabaseOnEveryRequest) {
                    conn.setRequestProperty("readFromDatabase", "1");
                }
                conn.setRequestProperty("session", optionalSessionId);
                conn.setDoOutput(false);
                try {
                    response = OnlineModel.getUrlContentsAndClose(conn);
                    if (conn.getResponseCode() == 200) {
                        doHandshake = false;
                    }
                }
                catch (IOException e) {
                    if (!log.isLoggable(Level.FINE)) break block24;
                    log.log(Level.FINE, "Error sending heartbeat request; will switch to initial handshake", e);
                }
            }
        }
        if (doHandshake) {
            conn = OnlineModel.createUrlConnection(this.serverBaseUrl, ACTION_HANDSHAKE, 6000);
            log.fine("Connecting to server URL " + conn.getURL() + " to check license key");
            if (this.params.updateFromDatabaseOnEveryRequest) {
                conn.setRequestProperty("readFromDatabase", "1");
            }
            if (optionalSessionId != null) {
                conn.setRequestProperty("session", optionalSessionId);
            }
            conn.setDoOutput(true);
            Registration reg = this.params.registration;
            String postArgs = "<LicenseCheck><RegisteredTo>" + reg.getCompanyName() + "</RegisteredTo>" + "<LicenseKey>" + reg.getLicenseKey() + "</LicenseKey>" + "<ProductCode>" + reg.getStoreNumber() + "</ProductCode>" + "<MajorVersion>" + reg.getMajorVersion() + "</MajorVersion>" + "<MajorReleaseDate>" + (reg.getMajorReleaseDate() == null ? "" : String.valueOf(reg.getMajorReleaseDate().getTime())) + "</MajorReleaseDate>" + "<VersionString>" + reg.getVersionName() + "</VersionString>" + "<ExtraInfo>" + (this.params.extraInfo == null ? "" : this.params.extraInfo) + "</ExtraInfo>" + "<FmEnvironment>" + (this.params.fmEnvironment == null ? "" : this.params.fmEnvironment) + "</FmEnvironment>" + "</LicenseCheck>";
            log.fine("Sending initial license check: " + postArgs);
            try {
                OutputStream output = conn.getOutputStream();
                try {
                    conn.getOutputStream().write(postArgs.getBytes("utf-8"));
                    output.flush();
                }
                finally {
                    output.close();
                }
            }
            catch (IOException e) {
                URL url = conn.getURL();
                if ("localhost".equals(url.getHost())) {
                    throw new IllegalStateException("This build of MirrorSync is in development mode, and cannot communicate with the license server. Please contact 360Works for a production build.", e);
                }
                throw new IOException("Error while connecting to " + url, e);
            }
            response = OnlineModel.getUrlContentsAndClose(conn);
        }
        if (doHandshake || this.params.updateFromDatabaseOnEveryRequest) {
            if (conn.getHeaderField("LicenseSuccess") == null) {
                this.handleLicenseFailure(response, conn.getHeaderField("LicenseFailure"), Boolean.valueOf(conn.getHeaderField("LicenseExceeded")));
            } else {
                log.fine("Registered successfully with license server at " + this.serverBaseUrl);
                if (optionalSessionId == null) {
                    String startTag = "<replacementKey>";
                    String endTag = "</replacementKey>";
                    int from = response.indexOf(startTag) + startTag.length();
                    int to = response.indexOf(endTag, from);
                    if (from == -1 || to == -1) {
                        throw new IOException("Communication with the licensing server; got an unexpected responses: " + response);
                    }
                    this.setLicenseKey(response.substring(from, to));
                }
                if (response.length() > 0) {
                    this.setLastResponse(response);
                }
            }
        }
        if (doHandshake) {
            result = conn.getHeaderField("session");
            if (result == null || result.length() == 0) {
                throw new IOException("License check was successful, but no sessionId was provided by the server");
            }
            log.fine("Connected to license server with session ID " + result);
        } else {
            result = optionalSessionId;
            log.fine("Heartbeat successful to license server for session ID " + result);
        }
        String heartbeatString = conn.getHeaderField(ACTION_HEARTBEAT);
        if (!StringUtils.isEmpty(heartbeatString)) {
            this.setHeartbeat(Integer.parseInt(heartbeatString));
        }
        return result;
    }

    public synchronized int getHeartbeat() {
        return this._heartbeat;
    }

    private synchronized void setHeartbeat(int heartbeat) {
        this._heartbeat = heartbeat;
    }

    public synchronized String getLicenseKey() {
        return this._licenseKey;
    }

    private void setLicenseKey(String licenseKey) {
        this._licenseKey = licenseKey;
    }

    private synchronized void setLastResponse(String lastResponse) {
        this._lastResponse = lastResponse;
    }

    public synchronized String getLastResponse() {
        return this._lastResponse;
    }

    private void handleLicenseFailure(String responseBody, String failureMessage, Boolean licenseExceeded) throws IOException, InvalidLicenseException {
        if (failureMessage == null) {
            throw new IOException("Unknown response from License server. Make sure the registration server is running at " + this.serverBaseUrl + "\n" + responseBody);
        }
        if (Boolean.TRUE.equals(licenseExceeded)) {
            throw new LicenseExceededException("INVALID - " + failureMessage, this.params.registration.getLicense());
        }
        throw new InvalidLicenseException("INVALID - " + failureMessage, this.params.registration.getLicenseKey());
    }

    void sendServerDisconnect(String sessionId) {
        try {
            HttpURLConnection conn = OnlineModel.createUrlConnection(this.serverBaseUrl, ACTION_DISCONNECT, 300);
            log.config("Closing connection to license server at " + conn.getURL());
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.setRequestProperty("session", sessionId);
            OnlineModel.getUrlContentsAndClose(conn);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error occurred while sending disconnect message to LicenseServer: " + e.toString(), e);
        }
    }

    private static HttpURLConnection createUrlConnection(URL baseUrl, String action, int readTimeout) throws IOException {
        try {
            URL url = new URL(baseUrl, action);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(readTimeout);
            conn.setUseCaches(false);
            return conn;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUrlContentsAndClose(HttpURLConnection conn) throws IOException {
        String message;
        AtomicInteger atomicInteger = threadCount;
        synchronized (atomicInteger) {
            if (callingThreads.add(Thread.currentThread().getName())) {
                message = "Calling license server from new thread: " + Thread.currentThread().getName();
                int newThreadCount = threadCount.incrementAndGet();
                if (newThreadCount > 1) {
                    log.log(Level.WARNING, message, new RuntimeException("OnlineModel should not be called by more than one thread; there are now " + newThreadCount + " threads"));
                } else {
                    log.log(Level.INFO, message);
                }
            }
        }
        InputStream stream = conn.getInputStream();
        try {
            message = IOUtils.inputStreamAsString(stream);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                try {
                    String errorMessage;
                    InputStream errStream = conn.getErrorStream();
                    if (errStream == null) {
                        errorMessage = "<no error stream>";
                    } else {
                        errorMessage = IOUtils.inputStreamAsString(errStream);
                        errStream.close();
                    }
                    log.log(Level.WARNING, "OnlineModel heartbeat failed with error message: " + errorMessage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }
        stream.close();
        return message;
    }
}

