/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SimpleXmlParser {
    private StringBuffer currentElement;
    private XMLReader xReader;
    private EventHandler handler;
    private Map values;

    public SimpleXmlParser() {
        try {
            this.xReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        this.handler = new EventHandler();
        this.xReader.setContentHandler(this.handler);
        this.xReader.setErrorHandler(this.handler);
    }

    public synchronized Map parse(InputStream stream) throws IOException, SAXException {
        this.currentElement = new StringBuffer();
        this.values = new HashMap();
        this.xReader.parse(new InputSource(stream));
        return this.values;
    }

    public static void main(String[] args) throws Exception {
        Map result = new SimpleXmlParser().parse(new FileInputStream(args[0]));
        System.out.println(result);
    }

    private class EventHandler
    extends DefaultHandler {
        private EventHandler() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes atts) {
            SimpleXmlParser.this.currentElement.append(qName + '/');
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            SimpleXmlParser.this.currentElement.setLength(SimpleXmlParser.this.currentElement.length() - qName.length() - 1);
        }

        @Override
        public void characters(char[] ch, int offset, int length) {
            String theString = new String(ch, offset, length).trim();
            if (theString.length() > 0) {
                SimpleXmlParser.this.values.put(SimpleXmlParser.this.currentElement.toString(), theString);
            }
        }
    }
}

