/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.jetbrains.annotations.Nullable;

public final class InputStreamInfo {
    private final InputStream stream;
    private final String name;
    private final long length;
    private final String contentType;
    private File file;
    private String contentEncoding;

    public InputStreamInfo(File file) throws FileNotFoundException {
        this(file.isDirectory() ? null : new FileInputStream(file), file.getName(), file.length());
        this.file = file;
    }

    public InputStreamInfo(File file, @Nullable String optionalContentType) throws FileNotFoundException {
        this(file.isDirectory() ? null : new FileInputStream(file), file.getName(), file.length(), optionalContentType);
        this.file = file;
    }

    public InputStreamInfo(InputStream stream, String name, long length) {
        this(stream, name, length, null);
    }

    public InputStreamInfo(InputStream stream, String name, long length, @Nullable String optionalContentType) {
        this.stream = stream;
        this.name = name;
        this.length = length;
        this.contentType = optionalContentType;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String getName() {
        return this.name;
    }

    public long getLength() {
        return this.length;
    }

    public String getContentType() {
        return this.contentType;
    }

    public File getFile() {
        return this.file;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }
}

