/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.CharArrayWriter;
import java.nio.charset.Charset;
import java.util.BitSet;

public class AwsUrlEncoder {
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;
    static String dfltEncName;

    private AwsUrlEncoder() {
    }

    public static String encode(String s) {
        Charset charset;
        boolean needToChange = false;
        StringBuffer out = new StringBuffer(s.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        String enc = "utf-8";
        if (enc == null) {
            throw new NullPointerException("charsetName");
        }
        try {
            charset = Charset.forName(enc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (dontNeedEncoding.get(c)) {
                out.append(c);
                ++i;
                continue;
            }
            do {
                char d;
                charArrayWriter.write(c);
                if (c < '\ud800' || c > '\udbff' || i + 1 >= s.length() || (d = s.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                charArrayWriter.write(d);
                ++i;
            } while (++i < s.length() && !dontNeedEncoding.get(c = s.charAt(i)));
            charArrayWriter.flush();
            String str = new String(charArrayWriter.toCharArray());
            byte[] ba = str.getBytes(charset);
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            charArrayWriter.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }

    static {
        int i;
        dfltEncName = null;
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(126);
        dfltEncName = "utf-8";
    }
}

