/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.infrastructure;

import com.prosc.Platform;
import com.prosc.infrastructure.SimpleFormatterThreadsafe;
import com.prosc.io.IOUtils;
import com.prosc.shared.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.jetbrains.annotations.Nullable;

public class LogUtils {
    private static final Logger log = Logger.getLogger(LogUtils.class.getName());
    private static Map<String, File> tempLogFiles = new HashMap<String, File>(1);

    public static boolean isFileLoggingEnabled() {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            if (!(handler instanceof FileHandler)) continue;
            return true;
        }
        return false;
    }

    public static void enableThreadsafeLogging() {
        LogManager manager = LogManager.getLogManager();
        ArrayList<String> loggerNames = Collections.list(manager.getLoggerNames());
        for (String loggerName : loggerNames) {
            for (Handler handler : manager.getLogger(loggerName).getHandlers()) {
                if (!(handler.getFormatter() instanceof SimpleFormatter)) continue;
                handler.setFormatter(new SimpleFormatterThreadsafe());
            }
        }
    }

    public static File enableTempLogging(String filename) throws IOException {
        File logDest;
        File logFolder;
        if (tempLogFiles.containsKey(filename)) {
            return tempLogFiles.get(filename);
        }
        File file = logFolder = Platform.current.unixLike ? new File("/tmp") : new File("C:\\Windows\\Temp");
        if (!logFolder.exists() || !logFolder.canWrite()) {
            logFolder = IOUtils.findWriteableTempDirectory();
        }
        if ((logDest = new File(logFolder, filename)).exists() && (logDest.isDirectory() || !logDest.canWrite())) {
            logDest = IOUtils.ensureUniqueFilename(logDest);
        }
        try {
            FileHandler handler = new FileHandler(logDest.getAbsolutePath());
            handler.setFormatter(new SimpleFormatter());
            Logger.getLogger("").addHandler(handler);
            tempLogFiles.put(filename, logDest);
            log.info("Temporary logging enabled to file " + logDest.getAbsolutePath());
            return logDest;
        }
        catch (IOException e) {
            IOException ioe = new IOException("Could not enable temp logging because a new FileHandler could not be created");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public static File locateLogFile() {
        return LogUtils.locateLogFile(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File locateLogFile(final @Nullable String prefixToMatch, @Nullable Date requestedDate) {
        File result = null;
        Handler[] handlers = LogManager.getLogManager().getLogger("").getHandlers();
        Handler whichHandler = null;
        try {
            Handler[] arr$ = handlers;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Handler handler;
                whichHandler = handler = arr$[i$];
                try {
                    boolean prefixMatches;
                    Class<?> handlerClass = handler.getClass();
                    if (handler instanceof ConsoleHandler) continue;
                    if (handler instanceof FileHandler) {
                        Field filesField = handlerClass.getDeclaredField("files");
                        filesField.setAccessible(true);
                        File[] files = (File[])filesField.get(handler);
                        result = LogUtils.getFile(requestedDate, files, false);
                        break;
                    }
                    Field directoryField = handlerClass.getDeclaredField("directory");
                    Field prefixField = handlerClass.getDeclaredField("prefix");
                    directoryField.setAccessible(true);
                    prefixField.setAccessible(true);
                    String directory = (String)directoryField.get(handler);
                    String logPrefix = (String)prefixField.get(handler);
                    boolean bl = prefixMatches = prefixToMatch != null && prefixToMatch.equals(logPrefix);
                    if (result != null && !prefixMatches) continue;
                    File logDirectory = new File(directory);
                    if (!logDirectory.exists() || !logDirectory.isDirectory()) {
                        log.log(Level.WARNING, "Log directory " + directory + " does not exist, or is not a directory");
                        continue;
                    }
                    File[] logFiles = logDirectory.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            if (prefixMatches) {
                                return pathname.getName().startsWith(prefixToMatch);
                            }
                            return true;
                        }
                    });
                    if (logFiles == null || logFiles.length == 0) continue;
                    result = LogUtils.getFile(requestedDate, logFiles, true);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
        }
        catch (IllegalAccessException e) {
            log.log(Level.WARNING, "Couldn't get log file", e);
        }
        finally {
            if (whichHandler != null) {
                whichHandler.flush();
            }
        }
        return result;
    }

    public static File getFile(Date requestedDate, File[] logFiles, final boolean prioritizeCatalina) {
        Arrays.sort(logFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (prioritizeCatalina && o1.getName().startsWith("catalina.") && !o2.getName().startsWith("catalina.")) {
                    return -1;
                }
                if (prioritizeCatalina && !o1.getName().startsWith("catalina.") && o2.getName().startsWith("catalina.")) {
                    return 1;
                }
                return o1.lastModified() == o2.lastModified() ? 0 : (o1.lastModified() > o2.lastModified() ? -1 : 1);
            }
        });
        File result = logFiles[0];
        for (File logFile : logFiles) {
            if (requestedDate == null || logFile.lastModified() <= requestedDate.getTime()) break;
            result = logFile;
        }
        return result;
    }

    public static String getSystemInfo() {
        String catalinaHome = System.getenv("CATALINA_HOME");
        String catalinaBase = System.getenv("CATALINA_BASE");
        try {
            catalinaHome = new File(catalinaHome).getCanonicalPath();
            catalinaBase = new File(catalinaBase).getCanonicalPath();
        }
        catch (Exception e) {
            // empty catch block
        }
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirPath);
        URL classUrl = LogUtils.class.getResource("LogUtils.class");
        String localhostHostname = "<Unknown>";
        String localhostIp = "<Unknown>";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            localhostIp = inetAddress.getHostAddress();
            localhostHostname = inetAddress.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            log.log(Level.WARNING, "Couldn't get local host", e);
        }
        return "java.version: " + System.getProperty("java.version") + " / jvm version: " + System.getProperty("java.vm.version") + " / JAVA_JVM_VERSION is " + System.getenv("JAVA_JVM_VERSION") + StringUtils.CR + "java.home: " + System.getProperty("java.home") + StringUtils.CR + "JVM name: " + System.getProperty("java.vm.name") + StringUtils.CR + "Tomcat home directory: " + catalinaHome + "; Tomcat base directory: " + catalinaBase + StringUtils.CR + "LogUtils class location: " + classUrl + StringUtils.CR + "Operating system info: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " running on " + System.getProperty("os.arch") + " architecture (" + System.getProperty("sun.arch.data.model") + " bit)" + StringUtils.CR + "Temp directory: " + tmpDir.getAbsolutePath() + "; exists is " + tmpDir.exists() + "; writeable is " + tmpDir.canWrite() + StringUtils.CR + "Working directory: " + System.getProperty("user.dir") + StringUtils.CR + "System character encoding: " + System.getProperty("file.encoding") + StringUtils.CR + "Local hostname: " + localhostHostname + " and local IP address: " + localhostIp + StringUtils.CR + "http.nonProxyHosts: " + System.getProperty("http.nonProxyHosts") + StringUtils.CR + "socksNonProxyHosts: " + System.getProperty("socksNonProxyHosts") + StringUtils.CR + "ftp.nonProxyHosts: " + System.getProperty("ftp.nonProxyHosts") + StringUtils.CR + "Process name/ID: " + ManagementFactory.getRuntimeMXBean().getName() + StringUtils.CR + "User name is " + System.getProperty("user.name") + " and home directory is " + System.getProperty("user.home") + "; writeable is " + new File(System.getProperty("user.home")).canWrite() + StringUtils.CR + "Locale is " + Locale.getDefault().getDisplayName() + " and time zone is " + TimeZone.getDefault().getDisplayName(true, 1, Locale.US) + "(GMT offset " + TimeZone.getDefault().getOffset(System.currentTimeMillis()) + " milliseconds )" + StringUtils.CR + "Current local time is " + new Date() + StringUtils.CR + "Available processors: " + Runtime.getRuntime().availableProcessors() + StringUtils.CR + "Max heap size is " + Runtime.getRuntime().maxMemory() + "; free memory is " + Runtime.getRuntime().freeMemory() + "; total memory is " + Runtime.getRuntime().totalMemory();
    }
}

