/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Date;

public class RelativeDateFormat
extends Format {
    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        String str = this.formatWorker((Date)obj);
        pos.setEndIndex(str.length());
        return toAppendTo.append(str);
    }

    public String formatWorker(Date date) {
        if (date == null) {
            return "";
        }
        long now = System.currentTimeMillis();
        long when = date.getTime();
        int seconds = (int)((when - now) / 1000L);
        boolean inThePast = seconds < 0;
        String term = inThePast ? "ago" : "from now";
        if ((seconds = Math.abs(seconds)) < 60) {
            return seconds == 1 ? "one second " + term : seconds + " seconds " + term;
        }
        if (seconds < 120) {
            return "a minute " + term;
        }
        int minutes = seconds / 60;
        if (seconds < 2700) {
            return minutes + " minutes " + term;
        }
        if (seconds < 5400) {
            return "an hour " + term;
        }
        int hours = minutes / 60;
        if (seconds < 86400) {
            return hours + " hours " + term;
        }
        if (seconds < 172800) {
            return inThePast ? "yesterday" : "tomorrow";
        }
        int days = hours / 24;
        if (seconds < 2592000) {
            return days + " days " + term;
        }
        int months = days / 30;
        if (seconds < 31104000) {
            return months <= 1 ? "one month " + term : months + " months " + term;
        }
        int years = days / 365;
        return years <= 1 ? "one year " + term : years + " years " + term;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        throw new UnsupportedOperationException("RelativeDateFormat does not support parsing text input");
    }
}

