/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmplugin;

import com.prosc.fmkit.PluginBridge;
import com.prosc.fmplugin.ChartModelInterface;
import com.prosc.fmplugin.ChartModelUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.SpiderWebPlot;
import org.jfree.data.category.DefaultCategoryDataset;

public class RadarChartModel
implements ChartModelInterface {
    private static final Logger log = Logger.getLogger(RadarChartModel.class.getName());
    private DefaultCategoryDataset radarDataSet = new DefaultCategoryDataset();
    private SpiderWebPlot radarPlot = new SpiderWebPlot(this.radarDataSet);
    private JFreeChart radarChart;

    public RadarChartModel(String title) {
        this.radarChart = new JFreeChart(title, this.radarPlot);
    }

    @Override
    public void setValue(double value, String rowOrSeries, Comparable columnOrCategory) {
        this.radarDataSet.setValue(value, (Comparable)((Object)rowOrSeries), columnOrCategory);
    }

    @Override
    public void setSeriesColor(String category, int red, int green, int blue, int alpha) {
        int seriesIndex = this.radarDataSet.getRowKeys().indexOf(category);
        PluginBridge.initAwt();
        if (seriesIndex < 0) {
            throw new IllegalArgumentException("Unknown category '" + category + "'.  You should call chartSetColor AFTER adding values to the chart.");
        }
        Color c = ChartModelUtils.createColor(red, green, blue, alpha);
        this.radarPlot.setSeriesPaint(seriesIndex, c);
    }

    @Override
    public BufferedImage getFinishedChart(int width, int height, Properties additionalParams) throws IOException {
        Properties testProp = new Properties();
        testProp.setProperty("valueaxis.showticklabels", "true");
        testProp.setProperty("valueaxis.showtickmarks", "true");
        testProp.setProperty("legend", "false");
        this.applyAdditionalParams(testProp);
        return this.radarChart.createBufferedImage(width, height);
    }

    private void applyAdditionalParams(Properties p) {
        ChartModelUtils.applyCommonParams(p, this);
    }

    @Override
    public JFreeChart getChart() {
        return this.radarChart;
    }
}

