/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmplugin;

import com.prosc.fmkit.PluginBridge;
import com.prosc.fmplugin.ChartModelInterface;
import com.prosc.fmplugin.ChartModelUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PieChartModel
implements ChartModelInterface {
    private static final Logger log = Logger.getLogger(PieChartModel.class.getName());
    private DefaultPieDataset pieDataSet = new DefaultPieDataset();
    JFreeChart pieChart;

    public PieChartModel(String name, boolean use3d) {
        this.pieChart = use3d ? ChartFactory.createPieChart3D(name, (PieDataset)this.pieDataSet, true, false, false) : ChartFactory.createPieChart(name, (PieDataset)this.pieDataSet, true, false, false);
    }

    @Override
    public void setValue(double value, String rowOrSeries, Comparable columnOrCategory) {
        this.pieDataSet.setValue(columnOrCategory, value);
    }

    @Override
    public JFreeChart getChart() {
        return this.pieChart;
    }

    @Override
    public void setSeriesColor(String category, int red, int green, int blue, int alpha) {
        if (category == null) {
            throw new IllegalArgumentException("Cannot call pieChartSetSeriesColor with an empty name");
        }
        PluginBridge.initAwt();
        Color c = ChartModelUtils.createColor(red, green, blue, alpha);
        PiePlot plot = (PiePlot)this.pieChart.getPlot();
        plot.setSectionPaint((Comparable)((Object)category), (Paint)c);
    }

    @Override
    public BufferedImage getFinishedChart(int width, int height, Properties additionalParams) throws IOException {
        this.applyAdditionalParams(additionalParams);
        return this.pieChart.createBufferedImage(width, height);
    }

    private void applyAdditionalParams(Properties p) {
        ChartModelUtils.applyCommonParams(p, this);
        PiePlot piePlot = (PiePlot)this.pieChart.getPlot();
        String param = p.getProperty("explodeSeries");
        if (param != null) {
            try {
                int index = Integer.parseInt(param);
                piePlot.setExplodePercent(index, 0.3);
            }
            catch (NumberFormatException e) {
                piePlot.setExplodePercent((Comparable)((Object)param), 0.3);
            }
        }
        if ((param = p.getProperty("strokeWidth")) != null) {
            piePlot.setSectionOutlineStroke(new BasicStroke(Float.parseFloat(param), 0, 0));
        }
        if ((param = p.getProperty("outlines")) != null) {
            piePlot.setSectionOutlinesVisible(ChartModelUtils.boolForParam(param));
        }
        if ((param = p.getProperty("outlineColor")) != null) {
            log.log(Level.INFO, "outlineColor not implemented");
        }
        if (!ChartModelUtils.boolForParam(p.getProperty("hideLabels"))) {
            param = p.getProperty("label", "{0} = {1}");
            piePlot.setLabelGenerator(new StandardPieSectionLabelGenerator(param));
        } else {
            piePlot.setLabelGenerator(null);
        }
    }
}

