/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmplugin;

import com.prosc.core.FeedbackException;
import com.prosc.fmkit.FMFunction;
import com.prosc.fmkit.PluginBridge;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.QuadChar;
import com.prosc.fmkit.RegisterablePlugin;
import com.prosc.fmkit.StaticFunction;
import com.prosc.fmkit.types.FMBinary;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMType;
import com.prosc.fmplugin.BarChartModel;
import com.prosc.fmplugin.ChartModelInterface;
import com.prosc.fmplugin.LineChartModel;
import com.prosc.fmplugin.PieChartModel;
import com.prosc.fmplugin.TimeSeriesChartModel;
import com.prosc.license.client.InvalidLicenseException;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.jfree.chart.encoders.EncoderUtil;

public class ChartPlugin
extends RegisterablePlugin {
    ChartModelInterface model;

    @Override
    public QuadChar getShortId() {
        return new QuadChar("3CHR");
    }

    @Override
    public String getName() {
        return "360Works Charts";
    }

    @Override
    public String getHelpText() {
        return "Charting support for Filemaker";
    }

    @Override
    public boolean customizeFunction(StaticFunction eachFunction) {
        boolean guiFunction = eachFunction.getName().endsWith("ChartCreate");
        eachFunction.setGuiFunction(guiFunction);
        return true;
    }

    public String chartRegisterPrototype() {
        return "key ; registeredTo";
    }

    public String ChartLastErrorPrototype() {
        return "";
    }

    public FMType chartLastError() {
        return this.defaultLastError();
    }

    @FMFunction(prototype="errorCapture")
    public FMType chartSetErrorCapture(boolean errorCapture) {
        return super.defaultSetErrorCapture(errorCapture);
    }

    @FMFunction(prototype="key ; registeredTo")
    public FMType chartRegister(String licenseKey, String registeredTo) throws InvalidLicenseException {
        return this.defaultRegister(licenseKey, registeredTo);
    }

    public FMType chartVersion() {
        return this.defaultVersion();
    }

    public FMType chartLicenseInfo() {
        return this.defaultLicenseInfo();
    }

    public String pieChartCreatePrototype() {
        return "name { ; 3d }";
    }

    @FMFunction(prototype="name { ; 3d }")
    public FMType pieChartCreate(String name, boolean use3d) {
        this.model = new PieChartModel(name, use3d);
        return this.successValue();
    }

    public String pieChartSetDataPointPrototype() {
        return "category ; value";
    }

    @FMFunction(prototype="category ; value")
    public FMType pieChartSetDataPoint(String category, String value) {
        if (category != null) {
            String[] values = value.split("\n");
            if (values.length > 0) {
                try {
                    for (int i = 0; i < values.length; ++i) {
                        double singleValue = Double.parseDouble(values[i]);
                        this.getModelNotNull().setValue(singleValue, null, (Comparable)((Object)category));
                    }
                }
                catch (NumberFormatException e) {
                    throw new NumberFormatException("the value must be numeric, or if passing in a list, list must be \ufffd (return) separated.");
                }
            } else {
                throw new IllegalArgumentException("must specify a single value or a return separated list");
            }
        }
        return this.successValue();
    }

    public String pieChartSetSeriesColorPrototype() {
        return "category ; red ; green ; blue ; alpha";
    }

    @FMFunction(prototype="category ; red ; green ; blue ; alpha")
    public FMType pieChartSetSeriesColor(String category, int red, int green, int blue, int alpha) {
        this.getModelNotNull().setSeriesColor(category, red, green, blue, alpha);
        return this.successValue();
    }

    public String pieChartShowGraphicPrototype() {
        return "width ; height { ; additionalParams... }";
    }

    @FMFunction(prototype="width ; height { ; additionalParams... }")
    public FMType pieChartShowGraphic(int width, int height, String[] additionalParams) throws IOException {
        BufferedImage image = this.getModelNotNull().getFinishedChart(width, height, PluginUtils.convertKeyValuesToMap(additionalParams));
        return this.chartGraphic(image);
    }

    public String barChartCreatePrototype() {
        return "name ; categoryAxisLabel ; valueAxisLabel { ; isVertical ; use3d }";
    }

    @FMFunction(prototype="name ; categoryAxisLabel ; valueAxisLabel { ; isVertical ; use3d }")
    public FMType barChartCreate(String name, String categoryAxisLabel, String valueAxisLabel, boolean isVertical, boolean use3d) {
        this.model = new BarChartModel(name, categoryAxisLabel, valueAxisLabel, isVertical, use3d);
        return this.successValue();
    }

    public String barChartSetDataPointPrototype() {
        return "group, category ; value";
    }

    @FMFunction(prototype="group, category ; value")
    public FMType barChartSetDataPoint(String group, String category, double value) {
        if (category != null) {
            this.getModelNotNull().setValue(value, group, (Comparable)((Object)category));
        }
        return this.successValue();
    }

    public String barChartSetSeriesColorPrototype() {
        return "category ; red ; green ; blue ; alpha";
    }

    @FMFunction(prototype="category ; red ; green ; blue ; alpha")
    public FMType barChartSetSeriesColor(String category, int red, int green, int blue, int alpha) {
        if (category == null) {
            throw new IllegalArgumentException("Cannot call barChartSetSeriesColor with an empty category");
        }
        this.getModelNotNull().setSeriesColor(category, red, green, blue, alpha);
        return this.successValue();
    }

    public String barChartShowGraphicPrototype() {
        return "width ; height { ; additionalParams... }";
    }

    @FMFunction(prototype="width ; height { ; additionalParams... }")
    public FMType barChartShowGraphic(int width, int height, String[] additionalParams) throws IOException {
        return this.chartGraphic(this.getModelNotNull().getFinishedChart(width, height, PluginUtils.convertKeyValuesToMap(additionalParams)));
    }

    public String lineChartCreatePrototype() {
        return "name ; categoryAxisLabel ; valueAxisLabel { ; isVertical ; use3d }";
    }

    @FMFunction(prototype="name ; categoryAxisLabel ; valueAxisLabel { ; isVertical ; use3d }")
    public FMType lineChartCreate(String name, String categoryAxisLabel, String valueAxisLabel, boolean isVertical, boolean use3d) {
        this.model = new LineChartModel(name, categoryAxisLabel, valueAxisLabel, isVertical, use3d);
        return this.successValue();
    }

    public String lineChartSetDataPointPrototype() {
        return "seriesName ; category ; value";
    }

    @FMFunction(prototype="seriesName ; category ; value")
    public FMType lineChartSetDataPoint(String seriesName, String category, String value) throws Exception {
        if (category != null) {
            String[] values = value.split("\n");
            if (values.length > 0) {
                try {
                    for (int i = 0; i < values.length; ++i) {
                        double singleValue = Double.parseDouble(values[i]);
                        this.getModelNotNull().setValue(singleValue, seriesName, (Comparable)((Object)category));
                    }
                }
                catch (NumberFormatException e) {
                    throw new NumberFormatException("the value must be numeric, or if passing in a list, list must be \ufffd (return) separated.");
                }
            } else {
                throw new IllegalArgumentException("must specify a single value or a return separated list");
            }
        }
        return this.successValue();
    }

    public String lineChartSetSeriesColorPrototype() {
        return "category ; red ; green ; blue ; alpha";
    }

    @FMFunction(prototype="category ; red ; green ; blue ; alpha")
    public FMType lineChartSetSeriesColor(String category, int red, int green, int blue, int alpha) {
        if (category == null) {
            return new FMText("Cannot call lineChartSetSeriesColor with an empty category");
        }
        this.getModelNotNull().setSeriesColor(category, red, green, blue, alpha);
        return this.successValue();
    }

    public String lineChartShowGraphicPrototype() {
        return "width ; height { ; additionalParams... }";
    }

    @FMFunction(prototype="width ; height { ; additionalParams... }")
    public FMType lineChartShowGraphic(int width, int height, String[] additionalParams) throws IOException {
        return this.chartGraphic(this.getModelNotNull().getFinishedChart(width, height, PluginUtils.convertKeyValuesToMap(additionalParams)));
    }

    public String timeSeriesChartCreatePrototype() {
        return "name ; timeAxisLabel ; valueAxisLabel";
    }

    @FMFunction(prototype="name ; timeAxisLabel ; valueAxisLabel")
    public FMType timeSeriesChartCreate(String name, String timeAxisLabel, String valueAxisLabel) {
        this.model = new TimeSeriesChartModel(name, timeAxisLabel, valueAxisLabel);
        return this.successValue();
    }

    public String timeSeriesChartSetDataPointPrototype() {
        return "seriesName ; dateOrTime ; value";
    }

    @FMFunction(prototype="seriesName ; dateOrTime ; value")
    public FMType timeSeriesChartSetDataPoint(String seriesName, String date, String value) throws ParseException, FeedbackException {
        String[] dates;
        if (value == null || date == null) {
            throw new FeedbackException("No date or value was supplied");
        }
        String[] values = value.split("\n");
        if (values.length != (dates = date.split("\n")).length) {
            throw new IllegalArgumentException("when using lists for date and value parameters, make sure that lists are of same length.");
        }
        if (values.length > 0) {
            try {
                for (int i = 0; i < values.length; ++i) {
                    double singleValue = Double.parseDouble(values[i]);
                    SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
                    Date singleDate = formatter.parse(dates[i]);
                    this.getModelNotNull().setValue(singleValue, seriesName, singleDate);
                }
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("the value must be numeric, or if passing in a list, list must be \ufffd (return) separated.");
            }
        } else {
            throw new IllegalArgumentException("must specify a single value or a return separated list");
        }
        return this.successValue();
    }

    public String timeSeriesChartSetSeriesColorPrototype() {
        return "seriesName ; red ; green ; blue ; alpha";
    }

    @FMFunction(prototype="seriesName ; red ; green ; blue ; alpha")
    public FMType timeSeriesChartSetSeriesColor(String seriesName, int red, int green, int blue, int alpha) {
        if (seriesName == null) {
            throw new IllegalArgumentException("Cannot call timeSeriesChartSetSeriesColor with an empty seriesName");
        }
        this.getModelNotNull().setSeriesColor(seriesName, red, green, blue, alpha);
        return this.successValue();
    }

    public String timeSeriesChartAddRegressionPrototype() {
        return "seriesName { ; properties }";
    }

    @FMFunction(prototype="seriesName { ; properties }")
    public FMType timeSeriesChartAddRegression(String seriesName, String[] properties) throws FeedbackException {
        Properties map = PluginUtils.convertKeyValuesToMap(properties);
        String regressionName = map.getProperty("name", "Regression");
        PluginBridge.initAwt();
        Color regressionColor = Color.getColor(map.getProperty("color"));
        ((TimeSeriesChartModel)this.getModelNotNull()).addRegression(seriesName, regressionName, regressionColor);
        return this.successValue();
    }

    public String timeSeriesChartShowGraphicPrototype() {
        return "width ; height { ; additionalParams... }";
    }

    @FMFunction(prototype="width ; height { ; additionalParams... }")
    public FMType timeSeriesChartShowGraphic(int width, int height, String[] additionalParams) throws IOException {
        return this.chartGraphic(this.getModelNotNull().getFinishedChart(width, height, PluginUtils.convertKeyValuesToMap(additionalParams)));
    }

    private FMType chartGraphic(BufferedImage bufferedImage) throws IOException {
        FMBinary result = new FMBinary();
        result.setFileName("chart.png");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        EncoderUtil.writeBufferedImage(bufferedImage, "png", baos);
        result.addImageData(bufferedImage, baos.toByteArray(), (short)bufferedImage.getWidth(), (short)bufferedImage.getHeight(), QuadChar.ImagePng);
        this.model = null;
        return result;
    }

    public String chartParamPrototype() {
        return "key ; value";
    }

    @FMFunction(prototype="key ; value")
    public FMType chartParam(String key, String value) {
        if (key == null || key.length() == 0 || value == null || value.length() == 0) {
            return new FMText("");
        }
        return new FMText(key + "=" + value + "\n");
    }

    private ChartModelInterface getModelNotNull() {
        if (this.model == null) {
            throw new NullPointerException("You must call one of the chartCreate functions first.");
        }
        return this.model;
    }
}

