/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.types.Converter;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMType;
import java.util.Date;

public class FMTimestamp
extends FMType {
    private final Date date;

    public FMTimestamp(Date date) {
        this.date = date;
    }

    @Override
    public String getAsString() {
        return this.date == null ? null : this.date.toString();
    }

    @Override
    public void writeToData(FMData destination) {
        if (this.date != null) {
            destination.setDateTimeValue(this.date.getTime());
        }
    }

    protected static void registerConverters() {
        FMType.addConverter(new TimestampConverter());
        FMType.addConverter(new GenericDateConverter());
    }

    private static class GenericDateConverter
    implements Converter {
        private GenericDateConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return Date.class.isAssignableFrom(targetClass);
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            long dateLong = param.getDateTimeValue();
            if (dateLong == 0L) {
                return null;
            }
            try {
                return targetClass.getConstructor(Long.TYPE).newInstance(new Long(dateLong));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class TimestampConverter
    implements Converter {
        private TimestampConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return Date.class == targetClass;
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            long dateLong = param.getDateTimeValue();
            if (dateLong == 0L) {
                return null;
            }
            return new Date(dateLong);
        }
    }
}

