/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.types.Converter;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMType;
import java.math.BigDecimal;
import java.math.BigInteger;

public class FMNumber
extends FMType {
    private Number value;

    public FMNumber(Number value) {
        this.value = value;
    }

    public FMNumber(int value) {
        this.value = value;
    }

    public FMNumber(long value) {
        this.value = value;
    }

    public FMNumber(boolean value) {
        this.value = value ? 1 : 0;
    }

    @Override
    public void writeToData(FMData destination) {
        String stringValue = this.value == null ? "" : this.value.toString();
        destination.setStringData(stringValue);
    }

    public Number getAsNumber() {
        return this.value;
    }

    protected static void registerConverters() {
        FMType.addConverter(new IntegerConverter());
        FMType.addConverter(new LongConverter());
        FMType.addConverter(new BigDecimalConverter());
        FMType.addConverter(new DoubleConverter());
        FMType.addConverter(new FloatConverter());
        FMType.addConverter(new ShortConverter());
        FMType.addConverter(new BigIntegerConverter());
        FMType.addConverter(new ByteConverter());
        FMType.addConverter(new GenericNumberConverter());
        FMType.addConverter(new BooleanConverter());
    }

    @Override
    public String getAsString() {
        return this.value == null ? null : this.value.toString();
    }

    public String toString() {
        return this.getAsString();
    }

    private static class BooleanConverter
    implements Converter {
        private BooleanConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return targetClass == Boolean.class || targetClass == Boolean.TYPE;
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            long longData = param.getLongData();
            if (longData != 0L) {
                return Boolean.TRUE;
            }
            if (targetClass == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            return param.isEmpty() ? null : Boolean.FALSE;
        }
    }

    private static class GenericNumberConverter
    implements Converter {
        private GenericNumberConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return Number.class.isAssignableFrom(targetClass);
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            try {
                String stringData = param.getStringData();
                if (stringData.length() == 0) {
                    return null;
                }
                return targetClass.getConstructor(String.class).newInstance(stringData);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ByteConverter
    implements Converter {
        private ByteConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return Byte.class == targetClass || Byte.TYPE == targetClass;
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            long longData = param.getLongData();
            if (longData == 0L && param.getStringData().length() == 0) {
                return targetClass == Byte.TYPE ? new Byte(0) : null;
            }
            return new Byte((byte)longData);
        }
    }

    private static class BigIntegerConverter
    implements Converter {
        private BigIntegerConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return BigInteger.class == targetClass;
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            long longData = param.getLongData();
            if (longData == 0L && param.getStringData().length() == 0) {
                return targetClass == Long.TYPE ? new Long(0L) : null;
            }
            return new BigInteger(String.valueOf(longData));
        }
    }

    private static class ShortConverter
    implements Converter {
        private ShortConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return Short.class == targetClass || Short.TYPE == targetClass;
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            long longData = param.getLongData();
            if (longData == 0L && param.getStringData().length() == 0) {
                return targetClass == Short.TYPE ? new Short(0) : null;
            }
            return new Short((short)longData);
        }
    }

    private static class FloatConverter
    implements Converter {
        private FloatConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return Float.class == targetClass || Float.TYPE == targetClass;
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            double doubleData = param.getDoubleData();
            if (doubleData == 0.0 && param.getStringData().length() == 0) {
                return targetClass == Float.TYPE ? new Float(0.0f) : null;
            }
            return new Float(doubleData);
        }
    }

    private static class DoubleConverter
    implements Converter {
        private DoubleConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return Double.class == targetClass || Double.TYPE == targetClass;
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            double doubleData = param.getDoubleData();
            if (doubleData == 0.0 && param.getStringData().length() == 0) {
                return targetClass == Double.TYPE ? new Double(0.0) : null;
            }
            return new Double(doubleData);
        }
    }

    private static class BigDecimalConverter
    implements Converter {
        private BigDecimalConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return BigDecimal.class == targetClass;
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            double doubleData = param.getDoubleData();
            if (doubleData == 0.0 && param.getStringData().length() == 0) {
                return null;
            }
            return new BigDecimal(doubleData);
        }
    }

    private static class LongConverter
    implements Converter {
        private LongConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return Long.class == targetClass || Long.TYPE == targetClass;
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            long longData = param.getLongData();
            if (longData == 0L && param.getStringData().length() == 0) {
                return targetClass == Long.TYPE ? new Long(0L) : null;
            }
            return new Long((int)longData);
        }
    }

    private static class IntegerConverter
    implements Converter {
        private IntegerConverter() {
        }

        @Override
        public boolean canConvertTo(Class targetClass) {
            return Integer.class == targetClass || Integer.TYPE == targetClass;
        }

        @Override
        public Object convertData(FMData param, Class targetClass, PluginContext context) {
            long longData = param.getLongData();
            if (longData == 0L && param.getStringData().length() == 0) {
                return targetClass == Integer.TYPE ? new Integer(0) : null;
            }
            return new Integer((int)longData);
        }
    }
}

