/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fmkit.FileMakerOperation;
import com.prosc.fmkit.FmCalculationException;
import com.prosc.fmkit.FmScriptException;
import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.PluginBridge;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.ScriptCall;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMDataVect;
import com.prosc.fmkit.types.FMRowVect;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMType;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class PluginContext {
    private static final Logger log = Logger.getLogger(PluginContext.class.getName());
    private final boolean unsafeCalls;
    private final long cStartScript;
    private final long envCallback;
    private final long cCurrentEnv;
    private final PluginBridge theBridge;
    private final Plugin thePlugin;
    private final Thread filemakerThread;
    private final PluginFunction whichFunction;
    private FMType functionResult;

    PluginContext(PluginBridge theBridge, Plugin thePlugin, boolean unsafeCalls, long cStartScript, long envCallback, long cCurrentEnv, Thread filemakerThread, PluginFunction whichFunction) {
        this.theBridge = theBridge;
        this.thePlugin = thePlugin;
        this.unsafeCalls = unsafeCalls;
        this.cStartScript = cStartScript;
        this.envCallback = envCallback;
        this.cCurrentEnv = cCurrentEnv;
        this.filemakerThread = filemakerThread;
        this.whichFunction = whichFunction;
    }

    public boolean isUnsafeCalls() {
        return this.unsafeCalls;
    }

    public Thread getFilemakerThread() {
        return this.filemakerThread;
    }

    PluginFunction getWhichFunction() {
        return this.whichFunction;
    }

    public void triggerScript(ScriptCall script) throws FmScriptException {
        try {
            this.triggerScript(script.getFilename(), script.getScriptName(), script.getScriptControl(), script.getParams());
        }
        catch (FmScriptException e) {
            script.setExecutionException(e);
            throw e;
        }
    }

    private void triggerScript(final String filename, final String scriptname, final int currentScriptSettings, final String parameter) throws FmScriptException {
        if (filename == null) {
            throw new NullPointerException("filename must not be null.");
        }
        if (this.getFilemakerThread() == Thread.currentThread()) {
            long paramToken = 0L;
            if (parameter != null && parameter.length() > 0) {
                FMData fmParam = new FMData();
                new FMText(parameter).writeToData(fmParam);
                paramToken = fmParam.getCToken();
            }
            log.fine("Queuing script " + scriptname + " in file " + filename + " from thread " + Thread.currentThread().getName());
            short errorCode = this._triggerScript(filename, scriptname, currentScriptSettings, paramToken, this.cStartScript);
            log.fine("Script queued");
            if (errorCode != 0) {
                throw new FmScriptException(errorCode, filename, scriptname);
            }
        } else {
            log.fine("Current Thread is " + Thread.currentThread().getName() + "; queueing triggerScript to happen on main thread");
            this.theBridge.queueFileMakerOperation(new FileMakerOperation(){

                @Override
                public void run(PluginContext context) {
                    try {
                        log.fine("Triggering script from main thread: " + Thread.currentThread().getName());
                        PluginContext.this.triggerScript(filename, scriptname, currentScriptSettings, parameter);
                    }
                    catch (FmScriptException e) {
                        log.log(Level.SEVERE, "An error occurred while executing script " + scriptname + " in file " + filename + ": " + e.toString(), e);
                    }
                }
            });
        }
    }

    private native short _triggerScript(String var1, String var2, int var3, long var4, long var6);

    public FMData evaluateExpression(String expression) throws FmCalculationException {
        if (Thread.currentThread() != this.filemakerThread) {
            log.warning("evaluateExpression called from non-FileMaker thread: " + Thread.currentThread());
        }
        log.fine("evaluateExpression: " + expression);
        if (expression == null) {
            throw new IllegalArgumentException("null value passed to evaluateExpression");
        }
        short errorCode = this._evaluateExpression(expression, this.cCurrentEnv, this.envCallback, this.cCurrentEnv == 0L);
        if (errorCode != 0) {
            throw new FmCalculationException(errorCode);
        }
        long dataToken = this._getExpressionResult();
        log.finer("dataToken = " + dataToken);
        FMData result = new FMData(dataToken, this.filemakerThread);
        log.fine("result is " + result);
        return result;
    }

    public String getFontName(FMText text, short fontId) {
        throw new AbstractMethodError("This feature has not been implemented yet.");
    }

    private native String _getFontName(long var1, short var3, long var4, long var6, boolean var8);

    public String executeSql(String sql, char columnDelimiter, char rowDelimiter) throws FmCalculationException {
        PluginContext pluginContext = this;
        if (pluginContext.theBridge.getApiVersion() >= 52) {
            StringBuilder sb = new StringBuilder();
            FMRowVect rowVect = this.executeSql11(sql, "", new String[0]);
            String rDelim = "";
            for (FMDataVect dataVect : rowVect) {
                sb.append(rDelim);
                String cDelim = "";
                for (FMData data : dataVect) {
                    sb.append(cDelim);
                    sb.append(data.getStringData(false));
                    cDelim = String.valueOf(columnDelimiter);
                }
                rDelim = String.valueOf(rowDelimiter);
            }
            return sb.toString();
        }
        PluginContext pluginContext2 = this;
        if (pluginContext2.theBridge.getApiVersion() < 52) {
            return this.executeSql8(sql, columnDelimiter, rowDelimiter).getStringData(false);
        }
        String message = "Could not call executeSql because the optional SQL library is not loaded.";
        throw new RuntimeException(message);
    }

    public FMData executeSql8(@NotNull String sql, char columnDelimiter, char rowDelimiter) throws FmCalculationException {
        if (sql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sql", "com/prosc/fmkit/PluginContext", "executeSql8"));
        }
        if (sql == null) {
            throw new IllegalArgumentException("A null value was passed to executeSql");
        }
        log.config("executeSql with FileMaker 8 API: " + sql);
        try {
            short errorCode = PluginContext._executeSql(sql, columnDelimiter, rowDelimiter, this.cCurrentEnv, this.envCallback, this.cCurrentEnv == 0L);
            if (errorCode != 0) {
                throw new FmCalculationException(errorCode);
            }
            long dataToken = PluginContext._getSqlResult();
            log.finer("dataToken = " + dataToken);
            FMData result = new FMData(dataToken, this.filemakerThread);
            log.fine("result is " + result);
            return result;
        }
        catch (UnsatisfiedLinkError e) {
            String message = "Could not call executeSql because the optional SQL library is not loaded.";
            throw new RuntimeException(message, e);
        }
    }

    public FMRowVect executeSql11(@NotNull String sql, @NotNull String filename, @NotNull String[] params) throws FmCalculationException {
        if (sql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sql", "com/prosc/fmkit/PluginContext", "executeSql11"));
        }
        if (filename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filename", "com/prosc/fmkit/PluginContext", "executeSql11"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/prosc/fmkit/PluginContext", "executeSql11"));
        }
        if (sql == null) {
            throw new IllegalArgumentException("A null value was passed to executeSql");
        }
        log.config("executeSql with FileMaker 11 API: " + sql);
        try {
            short errorCode = PluginContext._executeSql11(sql, this.cCurrentEnv, this.envCallback, this.cCurrentEnv == 0L, filename, params);
            if (errorCode != 0) {
                throw new FmCalculationException(errorCode);
            }
            long dataToken = PluginContext._getSqlResult11();
            log.finer("dataToken = " + dataToken);
            FMRowVect result = new FMRowVect(dataToken, this.filemakerThread);
            log.fine("result is " + result);
            return result;
        }
        catch (UnsatisfiedLinkError e) {
            String message = "Could not call executeSql because the optional SQL library is not loaded.";
            throw new RuntimeException(message, e);
        }
    }

    public Object getFieldValue(String filename, String fieldName) throws FmCalculationException {
        String typeInfo;
        if (filename == null) {
            throw new NullPointerException("filename must not be null.");
        }
        log.log(Level.INFO, "Getting field value for filename " + filename + ", fieldname " + fieldName);
        try {
            typeInfo = this.evaluateExpression("FieldType(\"" + filename + "\" ; \"" + fieldName + "\")").getStringData();
            log.log(Level.INFO, typeInfo);
        }
        catch (FmCalculationException e) {
            throw new RuntimeException("Unknown field '" + fieldName + "'.  You must pass a \"table::field\" fieldname to the FMPro.getFieldValue function", e);
        }
        FMData value = this.evaluateExpression(fieldName);
        int firstSpaceIndex = typeInfo.indexOf(32);
        int secondSpace = typeInfo.indexOf(32, firstSpaceIndex + 1);
        String typeName = typeInfo.substring(firstSpaceIndex + 1, secondSpace);
        Class targetClass = FMType.classForFMType(typeName);
        try {
            return FMType.converterForClass(targetClass).convertData(value, targetClass, this);
        }
        catch (FMType.UnsupportedTypeConversionException e) {
            log.log(Level.WARNING, "Unable to convert " + value + " to " + targetClass, e);
            return value.getStringData();
        }
    }

    private native short _evaluateExpression(String var1, long var2, long var4, boolean var6);

    private native long _getExpressionResult();

    private static native short _executeSql(String var0, char var1, char var2, long var3, long var5, boolean var7);

    private static native long _getSqlResult();

    private static native short _executeSql11(String var0, long var1, long var3, boolean var5, String var6, String[] var7);

    private static native long _getSqlResult11();

    public String toString() {
        return "PluginContext{theBridge=" + this.theBridge + ", thePlugin=" + this.thePlugin + '}';
    }

    public void dumpDebugInfo() {
        log.info("unsafe calls: " + this.unsafeCalls + "\ncStartScript: " + this.cStartScript + "\ncCurrentEnv: " + this.cCurrentEnv);
    }

    public synchronized void setFunctionResult(FMType functionResult) {
        this.functionResult = functionResult;
    }

    public synchronized FMType getFunctionResult() {
        return this.functionResult;
    }
}

