/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

import com.prosc.Platform;
import com.prosc.io.ProcessUtils;
import com.prosc.windows.WindowsRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class FMDirectoryUtils {
    private static final Logger log = Logger.getLogger(FMDirectoryUtils.class.getName());
    private static boolean isMac = Platform.current == Platform.mac;

    @NotNull
    public static File getFmsHome() throws FileNotFoundException {
        File result;
        block14: {
            block13: {
                result = FMDirectoryUtils.checkResult(System.getenv("FMS_HOME"));
                if (result != null) {
                    File file = result;
                    if (file == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/fm/FMDirectoryUtils", "getFmsHome"));
                    }
                    return file;
                }
                if (!isMac) break block13;
                result = FMDirectoryUtils.checkResult("/Library/FileMaker Server/");
                if (result == null) {
                    try {
                        String fmserverHomePath = new String(ProcessUtils.doShellCommand(new String[]{"/bin/bash", "-c", "/bin/echo -n ~fmserver"}, null, null), "utf-8");
                        result = FMDirectoryUtils.checkResult(fmserverHomePath);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Couldn't use echo ~fmserver to get home directory", e);
                    }
                }
                if (result != null) break block14;
                result = FMDirectoryUtils.checkResult("/Library/FileMaker Server 7");
                break block14;
            }
            result = FMDirectoryUtils.checkResult(System.getenv("ProgramFiles") + "\\FileMaker\\FileMaker Server");
            if (result == null) {
                result = FMDirectoryUtils.checkResult(System.getenv("ProgramFiles(x86)") + "\\FileMaker\\FileMaker Server");
            }
            if (result == null) {
                String[] versions;
                for (String version : versions = new String[]{"12.0", "11.0", "10.0", "9.0", "8.0", "7.0", "15.0", "14.0", "13.0"}) {
                    String registryKey = "HKLM\\SOFTWARE\\FileMaker\\FileMaker Server\\" + version + "\\Services";
                    try {
                        String registryHome = WindowsRegistry.readRegistry(registryKey, "InstallLocation");
                        result = FMDirectoryUtils.checkResult(registryHome);
                        if (result == null) continue;
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("unable to find the specified registry key")) {
                            log.fine("Could not query registry for location of FileMaker Server using registry key " + registryKey);
                            continue;
                        }
                        log.log(Level.WARNING, "Unexpected error while querying registry", e);
                    }
                    break;
                }
            }
        }
        if (result == null) {
            throw new FileNotFoundException("Could not locate FileMaker Server directory; it may not be installed on this computer");
        }
        File file = result;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/fm/FMDirectoryUtils", "getFmsHome"));
        }
        return file;
    }

    public static String getFMSVersion(File fmsHome) {
        throw new UnsupportedOperationException("not implemented");
    }

    private static File checkResult(String home) {
        File fmsBinary;
        if (home == null) {
            return null;
        }
        File result = new File(home);
        if (result.exists() && (fmsBinary = isMac ? new File(result, "Database Server/bin/fmserverd") : new File(result, "Database Server\\fmserver.exe")).exists()) {
            return result;
        }
        return null;
    }
}

