/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class FMDateUtils {
    private static final long FM_TIMESTAMP_EPOCH = 62135596800L;
    private static final int FM_DATE_EPOCH = 719163;

    public static long fmTimestampNumberToMilliseconds(long fmTimestamp) {
        int gmtAdjustment1 = -1 * TimeZone.getDefault().getRawOffset() / 1000;
        long numSecondsGmt1 = fmTimestamp + (long)gmtAdjustment1;
        long difference1 = numSecondsGmt1 - 62135596800L;
        long differenceMillis1 = difference1 * 1000L;
        Date date1 = new Date(differenceMillis1);
        int gmtAdjustment2 = -1 * TimeZone.getDefault().getOffset(date1.getTime()) / 1000;
        long numSecondsGmt2 = fmTimestamp + (long)gmtAdjustment2;
        long difference2 = numSecondsGmt2 - 62135596800L;
        return difference2 * 1000L;
    }

    public static long millisecondsToFMTimestamp(long javaSqlTimestamp, boolean returnAsUTC) {
        int gmtAdjustment = 0;
        if (!returnAsUTC) {
            gmtAdjustment = -1 * TimeZone.getDefault().getOffset(javaSqlTimestamp) / 1000;
        }
        return javaSqlTimestamp / 1000L - (long)gmtAdjustment + 62135596800L;
    }

    public static java.sql.Date fmDateNumberToSqlDate(int fmDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(0L);
        int daysSinceEpoch = fmDate - 719163;
        calendar.add(5, daysSinceEpoch);
        return new java.sql.Date(calendar.getTimeInMillis());
    }

    public static int sqlDateToFMDate(java.sql.Date javaSqlDate, boolean isUTC) {
        int gmtAdjustment = 0;
        if (!isUTC) {
            gmtAdjustment = -1 * TimeZone.getDefault().getOffset(System.currentTimeMillis());
        }
        int backToDaysSinceEpoch = (int)((javaSqlDate.getTime() - (long)gmtAdjustment) / 86400000L);
        return backToDaysSinceEpoch + 719163;
    }

    public static Time fmTimeNumberToSqlTime(double fmTime) {
        int milliseconds = (int)(fmTime * 1000.0);
        return new Time(milliseconds -= TimeZone.getDefault().getRawOffset());
    }

    public static double sqlTimeToFMTime(Time javaSqlTime, boolean isUTC) {
        int gmtAdjustment = 0;
        if (!isUTC) {
            gmtAdjustment = -1 * TimeZone.getDefault().getRawOffset();
        }
        return (double)(javaSqlTime.getTime() - (long)gmtAdjustment) / 1000.0;
    }

    public static GregorianCalendar getGregorianCalendarForFMDate(String fmDate) throws ParseException {
        Date date;
        SimpleDateFormat timestampFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a");
        SimpleDateFormat timestampFormatNoSeconds = new SimpleDateFormat("MM/dd/yyyy HH:mm");
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        try {
            date = timestampFormat.parse(fmDate);
        }
        catch (ParseException e) {
            try {
                date = timestampFormatNoSeconds.parse(fmDate);
            }
            catch (ParseException ex) {
                date = dateFormat.parse(fmDate);
            }
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(date.getTime());
        return gregorianCalendar;
    }
}

