/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class BeanUtils {
    private static final Logger log = Logger.getLogger(BeanUtils.class.getName());

    public static PropertyDescriptor getPropertyNamed(Class targetClass, String name) throws IntrospectionException {
        return BeanUtils.getPropertyNamed(Introspector.getBeanInfo(targetClass), name);
    }

    public static PropertyDescriptor getPropertyNamed(BeanInfo targetInfo, String name) throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor descriptor : descriptors = targetInfo.getPropertyDescriptors()) {
            if (!name.equals(descriptor.getName())) continue;
            return descriptor;
        }
        throw new IntrospectionException("No property exists with name: " + name + " in " + targetInfo.getBeanDescriptor().getBeanClass().getName());
    }

    public static void writeValue(Object bean, String path, Object value) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        int lastDot = path.lastIndexOf(46);
        if (lastDot != -1) {
            Object childBean = BeanUtils.readValue(bean, path.substring(0, lastDot));
            BeanUtils.writeValue(childBean, path.substring(lastDot + 1), value);
        } else {
            PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyNamed(bean.getClass(), path);
            Method writeMethod = propertyDescriptor.getWriteMethod();
            if (writeMethod == null) {
                throw new IntrospectionException("No write method for property \"" + path + "\" in " + bean);
            }
            writeMethod.invoke(bean, value);
        }
    }

    public static Object readValue(Object bean, String path) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        int firstDot = path.indexOf(46);
        if (firstDot != -1) {
            Object child = BeanUtils.readValue(bean, path.substring(0, firstDot));
            return child == null ? null : BeanUtils.readValue(child, path.substring(firstDot + 1));
        }
        Method readMethod = BeanUtils.getPropertyNamed(bean.getClass(), path).getReadMethod();
        if (readMethod == null) {
            throw new IntrospectionException("No read method for property \"" + path + "\" in " + bean);
        }
        return readMethod.invoke(bean, new Object[0]);
    }
}

