/*
 * Decompiled with CFR 0.152.
 */
package com.prosc;

import com.prosc.fmkit.BugReporter;
import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.ProscPlugin;
import com.prosc.license.client.Registration;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ProscPluginConfigDialog
extends JDialog {
    private ProscPlugin whichPlugin;
    private Registration registration;

    public ProscPluginConfigDialog(ProscPlugin whichPlugin, Registration registration, Frame owner) throws HeadlessException {
        super(owner, whichPlugin.getName() + " configuration", true);
        this.whichPlugin = whichPlugin;
        this.registration = registration;
        this.initComponents();
    }

    private void initComponents() {
        JPanel buttonPanel = new JPanel(new GridLayout());
        JButton bugButton = new JButton("Report a bug");
        bugButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugReporter reporter = new BugReporter((Dialog)ProscPluginConfigDialog.this, (Plugin)ProscPluginConfigDialog.this.whichPlugin, ProscPluginConfigDialog.this.registration);
                reporter.pack();
                reporter.setVisible(true);
            }
        });
        buttonPanel.add(bugButton);
        if (this.whichPlugin.getSupportUrl() != null) {
            JButton supportButton = new JButton("Ask a question");
            supportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProscPluginConfigDialog.this.launch(ProscPluginConfigDialog.this.whichPlugin.getSupportUrl());
                }
            });
            buttonPanel.add(supportButton);
        }
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProscPluginConfigDialog.this.dispose();
            }
        });
        buttonPanel.add(okButton);
        JPanel buttonRow = new JPanel(new FlowLayout(4));
        buttonRow.add(buttonPanel);
        this.getRootPane().setDefaultButton(okButton);
        this.setContentPane(buttonRow);
    }

    public int launch(String url) {
        try {
            boolean isWindows = System.getProperty("os.name").indexOf("Windows") >= 0;
            String[] cmd = isWindows ? new String[]{"cmd.exe", "/C", "start", url} : new String[]{"open", url};
            Process process = Runtime.getRuntime().exec(cmd);
            process.waitFor();
            return process.exitValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

