/*
 * Decompiled with CFR 0.152.
 */
package com.prosc;

import org.jetbrains.annotations.NotNull;

public enum Platform {
    mac(true),
    windows(false),
    linux(true),
    unknown(true);

    public static final Platform current;
    public final boolean unixLike;

    private Platform(boolean unixLike) {
        this.unixLike = unixLike;
    }

    public static boolean isMac() {
        return current == mac;
    }

    public static boolean isWin() {
        return current == windows;
    }

    public String pathTranslated(@NotNull String pathFromOtherPlatform) {
        if (pathFromOtherPlatform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathFromOtherPlatform", "com/prosc/Platform", "pathTranslated"));
        }
        Platform origin = Platform.analyzePath(pathFromOtherPlatform);
        if (origin == this) {
            return pathFromOtherPlatform;
        }
        switch (origin) {
            case unknown: {
                return pathFromOtherPlatform;
            }
            case mac: 
            case linux: {
                if (this == windows) {
                    String backslashed = pathFromOtherPlatform.replace("\\", ":").replace("/", "\\");
                    return backslashed.substring(1).replaceFirst("\\\\", ":\\\\");
                }
                return pathFromOtherPlatform;
            }
            case windows: {
                return "/" + pathFromOtherPlatform.replace("/", ":").replace("\\", "/").replaceFirst("\\:/", "/");
            }
        }
        return pathFromOtherPlatform;
    }

    @NotNull
    private static Platform analyzePath(@NotNull String pathFromOtherPlatform) {
        if (pathFromOtherPlatform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathFromOtherPlatform", "com/prosc/Platform", "analyzePath"));
        }
        if (pathFromOtherPlatform.startsWith("/")) {
            Platform platform = mac;
            if (platform == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/Platform", "analyzePath"));
            }
            return platform;
        }
        if (pathFromOtherPlatform.contains(":\\")) {
            Platform platform = windows;
            if (platform == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/Platform", "analyzePath"));
            }
            return platform;
        }
        Platform platform = unknown;
        if (platform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/Platform", "analyzePath"));
        }
        return platform;
    }

    static {
        String osName = System.getProperty("os.name");
        current = osName == null ? unknown : (osName.startsWith("Mac") ? mac : (osName.startsWith("Windows") ? windows : (osName.startsWith("Linux") ? linux : unknown)));
    }
}

