/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fmkit.FmCalculationException;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.QuadChar;
import com.prosc.fmkit.types.FMBinaryInterface;
import com.prosc.fmkit.types.InputStreamInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileReference
implements FMBinaryInterface {
    private short width;
    private short height;
    private String genericPath;
    private String macPath;
    private String winPath;
    private int type;
    private File file;
    public static final int TYPE_FILE = 0;
    public static final int TYPE_IMAGE = 1;
    public static final int TYPE_MOVIE = 2;
    private static final String[] TYPE_CODES = new String[]{"file", "image", "movie"};
    private static final Logger log = Logger.getLogger(FileReference.class.getName());
    private List streamTypes = null;
    private String referenceInfo;

    public FileReference(String referenceInfo) {
        int comma;
        if (referenceInfo == null) {
            throw new NullPointerException("referenceInfo must not be null.");
        }
        this.referenceInfo = referenceInfo;
        Properties properties = new Properties();
        if (PluginUtils.isMac()) {
            referenceInfo = referenceInfo.replaceAll("\\%2F", ":");
        }
        try {
            PluginUtils.loadUnicodeProperties(properties, referenceInfo);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String size = properties.getProperty("size");
        if (size != null && (comma = size.indexOf(44)) != -1) {
            this.width = Short.parseShort(size.substring(0, comma));
            this.height = Short.parseShort(size.substring(comma + 1));
        }
        this.extractPathInfo(properties);
        this.streamTypes = this.type != -1 ? Collections.singletonList(QuadChar.FileData) : Collections.EMPTY_LIST;
    }

    private void extractPathInfo(Properties properties) {
        for (int i = 0; i < TYPE_CODES.length; ++i) {
            String eachType = TYPE_CODES[i];
            this.genericPath = properties.getProperty(eachType);
            if (this.genericPath != null) {
                String tmpPath;
                this.macPath = properties.getProperty(eachType + "mac");
                this.winPath = properties.getProperty(eachType + "win");
                this.type = i;
                if (this.referenceInfo != null && this.referenceInfo.startsWith("file:") && this.macPath == null && this.winPath == null && !new File(this.genericPath).exists() && !this.genericPath.equals(tmpPath = this.genericPath.replace("%20", " "))) {
                    log.log(Level.INFO, "URLDecoding genericPath '" + this.genericPath + "' to '" + tmpPath + "'");
                    this.genericPath = tmpPath;
                }
                return;
            }
            this.type = -1;
        }
    }

    public short getWidth() {
        return this.width;
    }

    public short getHeight() {
        return this.height;
    }

    public boolean isReference() {
        return true;
    }

    public InputStreamInfo getInputStreamInfo(PluginContext context) throws FileNotFoundException {
        File file = this.getFile(context);
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("File not found");
        }
        if (file.isDirectory()) {
            throw new IllegalStateException("File " + file + " is a directory");
        }
        return new InputStreamInfo(file);
    }

    public int getType() {
        return this.type;
    }

    public File getFile() {
        if (this.file == null) {
            File result = null;
            boolean isMac = PluginUtils.isMac();
            if (this.genericPath != null && this.genericPath.startsWith("/")) {
                result = new File(this.genericPath);
                if (isMac && !result.exists()) {
                    result = new File("/Volumes" + this.genericPath);
                }
            }
            if (result == null || !result.exists()) {
                if (isMac && this.macPath != null && this.macPath.startsWith("/")) {
                    result = new File(this.macPath);
                    if (!result.exists()) {
                        result = new File("/Volumes" + this.macPath);
                    }
                } else if (!isMac && this.winPath != null && this.winPath.startsWith("/")) {
                    result = new File(this.winPath.replace('/', '\\'));
                }
            }
            if (result == null || !result.exists()) {
                log.log(Level.WARNING, "FileReference " + this + " is for non-existent file: " + result);
            }
            this.file = result;
        }
        return this.file;
    }

    public File getFile(PluginContext context) {
        File result = this.getFile();
        if (result == null || !result.exists()) {
            try {
                String dbFilePath = context.evaluateExpression("Get(FilePath)").getStringData();
                if (dbFilePath == null || !dbFilePath.startsWith("file:")) {
                    return null;
                }
                dbFilePath = dbFilePath.substring(5);
                if (PluginUtils.isMac()) {
                    dbFilePath = "/Volumes" + dbFilePath;
                }
                File dbDir = new File(dbFilePath).getParentFile();
                result = new File(dbDir, this.genericPath);
                log.log(Level.FINE, "Resolving file reference using dbFilePath {0} and relative path {1}, result is {2}", new Object[]{dbFilePath, this.genericPath, result});
            }
            catch (FmCalculationException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public List getStreamTypes() {
        return this.streamTypes;
    }

    public QuadChar getBestQuadChar() {
        return this.streamTypes.isEmpty() ? null : this.streamTypes.get(0);
    }

    public InputStream getBestInputStream() {
        File file = this.getFile();
        try {
            return file == null ? null : new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String asString() {
        return this.referenceInfo;
    }

    public InputStream getStreamForType(QuadChar type) {
        return this.getBestInputStream();
    }

    public long getTotalSize() {
        File file = this.getFile();
        return file == null ? 0L : file.length();
    }

    public void setSoundData(byte[] data) {
        throw new AbstractMethodError("com.prosc.fmkit.types.FileReference.setSoundData method not implemented.");
    }

    public void addDataStream(byte[] data, QuadChar type) {
        throw new AbstractMethodError("com.prosc.fmkit.types.FileReference.addDataStream method not implemented.");
    }

    public String getFileName() {
        File file = this.getFile();
        return file == null ? null : file.getName();
    }

    public static boolean isValidReferenceString(String s) {
        if (s == null || s.length() < 5) {
            return false;
        }
        if (s.startsWith("size:")) {
            return true;
        }
        for (int i = 0; i < TYPE_CODES.length; ++i) {
            String eachCode = TYPE_CODES[i];
            if (!s.startsWith(eachCode + ":") && !s.startsWith(eachCode + "mac:") && !s.startsWith(eachCode + "win:")) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "FileReference{width=" + this.width + ", height=" + this.height + ", genericPath='" + this.genericPath + '\'' + ", macPath='" + this.macPath + '\'' + ", winPath='" + this.winPath + '\'' + ", type=" + this.type + ", file=" + this.file + '}';
    }
}

