/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fmkit.FMException;
import com.prosc.fmkit.FMTypeConverter;
import com.prosc.fmkit.types.Converter;
import com.prosc.fmkit.types.FMBinary;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMDictConverter;
import com.prosc.fmkit.types.FMNumber;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMTimestamp;
import com.prosc.fmkit.types.FileConverter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public abstract class FMType {
    private static List converters = new LinkedList();
    private static final Logger log = Logger.getLogger(FMType.class.getName());

    private static void registerConverters() {
        FMType.addConverter(new FMTypeConverter());
        FMType.addConverter(new ColorConverter());
    }

    public abstract void writeToData(FMData var1);

    public abstract String getAsString();

    public static void addConverter(Converter theConverter) {
        converters.add(theConverter);
    }

    public static Converter converterForClass(Class targetClass) throws UnsupportedTypeConversionException {
        for (Converter eachConverter : converters) {
            if (!eachConverter.canConvertTo(targetClass)) continue;
            return eachConverter;
        }
        throw new UnsupportedTypeConversionException(targetClass);
    }

    public static Class classForFMType(String typeName) {
        if (typeName == null) {
            throw new NullPointerException("typeName must not be null.");
        }
        if ("text".equals(typeName = typeName.toLowerCase())) {
            return String.class;
        }
        if ("number".equals(typeName)) {
            return BigDecimal.class;
        }
        if ("date".equals(typeName) || "time".equals(typeName) || "timestamp".equals(typeName)) {
            return Date.class;
        }
        if ("container".equals(typeName)) {
            return FMData.class;
        }
        throw new IllegalArgumentException("Unknown FM type '" + typeName + "'");
    }

    public static FMType bestTypeForJavaObject(Object in) {
        if (in == null) {
            return null;
        }
        FMType result = null;
        Class<?> inClass = in.getClass();
        if (in instanceof FMType) {
            result = (FMType)in;
        } else if (String.class == inClass) {
            result = new FMText((String)in);
        } else {
            if (in instanceof Reader) {
                try {
                    return new FMText((Reader)in);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (Number.class.isAssignableFrom(inClass)) {
                result = new FMNumber((Number)in);
            } else {
                if (in instanceof Boolean) {
                    return (Boolean)in != false ? new FMNumber(1) : new FMNumber(0);
                }
                if (in instanceof File) {
                    try {
                        result = FMBinary.fmBinaryForFile((File)in);
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, "Unable to convert file {0} to FMBinary", e);
                        throw new RuntimeException(e);
                    }
                } else if (in instanceof URL) {
                    try {
                        result = FMBinary.fmBinaryForUrl((URL)in);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else if (in instanceof Color) {
                    Color color = (Color)in;
                    result = new FMText("RGB(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")");
                } else if (in instanceof RenderedImage) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        String format = in instanceof BufferedImage && ((BufferedImage)in).getType() == 2 ? "png" : "jpg";
                        ImageIO.write((RenderedImage)in, format, baos);
                        byte[] bytes = baos.toByteArray();
                        result = FMBinary.fmBinaryForData(bytes, "image." + format, null);
                    }
                    catch (IOException e) {
                        log.log(Level.INFO, "Unable to convert " + in + " to byte array", e);
                    }
                } else if (in instanceof Object[]) {
                    String stringValue = FMType.arrayToString((Object[])in);
                    result = new FMText(stringValue);
                } else if (in instanceof Collection) {
                    StringBuffer sb = new StringBuffer();
                    Iterator iterator = ((Collection)in).iterator();
                    while (iterator.hasNext()) {
                        if (sb.length() != 0) {
                            sb.append("\r");
                        }
                        sb.append(iterator.next());
                    }
                    result = new FMText(sb.toString());
                } else if (in instanceof Date) {
                    return new FMTimestamp((Date)in);
                }
            }
        }
        if (result == null) {
            log.log(Level.FINE, "Unknown object type {0}, will use String.valueOf()", in.getClass().getName());
            result = new FMText(String.valueOf(in));
        }
        log.log(Level.FINER, "best type for {0} \"{1}\" is {2}", new Object[]{in.getClass().getName(), in, result});
        return result;
    }

    private static String arrayToString(Object[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            Object eachValue;
            if (i != 0) {
                sb.append("\r");
            }
            if ((eachValue = array[i]) instanceof Object[]) {
                Object[] subArray = (Object[])eachValue;
                for (int j = 0; j < subArray.length; ++j) {
                    Object eachSubValue = subArray[j];
                    if (j != 0) {
                        sb.append("\t");
                    }
                    sb.append(eachSubValue);
                }
                continue;
            }
            sb.append(eachValue);
        }
        return sb.toString();
    }

    static {
        FMNumber.registerConverters();
        FMText.registerConverters();
        FMTimestamp.registerConverters();
        FMBinary.registerConverters();
        FMDictConverter.registerConverters();
        FMData.registerConverters();
        FMType.registerConverters();
        FileConverter.registerConverters();
    }

    private static class ColorConverter
    implements Converter {
        private ColorConverter() {
        }

        public boolean canConvertTo(Class targetClass) {
            return targetClass == Color.class;
        }

        public Object convertData(FMData param, Class targetClass) {
            if (param.isEmpty()) {
                return null;
            }
            String stringData = param.getStringData();
            if (stringData == null || stringData.length() == 0) {
                return null;
            }
            if (stringData.charAt(0) == '#' || Character.isDigit(stringData.charAt(0))) {
                return Color.decode(stringData);
            }
            if (stringData.toLowerCase().startsWith("rgb")) {
                String[] parts = stringData.split("[^0-9]+");
                return new Color(Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]), 0);
            }
            Field[] fields = Color.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field eachField = fields[i];
                if (eachField.getType() != Color.class || !Modifier.isStatic(eachField.getModifiers()) || !eachField.getName().equals(stringData)) continue;
                try {
                    return eachField.get(Color.class);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IllegalArgumentException("Unable to convert " + stringData + " to a Color");
        }
    }

    public static class UnsupportedTypeConversionException
    extends FMException {
        public UnsupportedTypeConversionException(Class whichClass) {
            super((short)-2, "No conversion capability for class " + whichClass.getName());
        }
    }
}

