/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.design;

import com.prosc.fmkit.FmCalculationException;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.design.FieldFilter;
import com.prosc.fmkit.design.FieldType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignInfo {
    private static final Logger log = Logger.getLogger(DesignInfo.class.getName());
    private final PluginContext context;
    private String fileName;
    private List tableNames;
    private String currentTable;
    private Map functionMap;

    public DesignInfo(PluginContext context) {
        this.context = context;
    }

    private String getFileName() throws FmCalculationException {
        if (this.fileName == null) {
            this.fileName = this.context.evaluateExpression("Get(FileName)").getStringData();
            log.info("fileName: " + this.fileName);
        }
        return this.fileName;
    }

    public List getFieldOptionsForTable(String table, FieldFilter filter) throws FmCalculationException {
        String fieldNames = this.context.evaluateExpression("FieldNames( \"" + this.getFileName() + "\" ; \"" + table + "\")").getStringData();
        LinkedList<String> result = new LinkedList<String>(Arrays.asList(fieldNames.split("[\\r\\n]+")));
        if (filter != null) {
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                String eachFieldName = (String)iterator.next();
                String expression = "FieldType(\"" + this.getFileName() + "\" ; \"" + table + "::" + eachFieldName + "\")";
                String fieldType = this.context.evaluateExpression(expression).getStringData();
                if (fieldType != null && fieldType.length() > 0) {
                    FieldType fieldInfo = new FieldType(fieldType);
                    if (filter.accept(table, eachFieldName, fieldInfo)) continue;
                    iterator.remove();
                    continue;
                }
                iterator.remove();
            }
        }
        return result;
    }

    public List getTableOptions() throws FmCalculationException {
        if (this.tableNames == null) {
            String tableNamesString = this.context.evaluateExpression("TableNames ( \"" + this.getFileName() + "\" )").getStringData();
            this.tableNames = Arrays.asList(tableNamesString.split("[\\r\\n]+"));
        }
        return this.tableNames;
    }

    public String getCurrentTable() throws FmCalculationException {
        if (this.currentTable == null) {
            String result = this.context.evaluateExpression("Get(LayoutTableName)").getStringData();
            log.info("layoutTableName: " + result);
            this.currentTable = result;
        }
        return this.currentTable;
    }

    public PluginContext getContext() {
        return this.context;
    }

    public Map<String, List<String>> getFunctions() {
        if (this.functionMap == null) {
            BufferedReader br = new BufferedReader(new InputStreamReader(DesignInfo.class.getResourceAsStream("functions.txt")));
            HashMap result = new HashMap();
            LinkedList<String> currentList = null;
            try {
                String eachLine;
                while ((eachLine = br.readLine()) != null) {
                    if (eachLine.length() == 0) continue;
                    if (eachLine.charAt(0) == '[') {
                        String currentGroup = eachLine.substring(1, eachLine.length() - 1);
                        currentList = new LinkedList<String>();
                        result.put(currentGroup, currentList);
                        continue;
                    }
                    currentList.add(eachLine);
                }
                this.functionMap = result;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.functionMap;
    }
}

