/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.types.Converter;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMType;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticFunction
implements PluginFunction {
    private Method targetMethod;
    private Class<?>[] paramClasses;
    private Converter[] paramConverters;
    private int argCount;
    private String prototype;
    private String name = "";
    private int flags = 65280;
    private short functionID;
    private static final Logger log = Logger.getLogger(StaticFunction.class.getName());
    private Integer minArgs;
    private int maxArgs;
    private boolean isGuiFunction = false;

    public StaticFunction(Method methodToTrigger) throws FMType.UnsupportedTypeConversionException {
        this.initialize(methodToTrigger);
    }

    private void initialize(Method methodToTrigger) throws FMType.UnsupportedTypeConversionException {
        Class<?> lastParamType;
        this.targetMethod = methodToTrigger;
        this.paramClasses = this.targetMethod.getParameterTypes();
        this.maxArgs = this.argCount = this.paramClasses.length;
        if (this.paramClasses.length >= 1 && (lastParamType = this.paramClasses[this.paramClasses.length - 1]).isArray()) {
            this.maxArgs = -1;
            this.paramClasses[this.paramClasses.length - 1] = lastParamType.getComponentType();
        }
        this.paramConverters = new Converter[this.argCount];
        for (int n = 0; n < this.argCount; ++n) {
            Class<?> fmTypeClass = this.paramClasses[n];
            if (fmTypeClass.isArray()) {
                fmTypeClass = fmTypeClass.getComponentType();
            }
            this.paramConverters[n] = FMType.converterForClass(fmTypeClass);
        }
        this.setName(this.targetMethod.getName());
        StringBuffer buffer = new StringBuffer(30);
        for (int n = 0; n < this.argCount; ++n) {
            String className;
            int mark;
            if (n != 0) {
                buffer.append(" ; ");
            }
            if ((mark = (className = this.paramClasses[n].getName()).lastIndexOf(46)) != -1) {
                className = className.substring(mark + 1);
            }
            buffer.append(className);
        }
        this.prototype = buffer.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.functionID = (short)Math.abs(name.hashCode());
    }

    @Override
    public short getFunctionID() {
        return this.functionID;
    }

    @Override
    public String getPrototype() {
        return this.prototype;
    }

    public final void setPrototype(String prototype) {
        this.prototype = prototype;
    }

    @Override
    public int getMinArgs() {
        return this.minArgs == null ? this.maxArgs : this.minArgs;
    }

    public void setMinArgs(Integer minArgs) {
        this.minArgs = minArgs;
    }

    @Override
    public int getMaxArgs() {
        return this.maxArgs;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public final void setFlags(int flags) {
        this.flags = flags;
    }

    public final Method getTargetMethod() {
        return this.targetMethod;
    }

    @Override
    public boolean isGuiFunction() {
        return this.isGuiFunction;
    }

    public void setGuiFunction(boolean guiFunction) {
        this.isGuiFunction = guiFunction;
    }

    @Override
    public Object[] convertParams(FMData[] rawParams) {
        Object[] parameters = new Object[this.argCount];
        try {
            if (this.maxArgs == -1) {
                Class<?> paramClass;
                int n;
                for (n = 0; n < this.argCount - 1; ++n) {
                    paramClass = this.paramClasses[n];
                    if (n < rawParams.length) {
                        FMData rawParam = rawParams[n];
                        parameters[n] = this.paramConverters[n].convertData(rawParam, paramClass);
                        continue;
                    }
                    parameters[n] = null;
                }
                paramClass = this.paramClasses[n];
                Converter converter = this.paramConverters[n];
                int optionalParamCount = rawParams.length - n;
                if (optionalParamCount > 0) {
                    Object[] optionalParams = (Object[])Array.newInstance(paramClass, optionalParamCount);
                    int destIndex = 0;
                    while (n < rawParams.length) {
                        FMData rawParam = rawParams[n];
                        optionalParams[destIndex] = converter.convertData(rawParam, paramClass);
                        ++destIndex;
                        ++n;
                    }
                    parameters[this.argCount - 1] = optionalParams;
                }
            } else {
                for (int n = 0; n < this.argCount; ++n) {
                    Class<?> paramClass = this.paramClasses[n];
                    if (n < rawParams.length) {
                        FMData rawParam = rawParams[n];
                        parameters[n] = this.paramConverters[n].convertData(rawParam, paramClass);
                        continue;
                    }
                    parameters[n] = this.defaultClassValue(paramClass);
                }
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "PluginFunction {0} invoked with converted args {1}", new Object[]{this, Arrays.asList(parameters)});
            }
            return parameters;
        }
        catch (IndexOutOfBoundsException e) {
            log.log(Level.WARNING, "error in convertParams", e);
            throw new IllegalArgumentException(this.toString() + " Expected " + this.argCount + " parameters, but received " + rawParams.length);
        }
    }

    @Override
    public Object invoke(Plugin pluginInstance, Object[] parameters) throws IllegalAccessException, InvocationTargetException {
        try {
            return this.targetMethod.invoke((Object)pluginInstance, parameters);
        }
        catch (IllegalArgumentException e) {
            log.log(Level.SEVERE, "Make sure that PRIMITIVE TYPES ARE NOT USED AS OPTIONAL PARAMS");
            throw e;
        }
    }

    private Object defaultClassValue(Class<?> paramClass) {
        if (!paramClass.isPrimitive()) {
            return null;
        }
        if (paramClass == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (paramClass == Byte.TYPE) {
            return (byte)0;
        }
        if (paramClass == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (paramClass == Short.TYPE) {
            return (short)0;
        }
        if (paramClass == Integer.TYPE) {
            return 0;
        }
        if (paramClass == Long.TYPE) {
            return 0L;
        }
        if (paramClass == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (paramClass == Double.TYPE) {
            return 0.0;
        }
        throw new RuntimeException("Unknown primitive type '" + paramClass + "'");
    }

    public String toString() {
        return "PluginFunction{name='" + this.name + "'" + ", functionID=" + this.functionID + ", minArgs=" + this.minArgs + ", maxArgs=" + this.maxArgs + "}";
    }
}

