/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fmkit.FmCalculationException;
import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.PluginBridge;
import com.prosc.license.client.Registration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class BugReporter
extends JDialog {
    private static final Logger log = Logger.getLogger(BugReporter.class.getName());
    private Plugin whichPlugin;
    private Registration registration;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panel1;
    private JCheckBox includeLogOption;
    private JLabel label1;
    private JPanel panel2;
    private JLabel label2;
    private JTextField emailField;
    private JLabel label3;
    private JTextField phoneField;
    private JLabel label4;
    private JScrollPane scrollPane1;
    private JTextArea problemField;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public BugReporter(Frame parent, Plugin whichPlugin, Registration registration) {
        super(parent, true);
        this.whichPlugin = whichPlugin;
        this.registration = registration;
        this.initComponents();
    }

    public BugReporter(Dialog parent, Plugin whichPlugin, Registration registration) {
        super(parent, true);
        this.whichPlugin = whichPlugin;
        this.registration = registration;
        this.initComponents();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel1 = new JPanel();
        this.includeLogOption = new JCheckBox();
        this.label1 = new JLabel();
        this.panel2 = new JPanel();
        this.label2 = new JLabel();
        this.emailField = new JTextField();
        this.label3 = new JLabel();
        this.phoneField = new JTextField();
        this.label4 = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.problemField = new JTextArea();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.panel1.setLayout(new FlowLayout(4));
        this.includeLogOption.setText("Include log file");
        this.includeLogOption.setSelected(true);
        this.panel1.add(this.includeLogOption);
        this.contentPanel.add((Component)this.panel1, "South");
        this.label1.setText("Enter your bug report in the fields below:");
        this.contentPanel.add((Component)this.label1, "North");
        this.panel2.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panel2.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)this.panel2.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0};
        ((GridBagLayout)this.panel2.getLayout()).columnWeights = new double[]{0.0, 1.0, 1.0E-4};
        ((GridBagLayout)this.panel2.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, 1.0E-4};
        this.label2.setText("Email:");
        this.panel2.add((Component)this.label2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.panel2.add((Component)this.emailField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.label3.setText("Phone number:");
        this.panel2.add((Component)this.label3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.panel2.add((Component)this.phoneField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.label4.setText("Problem description");
        this.panel2.add((Component)this.label4, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.scrollPane1.setMinimumSize(new Dimension(300, 200));
        this.scrollPane1.setPreferredSize(new Dimension(400, 200));
        this.problemField.setWrapStyleWord(true);
        this.problemField.setLineWrap(true);
        this.scrollPane1.setViewportView(this.problemField);
        this.panel2.add((Component)this.scrollPane1, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.contentPanel.add((Component)this.panel2, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BugReporter.this.dispose();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BugReporter.this.submitBug();
                    BugReporter.this.dispose();
                }
                catch (IllegalArgumentException e1) {
                    JOptionPane.showMessageDialog(BugReporter.this, e1.getLocalizedMessage(), "Could not submit bug report", 0);
                }
                catch (Exception e1) {
                    log.log(Level.SEVERE, "Could not submit bug report", e1);
                    JOptionPane.showMessageDialog(BugReporter.this, e1.getLocalizedMessage(), "Could not submit bug report", 0);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitBug() throws IOException {
        HttpURLConnection urlConnection;
        block17: {
            if (this.emailField.getText() == null || this.emailField.getText().length() == 0) {
                throw new IllegalArgumentException("You must include an email address");
            }
            String bugReportUrl = "http://www.360works.com/BugReporter/Plugin";
            urlConnection = (HttpURLConnection)new URL(bugReportUrl).openConnection();
            urlConnection.setConnectTimeout(10000);
            urlConnection.setReadTimeout(10000);
            urlConnection.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(urlConnection.getOutputStream()));
            try {
                this.sendData(writer, "email", this.emailField.getText(), true);
                this.sendData(writer, "phone", this.phoneField.getText(), false);
                this.sendData(writer, "problemReport", this.problemField.getText(), false);
                this.sendData(writer, "pluginName", this.whichPlugin.getName(), false);
                this.sendData(writer, "pluginVersion", this.whichPlugin.getVersion().toString(), false);
                if (this.whichPlugin.getPluginBridge() != null) {
                    String systemEnvironment = this.whichPlugin.getPluginBridge().getSystemEnvironment();
                    try {
                        String filemakerVersion = this.whichPlugin.getContext().evaluateExpression("Get(ApplicationVersion)").getStringData();
                        systemEnvironment = systemEnvironment + "\nFileMaker version:" + filemakerVersion;
                        log.info("Successfully retrieved fileMaker version during configure: " + filemakerVersion);
                    }
                    catch (FmCalculationException e) {
                        if (e.getErrorCode() == 100) {
                            log.warning("Couldn't get FileMaker version because there is no file open.");
                        }
                        log.warning("Couldn't get FileMaker version: " + e.toString());
                    }
                    this.sendData(writer, "systemEnvironment", systemEnvironment, false);
                }
                if (this.registration != null) {
                    if (this.registration.getLicense() != null) {
                        this.sendData(writer, "orderId", "" + this.registration.getLicense().getOrderID(), false);
                    }
                    this.sendData(writer, "licenseInfo", this.registration.getLicenseInfo(), false);
                }
                if (!this.includeLogOption.isSelected() || !PluginBridge.getLogFile().exists()) break block17;
                writer.write("&log=");
                FileReader logReader = new FileReader(PluginBridge.getLogFile());
                char[] buff = new char[8192];
                try {
                    int charsRead;
                    while ((charsRead = logReader.read(buff)) != -1) {
                        String logChunk = new String(buff, 0, charsRead);
                        writer.write(URLEncoder.encode(logChunk, "utf-8"));
                    }
                }
                finally {
                    ((Reader)logReader).close();
                }
            }
            finally {
                writer.close();
            }
        }
        if (urlConnection.getResponseCode() < 200 || urlConnection.getResponseCode() >= 300) {
            InputStream err = urlConnection.getErrorStream();
            try {
                byte[] errBytes = new byte[err.available()];
                int count = err.read(errBytes);
                String errString = new String(errBytes, 0, count);
                throw new IllegalStateException(errString);
            }
            catch (Throwable throwable) {
                err.close();
                throw throwable;
            }
        }
    }

    private void sendData(Writer writer, String key, String value, boolean isFirst) throws IOException {
        if (!isFirst) {
            writer.write("&");
        }
        writer.write(URLEncoder.encode(key, "utf-8") + "=" + URLEncoder.encode(value, "utf-8"));
    }
}

