/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fm;

import com.prosc.fm.ClipboardType;
import com.prosc.fm.StopParsing;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class FMClipUtils {
    private static final Logger log = Logger.getLogger(FMClipUtils.class.getName());

    public ClipboardType getTypeForData(String xmlData) throws SAXException {
        final ClipboardType[] result = new ClipboardType[1];
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            InputSource input = new InputSource(new StringReader(xmlData));
            DefaultHandler2 handler = new DefaultHandler2(){
                boolean foundHeader = false;

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("fmxmlsnippet".equals(qName)) {
                        this.foundHeader = true;
                    } else {
                        if (this.foundHeader) {
                            result[0] = ClipboardType.valueOf(qName);
                            throw new StopParsing();
                        }
                        log.info("Found unexpected element: " + qName);
                    }
                }
            };
            parser.parse(input, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (StopParsing e) {
            return result[0];
        }
        throw new IllegalArgumentException("The provided xmlData does not contain an fmxmlsnippet element with a type attribute.");
    }
}

