/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.beanshell.compilation;

import com.prosc.beanshell.compilation.CompiledClass;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.tools.GroovyClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionCompiler {
    private final File outputDir = new File(System.getProperty("java.io.tmpdir"), "GroovyCompiler");

    public List<CompiledClass> compile(String functionName, String script, ClassLoader cl) {
        CompilationUnit unit = new CompilationUnit();
        if (cl != null) {
            unit.setClassLoader(new GroovyClassLoader(cl));
        }
        unit.addSource(functionName, script);
        unit.getConfiguration().setTargetDirectory(this.outputDir);
        unit.compile();
        List compiledClasses = unit.getClasses();
        ArrayList<CompiledClass> result = new ArrayList<CompiledClass>(compiledClasses.size());
        for (GroovyClass eachClass : compiledClasses) {
            String fullyQualified = eachClass.getName();
            result.add(new CompiledClass(fullyQualified, eachClass.getBytes()));
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        CompilationUnit unit = new CompilationUnit();
        unit.addSource("MyHelloClass", new FileInputStream("Plugins/BeanShell/support/compile_me/hello.groovy"));
        unit.compile();
        TestClassLoader loader = new TestClassLoader();
        for (Object eachClass : unit.getClasses()) {
            GroovyClass compiled = (GroovyClass)eachClass;
            System.out.println("Compiled: " + compiled);
            byte[] bytes = compiled.getBytes();
            Class loaded = loader.defineGroovyClass(compiled.getName(), bytes);
            System.out.println("Loaded class: " + loaded);
        }
        Class<?> compiled = loader.loadClass("MyHelloClass");
        ((Script)compiled.newInstance()).run();
    }

    private static class TestClassLoader
    extends ClassLoader {
        private TestClassLoader() {
        }

        public Class defineGroovyClass(String name, byte[] bytes) {
            return this.defineClass(name, bytes, 0, bytes.length);
        }
    }
}

