/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.Nullable;

public class PropertiesHolder
extends Properties {
    private final File file;
    private final Preferences prefs;

    public PropertiesHolder(Preferences prefs) throws BackingStoreException {
        this.file = null;
        this.prefs = prefs;
        prefs.sync();
        for (String key : prefs.keys()) {
            this.put(key, prefs.get(key, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesHolder(File file, boolean readOnly) throws IOException {
        this.file = file;
        this.prefs = null;
        if (file.exists()) {
            if (!file.canRead()) {
                throw new IOException("File exists at " + file + ", but it is not readable.");
            }
            if (!file.canWrite() && !readOnly) {
                throw new IOException("File exists at " + file + ", but it is not writeable.");
            }
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
            try {
                this.load(reader);
            }
            finally {
                reader.close();
            }
        } else {
            if (readOnly) {
                throw new FileNotFoundException("No properties file exists at " + file);
            }
            if (!file.createNewFile()) {
                throw new IOException("New properties file could not be created at " + file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save(@Nullable String comments) {
        block8: {
            try {
                if (this.file != null) {
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "utf-8");
                    try {
                        this.store(writer, comments);
                        break block8;
                    }
                    finally {
                        writer.close();
                    }
                }
                for (Map.Entry<Object, Object> entry : this.entrySet()) {
                    this.prefs.put((String)entry.getKey(), (String)entry.getValue());
                }
                this.prefs.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (BackingStoreException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

