/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class CalendarUtils {
    private static final int[] orderedUnitsForYear = new int[]{2, 5, 11, 12, 13, 14};

    public static int yearsBetweenCalendars(Calendar firstDate, Calendar secondDate) {
        int result = secondDate.get(1) - firstDate.get(1);
        for (int n = 0; n < orderedUnitsForYear.length; ++n) {
            int difference = secondDate.get(orderedUnitsForYear[n]) - firstDate.get(orderedUnitsForYear[n]);
            if (difference > 0) {
                return result;
            }
            if (difference >= 0) continue;
            return result - 1;
        }
        return result;
    }

    public static void setTimeToFirstSecondOfDay(Calendar c) {
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }

    public static void setTimeToFirstSecondOfMonth(Calendar cal) {
        int month = cal.get(2);
        int year = cal.get(1);
        cal.clear();
        cal.set(year, month, 1);
    }

    public static void setTimeToLastSecondOfMonth(Calendar cal) {
        CalendarUtils.setTimeToFirstSecondOfMonth(cal);
        cal.add(2, 1);
        cal.add(13, -1);
    }

    public static void setTimeToLastSecondOfDay(Calendar cal) {
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 0);
    }

    public static double getDateRangeMonths(Date d1, Date d2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d2);
        CalendarUtils.setTimeToFirstSecondOfDay(cal);
        long d2millis = cal.getTimeInMillis();
        cal.setTime(d1);
        CalendarUtils.setTimeToFirstSecondOfDay(cal);
        double result = 0.0;
        while (cal.getTimeInMillis() <= d2millis) {
            cal.add(2, 1);
            result += 1.0;
        }
        cal.add(2, -1);
        result -= 1.0;
        int daysDifference = 0;
        while (cal.getTimeInMillis() < d2millis) {
            cal.add(6, 1);
            ++daysDifference;
        }
        return result += (double)daysDifference / 30.0;
    }

    public static TimeZone convertSecondOffsetIntoTimeZone(int secondsOffset, Date when) {
        String[] ids = new String[]{"GMT", "US/Eastern", "US/Central", "US/Mountain", "US/Pacific", "Asia/Tokyo", "Europe/Moscow", "Europe/Helsinki", "Europe/Paris", "Australia/Sydney", "Pacific/Guam"};
        TimeZone result = CalendarUtils.checkTimeZoneIds(ids, secondsOffset, when);
        if (result == null) {
            ids = TimeZone.getAvailableIDs();
            result = CalendarUtils.checkTimeZoneIds(ids, secondsOffset, when);
        }
        if (result == null) {
            throw new IllegalArgumentException("No matching time zone for " + secondsOffset + " seconds.");
        }
        return result;
    }

    private static TimeZone checkTimeZoneIds(String[] ids, int secondsOffset, Date when) {
        int millis = secondsOffset * 1000;
        for (String id : ids) {
            TimeZone zone = TimeZone.getTimeZone(id);
            if (!(when == null ? zone.getRawOffset() == millis : zone.getOffset(when.getTime()) == millis)) continue;
            return zone;
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println("Starting test");
        CalendarUtils.assertion(CalendarUtils.yearsBetweenCalendars(new GregorianCalendar(2003, 11, 20), new GregorianCalendar(2003, 11, 21)) == 0);
        CalendarUtils.assertion(CalendarUtils.yearsBetweenCalendars(new GregorianCalendar(2003, 11, 20), new GregorianCalendar(2004, 11, 21)) == 1);
        CalendarUtils.assertion(CalendarUtils.yearsBetweenCalendars(new GregorianCalendar(2003, 11, 20), new GregorianCalendar(2004, 11, 19)) == 0);
        CalendarUtils.assertion(CalendarUtils.yearsBetweenCalendars(new GregorianCalendar(2004, 2, 29), new GregorianCalendar(2005, 3, 1)) == 1);
        CalendarUtils.assertion(CalendarUtils.yearsBetweenCalendars(new GregorianCalendar(2004, 2, 29), new GregorianCalendar(2005, 2, 28)) == 0);
        CalendarUtils.assertion(CalendarUtils.yearsBetweenCalendars(new GregorianCalendar(2004, 2, 29), new GregorianCalendar(2003, 2, 28)) == -2);
        CalendarUtils.assertion(CalendarUtils.getDateRangeMonths(new GregorianCalendar(2005, 0, 10).getTime(), new GregorianCalendar(2005, 1, 28).getTime()) == 1.6);
        CalendarUtils.assertion(CalendarUtils.getDateRangeMonths(new GregorianCalendar(2005, 1, 1).getTime(), new GregorianCalendar(2005, 2, 1).getTime()) == 1.0);
        CalendarUtils.assertion(CalendarUtils.getDateRangeMonths(new GregorianCalendar(2005, 1, 1).getTime(), new GregorianCalendar(2005, 2, 2).getTime()) == 1.0333333333333334);
        CalendarUtils.assertion(CalendarUtils.getDateRangeMonths(new GregorianCalendar(2005, 1, 1).getTime(), new GregorianCalendar(2005, 2, 5).getTime()) == 1.1333333333333333);
        CalendarUtils.assertion(CalendarUtils.getDateRangeMonths(new GregorianCalendar(2005, 1, 1).getTime(), new GregorianCalendar(2005, 1, 1).getTime()) == 0.0);
        CalendarUtils.assertion(CalendarUtils.getDateRangeMonths(new GregorianCalendar(2005, 1, 1).getTime(), new GregorianCalendar(2005, 1, 2).getTime()) == 0.03333333333333333);
        CalendarUtils.assertion(CalendarUtils.getDateRangeMonths(new GregorianCalendar(2005, 1, 1).getTime(), new GregorianCalendar(2005, 1, 25).getTime()) == 0.8);
        System.out.println("Completed test");
    }

    private static void assertion(boolean condition) {
        if (!condition) {
            throw new RuntimeException("Assertion failed");
        }
    }

    public static void setTimeToFirstSundayOfWeek(Calendar cal) {
        long oldMillis = cal.getTimeInMillis();
        cal.set(7, 1);
        if (cal.getTimeInMillis() > oldMillis) {
            cal.add(4, -1);
        }
    }

    public static String currentYear() {
        return new SimpleDateFormat("yyyy").format(new Date());
    }

    public static Date addDays(Date dateFrom, int numberOfDays) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateFrom);
        cal.add(5, numberOfDays);
        return cal.getTime();
    }

    public static void setTimeToFirstSecondOfYear(Calendar cal) {
        cal.set(2, 0);
        CalendarUtils.setTimeToFirstSecondOfMonth(cal);
    }
}

