/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.license.client.network;

import com.prosc.license.client.InvalidLicenseException;
import com.prosc.license.client.OfflineLicenseException;
import com.prosc.license.client.network.LicenseParams;
import com.prosc.util.PropertiesHolder;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;

public class OfflineModel {
    private static final Logger log = Logger.getLogger(OfflineModel.class.getName());
    private final LicenseParams params;
    private String cachedLicenseKey;
    private long cachedOn;
    private final PropertiesHolder props;

    public OfflineModel(LicenseParams params, PropertiesHolder props) {
        this.params = params;
        this.props = props;
    }

    public void checkRegistration(boolean requireNetworkOnActivation) throws InvalidLicenseException {
        String cachedLicenseKey = this.getCachedLicenseKey();
        if (cachedLicenseKey == null) {
            if (requireNetworkOnActivation) {
                throw new OfflineLicenseException("You must have a network connection when you use this software for the first time.", this.params.registration.getLicense());
            }
            log.warning("Could not communicate with license server on initial activation, but requireNetworkOnActivation is false, so will proceed normally.");
        } else {
            this.params.registration.setLicenseKey(cachedLicenseKey);
            this.params.registration.checkLicense();
            this.checkOfflineMaxDays();
            log.info("Local license check succeeded");
        }
    }

    private void checkOfflineMaxDays() throws InvalidLicenseException {
        long cachedOn = this.getCachedOn();
        if (this.params.maxDaysOffline == 0) {
            throw new InvalidLicenseException("Please connect to the internet to use this software", this.params.registration.getLicense());
        }
        if (System.currentTimeMillis() > cachedOn + (long)this.params.maxDaysOffline * 86400000L) {
            throw new InvalidLicenseException("You have been offline for more than " + this.params.maxDaysOffline + " days, please connect to the internet to register with 360Works license server.", this.params.registration.getLicense());
        }
    }

    private String getCachedLicenseKey() {
        if (this.cachedLicenseKey == null) {
            this.cachedLicenseKey = this.props.getProperty(this.prefKeyForLicense(), null);
        }
        return this.cachedLicenseKey;
    }

    private long getCachedOn() {
        if (this.cachedOn == 0L) {
            this.cachedOn = Long.parseLong(this.props.getProperty(this.prefKeyForCacheTimestamp(), "0"));
        }
        return this.cachedOn;
    }

    public void cacheLicense(String licenseKey) throws BackingStoreException {
        if (licenseKey == null || licenseKey.length() == 0) {
            return;
        }
        this.cachedLicenseKey = licenseKey;
        this.cachedOn = System.currentTimeMillis();
        this.props.put(this.prefKeyForLicense(), licenseKey);
        this.props.put(this.prefKeyForCacheTimestamp(), String.valueOf(this.cachedOn));
        this.props.save(null);
    }

    private String prefKeyForLicense() {
        return "com.prosc.license." + this.params.registration.getStoreNumber() + ".license";
    }

    private String prefKeyForCacheTimestamp() {
        return "com.prosc.license." + this.params.registration.getStoreNumber() + ".cachedOn";
    }
}

