/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser {
    private boolean aggregateContent;
    private Object target;
    private Map containerCallbacks = new HashMap();
    private Map elementCallbacks = new HashMap();
    private static final Class[] containerParams = new Class[]{Boolean.TYPE, Attributes.class};
    private XMLReader xReader;
    private EventHandler handler;
    private boolean verbose = false;

    public boolean verbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public XmlParser() {
        this(true);
    }

    public XmlParser(boolean aggregateContent) {
        this.aggregateContent = aggregateContent;
        this.handler = new EventHandler();
        this.xReader.setContentHandler(this.handler);
    }

    public synchronized void addContainerCallback(String callbackName, String path) {
        this.containerCallbacks.put(path.toLowerCase(), new CallbackDescriptor(callbackName, containerParams));
    }

    public synchronized void addElementCallback(String callbackName, Class conversionClass, String path) {
        Class[] elementParams = this.aggregateContent ? new Class[]{conversionClass} : new Class[]{conversionClass, Boolean.TYPE};
        this.elementCallbacks.put(path.toLowerCase(), new CallbackDescriptor(callbackName, elementParams));
    }

    public synchronized void parse(InputStream stream, Object startingTarget) throws IOException, SAXException {
        if (this.verbose) {
            System.out.println("Beginning parse - element callbacks: " + this.elementCallbacks);
            System.out.println("container callbacks: " + this.containerCallbacks);
        }
        this.setTarget(startingTarget);
        this.xReader.parse(new InputSource(stream));
    }

    private synchronized Object target() {
        return this.target;
    }

    private synchronized void setTarget(Object input) {
        this.target = input;
    }

    public static class SelfTest {
        public static void main(String[] args) throws Exception {
            XmlParser parser = new XmlParser();
            parser.addElementCallback("setShippingMethodCode", String.class, "RatingServiceSelectionResponse/RatedShipment/Service/Code/");
            parser.addElementCallback("setPrice", BigDecimal.class, "RatingServiceSelectionResponse/RatedShipment/TotalCharges/MonetaryValue/");
            parser.addElementCallback("setServiceOptionPrice", BigDecimal.class, "RatingServiceSelectionResponse/RatedShipment/ServiceOptionsCharges/MonetaryValue/");
            parser.addElementCallback("setTransportationPrice", BigDecimal.class, "RatingServiceSelectionResponse/RatedShipment/TransportationCharges/MonetaryValue/");
            parser.addElementCallback("setBillingWeight", Float.class, "RatingServiceSelectionResponse/RatedShipment/BillingWeight/Weight/");
            parser.parse(new FileInputStream("/Users/jesse/Projects/ProscBundle support/shop_result.xml"), new TestTarget());
        }

        private static class TestTarget {
            private TestTarget() {
            }

            public void setResponseCode(Integer input) {
                System.out.println("responseCode: (" + input + ")");
            }

            public void setShippingMethodCode(String input) {
                System.out.println("shippingMethodCode: (" + input + ")");
            }

            public void setPrice(BigDecimal input) {
                System.out.println("price: (" + input + ")");
            }

            public void setServiceOptionPrice(BigDecimal input) {
                System.out.println("serviceOptionPrice: (" + input + ")");
            }

            public void setTransportationPrice(BigDecimal input) {
                System.out.println("transportationPrice: (" + input + ")");
            }

            public void setBillingWeight(Float input) {
                System.out.println("billingWeight: (" + input + ")");
            }
        }
    }

    private class CallbackDescriptor {
        String methodName;
        Class[] paramTypes;

        public CallbackDescriptor(String methodName, Class[] paramTypes) {
            this.methodName = methodName;
            this.paramTypes = paramTypes;
        }

        public Object invoke(Object targetObject, Object[] parameters) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            if (targetObject instanceof Class) {
                return ((Class)targetObject).getMethod(this.methodName, this.paramTypes).invoke(null, parameters);
            }
            return targetObject.getClass().getMethod(this.methodName, this.paramTypes).invoke(targetObject, parameters);
        }

        public String userDescription() {
            StringBuffer description = new StringBuffer();
            description.append(this.methodName + "(");
            for (int n = 0; n < this.paramTypes.length; ++n) {
                if (n > 0) {
                    description.append(", ");
                }
                description.append(this.paramTypes[n].getName());
            }
            description.append(")");
            return description.toString();
        }
    }

    private class EventHandler
    extends DefaultHandler {
        private CallbackDescriptor containerCallback;
        private CallbackDescriptor elementCallback;
        private StringBuffer currentData = new StringBuffer();
        private StringBuffer currentElement = new StringBuffer();
        private Stack containerStack = new Stack();

        private EventHandler() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes atts) {
            this.currentElement.append(qName + '/');
            if (XmlParser.this.verbose) {
                System.out.println("Starting element: " + this.currentElement);
            }
            this.containerStack.push(new XMLParsingContext(this.containerCallback, this.elementCallback, XmlParser.this.target(), atts));
            this.elementCallback = (CallbackDescriptor)XmlParser.this.elementCallbacks.get(this.currentElement.toString().toLowerCase());
            this.containerCallback = (CallbackDescriptor)XmlParser.this.containerCallbacks.get(this.currentElement.toString().toLowerCase());
            if (this.containerCallback != null) {
                try {
                    Object newTarget = this.containerCallback.invoke(XmlParser.this.target(), new Object[]{Boolean.TRUE, atts});
                    if (newTarget != null) {
                        XmlParser.this.setTarget(newTarget);
                    }
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
                catch (NoSuchMethodException ex) {
                    String error = "Could not find container callback method " + this.containerCallback.userDescription() + " in class: " + XmlParser.this.target().getClass();
                    throw new RuntimeException(error);
                }
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            if (this.elementCallback != null && this.currentData.length() > 0) {
                this.sendData();
            }
            this.currentElement.setLength(this.currentElement.length() - qName.length() - 1);
            XMLParsingContext currentContext = (XMLParsingContext)this.containerStack.pop();
            XmlParser.this.setTarget(currentContext.contextTarget);
            if (this.containerCallback != null) {
                try {
                    this.containerCallback.invoke(XmlParser.this.target(), new Object[]{Boolean.FALSE, currentContext.attributes});
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
                catch (NoSuchMethodException ex) {
                    throw new RuntimeException(ex.getMessage());
                }
            }
            this.containerCallback = currentContext.containerCBDescriptor;
            this.elementCallback = currentContext.elementCBDescriptor;
        }

        @Override
        public void characters(char[] ch, int offset, int length) {
            if (this.elementCallback != null) {
                if (!XmlParser.this.aggregateContent && this.currentData.length() > 0) {
                    this.sendData();
                }
                this.currentData.append(ch, offset, length);
            }
        }

        private void sendData() {
            Object convertedData = this.convertData(this.currentData.toString(), this.elementCallback.paramTypes[0]);
            Object[] params = XmlParser.this.aggregateContent ? new Object[]{convertedData} : new Object[]{convertedData, Boolean.TRUE};
            try {
                if (XmlParser.this.verbose) {
                    System.out.println("Triggering callback for " + this.currentElement + " with data: " + convertedData);
                }
                this.elementCallback.invoke(XmlParser.this.target(), params);
                this.currentData.setLength(0);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (NoSuchMethodException ex) {
                String error = "Could not find element callback method " + this.elementCallback.userDescription() + " in class: " + XmlParser.this.target().getClass();
                throw new RuntimeException(error);
            }
        }

        private Object convertData(String input, Class conversionClass) {
            if (conversionClass == String.class) {
                return input;
            }
            if (conversionClass == BigDecimal.class) {
                return new BigDecimal(input.trim());
            }
            if (conversionClass == BigInteger.class) {
                return new BigInteger(input.trim());
            }
            try {
                return conversionClass.getMethod("valueOf", String.class).invoke(null, input);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            return null;
        }

        private class XMLParsingContext {
            CallbackDescriptor containerCBDescriptor;
            CallbackDescriptor elementCBDescriptor;
            Object contextTarget;
            Attributes attributes;

            public XMLParsingContext(CallbackDescriptor containerCallback, CallbackDescriptor elementCallback, Object contextTarget, Attributes attributes) {
                this.containerCBDescriptor = containerCallback;
                this.elementCBDescriptor = elementCallback;
                this.contextTarget = contextTarget;
                this.attributes = attributes;
            }

            public XMLParsingContext() {
            }
        }
    }
}

