/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TokenScanningInputStream
extends InputStream {
    private final InputStream input;
    private final byte[] token;
    private int tokenMark = 0;
    private final int tokenLength;
    private boolean isMoreDataAvailable = true;

    public TokenScanningInputStream(BufferedInputStream input, byte[] token) {
        this.input = input;
        this.token = token;
        this.tokenLength = token.length;
    }

    @Override
    public int read() throws IOException {
        if (this.tokenMark == this.tokenLength) {
            return -1;
        }
        int result = this.input.read();
        this.tokenMark = result != this.token[this.tokenMark] ? 0 : ++this.tokenMark;
        if (result == -1) {
            this.isMoreDataAvailable = false;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.tokenMark == this.tokenLength) {
            return -1;
        }
        int endMark = off + len;
        if (endMark > b.length) {
            endMark = b.length;
        }
        int n = off;
        while (n < endMark) {
            int eachByte = this.read();
            if (eachByte == -1) {
                if (n != off) break;
                return -1;
            }
            b[n++] = (byte)eachByte;
        }
        return n - off;
    }

    public boolean nextChunk() {
        this.tokenMark = 0;
        return this.isMoreDataAvailable;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
        super.close();
    }
}

