/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.File;
import java.io.FileFilter;
import java.util.LinkedList;

public class DirectoryUtils {
    public static String uniquePathForPath(String inputPath) {
        File theFile = new File(inputPath);
        if (!theFile.exists()) {
            return inputPath;
        }
        String parentPath = theFile.getParent();
        int indexOfSuffix = theFile.getName().indexOf(46);
        if (indexOfSuffix == -1) {
            indexOfSuffix = theFile.getName().length();
        }
        String prefix = theFile.getName().substring(0, indexOfSuffix);
        String suffix = theFile.getName().substring(indexOfSuffix);
        int increment = 0;
        while ((theFile = new File(inputPath = parentPath + "/" + prefix + ++increment + suffix)).exists()) {
        }
        return inputPath;
    }

    public static String[] directoryContents(String inputPath) {
        File theFile = new File(inputPath);
        return theFile.list();
    }

    public static File[] listRecursive(File whichFolder, FileFilter filter) {
        LinkedList result = new LinkedList();
        DirectoryUtils.listRecursive(whichFolder, filter, result);
        return result.toArray(new File[result.size()]);
    }

    private static void listRecursive(File whichFolder, FileFilter filter, LinkedList result) {
        File[] items = whichFolder.listFiles();
        if (items != null) {
            for (int n = 0; n < items.length; ++n) {
                if (items[n].isDirectory()) {
                    DirectoryUtils.listRecursive(items[n], filter, result);
                    continue;
                }
                if (filter != null && !filter.accept(items[n])) continue;
                result.add(items[n]);
            }
        }
    }

    public static void main(String[] args) {
        String inputPath = "/Users/jesse/Downloads/FSA.gif";
        System.out.println("Result for " + inputPath + " is " + DirectoryUtils.uniquePathForPath(inputPath));
    }
}

