/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.regex.Pattern;

public class CustomNameFilter
implements FileFilter,
FilenameFilter,
Serializable {
    boolean stripInvisibles = false;
    boolean hasSuffix = false;
    private Pattern regex = null;

    public CustomNameFilter(boolean stripInvisibles, String suffixFilter) {
        this.stripInvisibles = stripInvisibles;
        if (suffixFilter != null) {
            this.regex = Pattern.compile(".*" + Pattern.quote(suffixFilter), 2);
            this.hasSuffix = true;
        }
    }

    public CustomNameFilter(boolean stripInvisibles, Pattern regex) {
        this.stripInvisibles = stripInvisibles;
        this.regex = regex;
    }

    @Override
    public boolean accept(File pathname) {
        return this.accept(pathname.getParentFile(), pathname.getName());
    }

    @Override
    public boolean accept(File dir, String name) {
        if (this.stripInvisibles && name.charAt(0) == '.') {
            return false;
        }
        return this.regex == null || this.regex.matcher(name).matches();
    }
}

