/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.infrastructure;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.apache.commons.lang3.time.FastDateFormat;
import sun.security.action.GetPropertyAction;

public class SimpleFormatterThreadsafe
extends Formatter {
    FastDateFormat dateFormat = FastDateFormat.getDateInstance(2);
    FastDateFormat timeFormat = FastDateFormat.getTimeInstance(0);
    private static String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

    @Override
    public String format(LogRecord record) {
        Date date = new Date();
        String message = this.formatMessage(record);
        String stacktrace = null;
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                stacktrace = sw.toString();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        StringBuilder text = new StringBuilder(message.length() + 300 + (stacktrace == null ? 0 : stacktrace.length()));
        text.append(this.dateFormat.format(date)).append(" ").append(this.timeFormat.format(date));
        text.append(" ");
        if (record.getSourceClassName() != null) {
            text.append(record.getSourceClassName());
        } else {
            text.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            text.append(" ");
            text.append(record.getSourceMethodName());
        }
        text.append(lineSeparator);
        text.append(record.getLevel().getLocalizedName());
        text.append(": ");
        text.append(message);
        message = null;
        text.append(lineSeparator);
        if (stacktrace != null) {
            text.append(stacktrace);
        }
        return text.toString();
    }
}

