/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

import com.prosc.format.Wikifier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WikiFormat
extends Format {
    private List wikifiers = new LinkedList();
    private boolean needsSort;
    public static final Pattern HTML_SPECIAL_CHARS = Pattern.compile("[&\"]");
    public static final String[] ALLOWED_TAGS_DEFAULT = new String[]{"img", "a", "b", "br", "code", "div", "em", "i", "span", "strong", "h1", "h2", "h3", "h4", "h5", "h6", "address"};

    public WikiFormat() {
        this(ALLOWED_TAGS_DEFAULT, true);
    }

    public WikiFormat(String[] allowedTags, boolean generateTableOfContents) {
        WikiFormat format = this;
        format.addWikifier(new HeadingWikifier(generateTableOfContents));
        format.addWikifier(new ParagraphWikifier());
        format.addWikifier(new HorizontalRuleWikifier());
        format.addWikifier(new ListWikifier());
        format.addWikifier(new DefinitionListWikifier());
        format.addWikifier(new Linkifier());
        format.addWikifier(new PatternWikifier("**", "**", "<strong>", "</strong>"));
        HashSet<String> allowedTagsSet = new HashSet<String>(Arrays.asList(allowedTags));
        format.addWikifier(new EscapeHtml(allowedTagsSet));
        format.addWikifier(new TrimWikifier());
        format.addWikifier(new BracketImageWikifier());
        format.addWikifier(new BracketHyperlinkWikifier());
        format.addWikifier(new PreWikifier());
    }

    public WikiFormat(Collection wikifiers) {
        this.wikifiers = new ArrayList(wikifiers);
    }

    public List getWikifiers() {
        return this.wikifiers;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null) {
            return toAppendTo;
        }
        Reader otherReader = obj instanceof InputStream ? new InputStreamReader((InputStream)obj) : (obj instanceof Reader ? (Reader)obj : new StringReader(obj.toString()));
        BufferedReader bufferedReader = new BufferedReader(otherReader);
        int oldLength = toAppendTo.length();
        this.sortWikifiers();
        ListIterator iterator = this.wikifiers.listIterator();
        while (iterator.hasNext()) {
            ((Wikifier)iterator.next()).cleanup(toAppendTo);
            toAppendTo.setLength(oldLength);
        }
        try {
            ListIterator iterator2;
            String eachLine;
            String lineSeparator = "";
            while ((eachLine = bufferedReader.readLine()) != null) {
                this.sortWikifiers();
                iterator2 = this.wikifiers.listIterator();
                while (iterator2.hasNext()) {
                    Wikifier wikifier = (Wikifier)iterator2.next();
                    eachLine = wikifier.wikify(eachLine, toAppendTo);
                }
                toAppendTo.append(lineSeparator).append(eachLine);
                lineSeparator = "\n";
            }
            iterator2 = this.wikifiers.listIterator();
            while (iterator2.hasNext()) {
                ((Wikifier)iterator2.next()).cleanup(toAppendTo);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return toAppendTo;
    }

    private void sortWikifiers() {
        if (this.needsSort) {
            Collections.sort(this.wikifiers);
        }
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        int bodyIndex = source.indexOf("<body>");
        if (bodyIndex != -1) {
            source = source.substring(bodyIndex);
        }
        source = source.replaceAll("\\s*<li>(.*)</li>\\s*", "* $1\n");
        source = source.replaceAll("<style>.*</style>", "");
        source = source.replaceAll("<!--.*-->", "");
        source = source.replaceAll("</h([0-6])>", "</h$1>\n\n");
        source = source.replaceAll("<[^>]*>", "");
        source = source.replaceAll("\n\n\n+", "\n\n");
        return source;
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        return this.parseObject(source, null);
    }

    private static String escapeHtml(String line) {
        Matcher m = HTML_SPECIAL_CHARS.matcher(line);
        StringBuffer buffer = new StringBuffer((int)((double)line.length() * 1.1));
        while (m.find()) {
            char c = m.group().charAt(0);
            String replacement = "&#" + c + ";";
            if (c == '\"') {
                replacement = "&quot;";
            } else if (c == '&') {
                replacement = "&amp;";
            }
            m.appendReplacement(buffer, replacement);
        }
        m.appendTail(buffer);
        line = buffer.toString();
        return line;
    }

    public static WikiFormat getCreoleInstance(boolean generateTableOfContents) {
        return new WikiFormat(new String[]{"code", "div", "span"}, generateTableOfContents);
    }

    public void addWikifier(Wikifier wikifier) {
        this.wikifiers.add(wikifier);
        this.needsSort = true;
    }

    public static class BracketHyperlinkWikifier
    extends DefaultWikifier {
        private static Pattern pattern = Pattern.compile("\\[(\\S+)\\s*([^\\]]*)\\]");

        @Override
        public int getPriority() {
            return 8;
        }

        @Override
        public String wikify(String line, StringBuffer toAppendTo) {
            Matcher matcher = pattern.matcher(line);
            while (matcher.find()) {
                String linkText = matcher.group(2);
                if (linkText == null || linkText.length() == 0) {
                    linkText = matcher.group(1);
                }
                line = matcher.replaceFirst("<a href=\"$1\">" + linkText + "</a>");
                matcher.reset(line);
            }
            return line;
        }
    }

    public static class BracketImageWikifier
    extends DefaultWikifier {
        private static final int PRIORITY = 7;
        static Pattern pattern = Pattern.compile("\\[([\\S]+\\.(?:jpg|gif|png))\\s*([^\\]]*)\\]", 2);

        @Override
        public int getPriority() {
            return 7;
        }

        @Override
        public String wikify(String line, StringBuffer toAppendTo) {
            line = pattern.matcher(line).replaceAll("<img alt=\"$2\" src=\"$1\"/>");
            return line;
        }
    }

    public static class TrimWikifier
    extends DefaultWikifier {
        @Override
        public String wikify(String line, StringBuffer toAppendTo) {
            return line.trim();
        }

        @Override
        public int getPriority() {
            return 1;
        }
    }

    public static class PreWikifier
    extends DefaultWikifier {
        private boolean isActive;
        private String openingLine;

        @Override
        public void cleanup(StringBuffer toAppendTo) {
            if (this.isActive) {
                this.appendOpeningLine(toAppendTo);
                toAppendTo.append("</pre>");
                this.isActive = false;
            }
        }

        private void appendOpeningLine(StringBuffer toAppendTo) {
            if (this.openingLine != null) {
                toAppendTo.append(this.openingLine).append("\n");
                this.openingLine = null;
            }
        }

        @Override
        public String wikify(String line, StringBuffer toAppendTo) {
            if (line.startsWith("<pre") || line.startsWith("<PRE")) {
                this.isActive = true;
                this.openingLine = line;
                return "";
            }
            if (line.startsWith("</pre>") || line.startsWith("</PRE>")) {
                this.cleanup(toAppendTo);
                return "";
            }
            if (this.isActive) {
                this.appendOpeningLine(toAppendTo);
                toAppendTo.append(WikiFormat.escapeHtml(line));
                return "";
            }
            return line;
        }

        @Override
        public int getPriority() {
            return 0;
        }
    }

    public static class DefinitionListWikifier
    extends DefaultWikifier {
        boolean isInList;
        Pattern pattern = Pattern.compile(";\\s*([^:]+)\\s*:\\s*(.*)");

        @Override
        public String wikify(String line, StringBuffer toAppendTo) {
            Matcher m = this.pattern.matcher(line);
            if (m.lookingAt()) {
                String listStarter = this.isInList ? "" : "<dl>";
                line = listStarter + "<dt>" + m.group(1) + "</dt><dd>" + m.group(2) + "</dd>";
                this.isInList = true;
            } else {
                this.cleanup(toAppendTo);
            }
            return line;
        }

        @Override
        public void cleanup(StringBuffer toAppendTo) {
            if (this.isInList) {
                toAppendTo.append("</dl>");
                this.isInList = false;
            }
        }

        @Override
        public int getPriority() {
            return 5;
        }
    }

    public static class Linkifier
    extends DefaultWikifier {
        static Pattern pattern = Pattern.compile("([^\">])(http://[^\\s]+[^\\s\\)\\.])");

        @Override
        public String wikify(String line, StringBuffer toAppendTo) {
            line = pattern.matcher(line).replaceAll("$1<a href=\"$2\">$2</a>");
            return line;
        }

        @Override
        public int getPriority() {
            return 11;
        }
    }

    public static class EscapeHtml
    extends DefaultWikifier {
        Set allowedTags;
        public static final Pattern ESCAPE_HTML_PATTERN = Pattern.compile("<(/?)([a-zA-Z1-6]+)([^>]*)>");

        public EscapeHtml() {
            this.allowedTags = new HashSet();
        }

        public Set getAllowedTags() {
            return this.allowedTags;
        }

        public EscapeHtml(Set allowedTags) {
            if (allowedTags == null) {
                throw new NullPointerException("allowedTags must not be null.");
            }
            this.allowedTags = allowedTags;
        }

        @Override
        public String wikify(String line, StringBuffer toAppendTo) {
            String result = WikiFormat.escapeHtml(line);
            result = this.escapeNonAllowedHtmlTags(result);
            return result;
        }

        private String escapeNonAllowedHtmlTags(String line) {
            Matcher m = ESCAPE_HTML_PATTERN.matcher(line);
            StringBuffer buffer = new StringBuffer((int)((double)line.length() * 1.1));
            while (m.find()) {
                String slash = m.group(1);
                String tag = m.group(2);
                String attrs = m.group(3);
                String replacement = m.group(0);
                replacement = !this.allowedTags.contains(tag.toLowerCase()) ? "&lt;" + slash + tag + attrs + "&gt;" : replacement.replaceAll("&quot;", "\"");
                m.appendReplacement(buffer, replacement);
            }
            m.appendTail(buffer);
            line = buffer.toString();
            return line;
        }

        @Override
        public int getPriority() {
            return 1;
        }
    }

    public static class ListWikifier
    extends DefaultWikifier {
        private static Pattern pattern = Pattern.compile("^([*#]+)\\s*(.*)$");
        Stack stack = new Stack();

        @Override
        public void cleanup(StringBuffer toAppendTo) {
            if (this.stack.isEmpty()) {
                return;
            }
            while (!this.stack.isEmpty()) {
                this.closeList(toAppendTo);
            }
        }

        @Override
        public int getPriority() {
            return 5;
        }

        @Override
        public String wikify(String line, StringBuffer toAppendTo) {
            Matcher m = pattern.matcher(line);
            int currentDepth = this.stack.size();
            int newDepth = 0;
            if (m.matches()) {
                newDepth = m.group(1).length();
                line = m.group(2);
            }
            if (newDepth < currentDepth) {
                for (int closures = currentDepth - newDepth; closures > 0; --closures) {
                    this.closeList(toAppendTo);
                }
                if (newDepth > 0) {
                    line = "<li>" + line;
                }
            } else if (newDepth > currentDepth) {
                String listType = m.group(1).charAt(0) == '#' ? "ol" : "ul";
                this.stack.push(listType);
                line = "<" + listType + "><li>" + line;
            } else if (currentDepth > 0) {
                toAppendTo.append("</li>");
                line = "<li>" + line;
            }
            return line;
        }

        private void closeList(StringBuffer toAppendTo) {
            toAppendTo.append("</li></").append(this.stack.pop()).append(">");
        }
    }

    public static class ParagraphWikifier
    extends DefaultWikifier {
        private int mode = 0;
        protected static final int PRIORITY = 10;

        @Override
        public int getPriority() {
            return 10;
        }

        @Override
        public void cleanup(StringBuffer toAppendTo) {
            if (this.mode == 1) {
                toAppendTo.append("</p>");
                this.mode = 0;
            }
        }

        @Override
        public String wikify(String line, StringBuffer toAppendTo) {
            switch (this.mode) {
                case 0: {
                    if (line.length() <= 0 || line.charAt(0) == '<') break;
                    line = "<p>" + line;
                    this.mode = 1;
                    break;
                }
                case 1: {
                    if (line.length() != 0 && line.charAt(0) != '<') break;
                    toAppendTo.append("</p>");
                    this.mode = 0;
                }
            }
            return line;
        }
    }

    public static class HorizontalRuleWikifier
    extends DefaultWikifier {
        private static Pattern pattern = Pattern.compile("-----+");

        @Override
        public String wikify(String line, StringBuffer toAppendTo) {
            if (pattern.matcher(line).matches()) {
                toAppendTo.append("<hr></hr>");
                return "";
            }
            return line;
        }

        @Override
        public int getPriority() {
            return 9;
        }
    }

    public static class HeadingWikifier
    extends DefaultWikifier {
        private static Pattern headingMatch = Pattern.compile("^(=+)\\s*(.*[^=])\\s*=+$");
        private TOCEntry currentTocEntry;
        private boolean generateTOC;

        public HeadingWikifier(boolean generateTOC) {
            this.generateTOC = generateTOC;
        }

        @Override
        public int getPriority() {
            return 9;
        }

        @Override
        public String wikify(String line, StringBuffer toAppendTo) {
            Matcher m = headingMatch.matcher(line);
            if (m.matches()) {
                int headingType = Math.min(m.group(1).length(), 6);
                String headingText = m.group(2);
                this.currentTocEntry = this.currentTocEntry.createRelatedEntry(headingType, headingText);
                line = "<h" + headingType + " id=\"" + headingText.replaceAll("\\W", "") + "\">" + headingText + "</h" + headingType + ">" + (this.generateTOC ? "<a name=\"section" + this.currentTocEntry.id + "\"></a>" : "");
            }
            return line;
        }

        @Override
        public void cleanup(StringBuffer toAppendTo) {
            if (this.generateTOC && this.currentTocEntry != null) {
                while (this.currentTocEntry.parent != null) {
                    this.currentTocEntry = this.currentTocEntry.parent;
                }
                if (TOCEntry.nextId > 1) {
                    StringBuffer tocContents = new StringBuffer();
                    tocContents.append("\n\n<div class=\"toc\"><h3>Contents</h3>\n");
                    this.currentTocEntry.appendToBuffer(tocContents);
                    tocContents.append("</div>\n\n");
                    int insertIndex = toAppendTo.indexOf("<h");
                    if (insertIndex == -1) {
                        insertIndex = 0;
                    }
                    toAppendTo.insert(insertIndex, tocContents.toString());
                }
                TOCEntry.nextId = 0;
            }
            this.currentTocEntry = new TOCEntry(null, null, true);
        }

        public static class TOCEntry {
            private static int nextId;
            private int depth;
            private int id;
            private TOCEntry parent;
            private String text;
            private List children = new LinkedList();
            private boolean filler;

            public TOCEntry(TOCEntry parent, String headingText, boolean isFiller) {
                this.parent = parent;
                if (parent == null) {
                    this.depth = 0;
                } else {
                    this.depth = parent.depth + 1;
                    parent.children.add(this);
                }
                this.text = headingText;
                this.filler = isFiller;
                this.id = nextId++;
                if (!isFiller) {
                    // empty if block
                }
            }

            public void appendToBuffer(StringBuffer toAppendTo) {
                boolean visible;
                boolean bl = visible = this.parent != null && (!this.filler || this.parent.children.size() > 1);
                if (visible) {
                    toAppendTo.append("<li><a href=\"#section").append(this.id).append("\">").append(this.text).append("</a>");
                }
                if (!this.children.isEmpty()) {
                    if (visible || this.parent == null) {
                        toAppendTo.append("<ol>");
                    }
                    for (TOCEntry eachEntry : this.children) {
                        eachEntry.appendToBuffer(toAppendTo);
                    }
                    if (visible || this.parent == null) {
                        toAppendTo.append("</ol>");
                    }
                }
                if (visible) {
                    toAppendTo.append("</li>");
                }
            }

            public TOCEntry createRelatedEntry(int depth, String headingText) {
                TOCEntry parentToAddTo = this;
                while (parentToAddTo.depth < depth - 1) {
                    parentToAddTo = new TOCEntry(parentToAddTo, headingText, true);
                }
                while (parentToAddTo.depth > depth - 1) {
                    parentToAddTo = parentToAddTo.parent;
                }
                return new TOCEntry(parentToAddTo, headingText, false);
            }

            public String toString() {
                return "" + this.depth + "/" + this.id + ": " + this.text;
            }
        }
    }

    public static class PatternWikifier
    extends DefaultWikifier {
        private String startTemplate;
        private String endTemplate;
        private String startTag;
        private String endTag;

        public PatternWikifier(String startTemplate, String endTemplate, String startTag, String endTag) {
            this.startTemplate = startTemplate;
            this.endTemplate = endTemplate;
            this.startTag = startTag;
            this.endTag = endTag;
        }

        @Override
        public String wikify(String line, StringBuffer toAppendTo) {
            return this._wikifyFromIndex(line, 0);
        }

        private String _wikifyFromIndex(String line, int fromIndex) {
            int endIndex;
            int startIndex = line.indexOf(this.startTemplate, fromIndex);
            if (startIndex != -1 && (endIndex = line.indexOf(this.endTemplate, startIndex + this.startTemplate.length())) != -1) {
                return line.substring(fromIndex, startIndex) + this.startTag + line.substring(startIndex + this.startTemplate.length(), endIndex) + this.endTag + this._wikifyFromIndex(line, endIndex + this.endTemplate.length());
            }
            return fromIndex == 0 ? line : line.substring(fromIndex);
        }

        @Override
        public int getPriority() {
            return 15;
        }
    }

    private static abstract class DefaultWikifier
    implements Wikifier {
        private DefaultWikifier() {
        }

        @Override
        public void cleanup(StringBuffer toAppendTo) {
        }

        public int compareTo(Object o) {
            return this.getPriority() - ((Wikifier)o).getPriority();
        }
    }
}

