/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.StringTokenizer;

public class SecondsDurationFormatter
extends Format {
    public boolean showSeconds = true;

    public SecondsDurationFormatter() {
    }

    public SecondsDurationFormatter(boolean showSeconds) {
        this.showSeconds = showSeconds;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null) {
            return toAppendTo;
        }
        if (!(obj instanceof Number)) {
            throw new IllegalArgumentException("obj is not of the correct type: " + obj.toString());
        }
        int rawTime = ((Number)obj).intValue();
        if (rawTime < 0) {
            toAppendTo.append('-');
            rawTime = Math.abs(rawTime);
        }
        long seconds = rawTime % 60;
        long minutes = rawTime / 60 % 60;
        long hours = rawTime / 3600;
        toAppendTo.append(hours);
        toAppendTo.append(':');
        if (minutes < 10L) {
            toAppendTo.append('0');
        }
        toAppendTo.append(minutes);
        if (this.showSeconds) {
            toAppendTo.append(':');
            if (seconds < 10L) {
                toAppendTo.append('0');
            }
            toAppendTo.append(seconds);
        }
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Object result = this.parseObject(source, pos);
        if (pos.getErrorIndex() != -1) {
            throw new ParseException("Unparseable duration: \"" + source + "\"", pos.getErrorIndex());
        }
        return result;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        if (source == null || source.length() == 0) {
            return new Integer(0);
        }
        int total = 0;
        int multiplier = 3600;
        int sign = 1;
        if (source.substring(0, 1).equals("-")) {
            sign = -1;
            source = source.substring(1);
        }
        try {
            StringTokenizer tk = new StringTokenizer(source, ":");
            while (tk.hasMoreTokens()) {
                String curToken = tk.nextToken();
                total += Integer.parseInt(curToken) * multiplier;
                multiplier /= 60;
            }
        }
        catch (NumberFormatException ex) {
            pos.setErrorIndex(String.valueOf(total).length());
            return null;
        }
        return new Integer(total * sign);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: SecondsDurationFormatter hh:mm:ss");
        } else {
            try {
                System.out.println("- Converting " + args[0] + " to Integer:");
                SecondsDurationFormatter format = new SecondsDurationFormatter();
                Integer timestamp = (Integer)format.parseObject(args[0]);
                System.out.println(timestamp);
                System.out.println("Converting back to String");
                String result = format.format(timestamp);
                System.out.println(result);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }
}

