/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GlobalCurrencyFormat
extends Format {
    private Currency currency;
    private Locale locale;
    private static Map map;
    private static List locales;
    private NumberFormat embeddedFormat;

    public GlobalCurrencyFormat(Currency currency, Locale locale) {
        this.currency = currency;
        this.locale = locale;
        if (locale == null) {
            DecimalFormat newFormat = new DecimalFormat();
            newFormat.setMaximumFractionDigits(currency.getDefaultFractionDigits());
            newFormat.setPositivePrefix(currency.getSymbol());
            newFormat.setNegativePrefix(currency.getSymbol() + " -");
        } else {
            this.embeddedFormat = NumberFormat.getCurrencyInstance(locale);
        }
    }

    public GlobalCurrencyFormat(Currency currency) {
        this(currency, (Locale)map.get(currency));
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        return this.embeddedFormat.format(obj, toAppendTo, pos);
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return this.embeddedFormat.parseObject(source, pos);
    }

    static {
        locales = Arrays.asList(NumberFormat.getAvailableLocales());
        map = new HashMap(locales.size());
        for (Locale eachLocale : locales) {
            try {
                if (eachLocale.getCountry().length() != 2) continue;
                Currency eachCurrency = Currency.getInstance(eachLocale);
                map.put(eachCurrency, eachLocale);
            }
            catch (Exception e) {
                System.out.println("Got an error trying to get a currency for locale: " + eachLocale);
                e.printStackTrace();
            }
        }
    }
}

