/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

import java.math.BigDecimal;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ByteLengthFormat
extends Format {
    public static final String BYTES = "bytes";
    public static final String KILOBYTES = "KB";
    public static final String MEGABYTES = "MB";
    public static final String GIGABYTES = "GB";
    public static final String TERABYTES = "TB";
    private static final String[] UNIT_ARRAY = new String[]{"KB", "MB", "GB", "TB"};
    private BigDecimal K = new BigDecimal(1024);
    private static final ByteLengthFormat instance = new ByteLengthFormat(new BigDecimal(999), new BigDecimal(50));
    private final BigDecimal largestAllowedNumber;
    private final BigDecimal smallestIntegerNumber;
    private static final BigDecimal DEFAULT_LARGEST = new BigDecimal("999");
    private static final BigDecimal DEFAULT_SMALLEST = new BigDecimal("50");

    public ByteLengthFormat() {
        this(DEFAULT_LARGEST, DEFAULT_SMALLEST);
    }

    public ByteLengthFormat(BigDecimal largestAllowedNumber, BigDecimal smallestIntegerNumber) {
        if (largestAllowedNumber == null) {
            throw new NullPointerException("largestAllowedNumber must not be null.");
        }
        if (smallestIntegerNumber == null) {
            throw new NullPointerException("smallestIntegerNumber must not be null.");
        }
        this.largestAllowedNumber = largestAllowedNumber;
        this.smallestIntegerNumber = smallestIntegerNumber;
    }

    public static ByteLengthFormat getInstance() {
        return instance;
    }

    public BigDecimal getLargestAllowedNumber() {
        return this.largestAllowedNumber;
    }

    public BigDecimal getSmallestIntegerNumber() {
        return this.smallestIntegerNumber;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null) {
            return toAppendTo;
        }
        long bytes = ((Number)obj).longValue();
        String unit = BYTES;
        BigDecimal size = new BigDecimal(bytes);
        size = size.setScale(2, 4);
        for (int i = 0; i < UNIT_ARRAY.length && size.compareTo(this.largestAllowedNumber) > 0; ++i) {
            size = size.divide(this.K, 4);
            unit = UNIT_ARRAY[i];
        }
        size = this.scaledSize(size);
        toAppendTo.append(size).append(" ").append(unit);
        return toAppendTo;
    }

    private BigDecimal scaledSize(BigDecimal size) {
        size = size.compareTo(this.smallestIntegerNumber) > 0 ? size.setScale(0, 4) : size.setScale(1, 4);
        return size;
    }

    public void setKilobyteSize(BigDecimal k) {
        this.K = k;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        if (source == null) {
            return null;
        }
        Pattern p = Pattern.compile("^([1-9][0-9.]*)\\s*([a-z]*)$", 2);
        Matcher matcher = p.matcher(source);
        if (matcher.find()) {
            String unit = matcher.group(2);
            BigDecimal number = new BigDecimal(matcher.group(1));
            if (unit != null && !unit.equalsIgnoreCase(BYTES) && !unit.equalsIgnoreCase("b")) {
                if (unit.equalsIgnoreCase(KILOBYTES) || unit.equalsIgnoreCase("kb")) {
                    number = number.multiply(this.K);
                } else if (unit.equalsIgnoreCase(MEGABYTES) || unit.equalsIgnoreCase("m")) {
                    number = number.multiply(this.K).multiply(this.K);
                } else if (unit.equalsIgnoreCase(GIGABYTES) || unit.equalsIgnoreCase("g")) {
                    number = number.multiply(this.K).multiply(this.K).multiply(this.K);
                } else if (unit.equalsIgnoreCase(TERABYTES) || unit.equalsIgnoreCase("t")) {
                    number = number.multiply(this.K).multiply(this.K).multiply(this.K).multiply(this.K);
                } else {
                    throw new IllegalArgumentException("Unkown unit: " + unit);
                }
            }
            return new Long(number.longValue());
        }
        throw new IllegalArgumentException("Invalid byte length: " + source);
    }
}

