/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmplugin;

import com.prosc.fmkit.PluginBridge;
import com.prosc.fmplugin.ChartModelInterface;
import java.awt.Color;
import java.awt.Paint;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.TextTitle;

public class ChartModelUtils {
    public static Properties propertiesForAdditionalParams(String additionalParams) throws IOException {
        Properties p = new Properties();
        if (additionalParams != null && additionalParams.length() > 0) {
            p.load(new ByteArrayInputStream(additionalParams.getBytes()));
        }
        return p;
    }

    public static Color createColor(int red, int green, int blue, int alpha) {
        Color c;
        PluginBridge.initAwt();
        try {
            c = new Color(red, green, blue, alpha);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("All color values must be between 0 and 255.");
        }
        return c;
    }

    public static void applyCommonParams(Properties p, ChartModelInterface model) {
        JFreeChart chart = model.getChart();
        String param = p.getProperty("backgroundColor", "255,255,255");
        if (param != null) {
            chart.setBackgroundPaint(ChartModelUtils.parsePaint(param));
        }
        if ((param = p.getProperty("subtitle")) != null) {
            chart.addSubtitle(new TextTitle(param));
        }
        Plot plot = chart.getPlot();
        param = p.getProperty("plotBackgroundColor");
        if (param != null) {
            plot.setBackgroundPaint(ChartModelUtils.parsePaint(param));
        }
        if ((param = p.getProperty("noDataMessage")) != null) {
            plot.setNoDataMessage(param);
        }
        if ((param = p.getProperty("outlineColor")) != null) {
            plot.setOutlinePaint(ChartModelUtils.parsePaint(param));
        }
        ValueAxis rangeAxis = null;
        if (plot instanceof CategoryPlot) {
            CategoryPlot catPlot = (CategoryPlot)plot;
            rangeAxis = catPlot.getRangeAxis();
        } else if (plot instanceof XYPlot) {
            rangeAxis = ((XYPlot)plot).getRangeAxis();
        }
        if (rangeAxis != null) {
            param = p.getProperty("valueaxis.min");
            if (param != null) {
                rangeAxis.setAutoRange(false);
                rangeAxis.setLowerBound(Double.parseDouble(param));
            }
            if ((param = p.getProperty("valueaxis.max")) != null) {
                rangeAxis.setAutoRange(false);
                rangeAxis.setUpperBound(Double.parseDouble(param));
            }
            if ((param = p.getProperty("valueaxis.showticklabels")) != null) {
                boolean flag = Boolean.valueOf(param);
                rangeAxis.setTickLabelsVisible(flag);
            }
            if ((param = p.getProperty("valueaxis.showtickmarks")) != null) {
                boolean flag = Boolean.valueOf(param);
                rangeAxis.setTickMarksVisible(flag);
            }
        }
        if ((param = p.getProperty("legend")) != null && !ChartModelUtils.boolForParam(param)) {
            chart.removeLegend();
        }
        if ((param = p.getProperty("outline")) != null && !ChartModelUtils.boolForParam(param)) {
            chart.getPlot().setOutlineVisible(false);
        }
    }

    private static float[] parseDash(String property) {
        String[] parts = property.split("\\s*,\\s*");
        float[] dash = new float[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String eachPart = parts[i];
            dash[i] = Float.parseFloat(eachPart);
        }
        return dash;
    }

    private static Paint parsePaint(String param) {
        if (param == null || param.length() == 0) {
            return null;
        }
        String[] rgba = param.split("\\s*,\\s*");
        if (rgba.length < 3) {
            return Color.decode(param);
        }
        int r = Integer.parseInt(rgba[0]);
        int g = Integer.parseInt(rgba[1]);
        int b = Integer.parseInt(rgba[2]);
        int a = rgba.length > 3 ? Integer.parseInt(rgba[3]) : 255;
        return new Color(r, g, b, a);
    }

    public static boolean boolForParam(String param) {
        return "1".equals(param) || "true".equals(param);
    }
}

