/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmplugin;

import com.prosc.fmplugin.ChartModelInterface;
import com.prosc.fmplugin.ChartModelUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Properties;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public class BarChartModel
implements ChartModelInterface {
    private DefaultCategoryDataset barDataSet = new DefaultCategoryDataset();
    private JFreeChart barChart;

    public BarChartModel(String name, String categoryAxisLabel, String valueAxisLabel, boolean vertical, boolean use3d) {
        PlotOrientation orientation = vertical ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL;
        this.barChart = use3d ? ChartFactory.createBarChart3D(name, categoryAxisLabel, valueAxisLabel, this.barDataSet, orientation, true, false, false) : ChartFactory.createBarChart(name, categoryAxisLabel, valueAxisLabel, this.barDataSet, orientation, true, false, false);
    }

    @Override
    public void setValue(double value, String rowOrSeries, Comparable columnOrCategory) {
        this.barDataSet.setValue(value, (Comparable)((Object)rowOrSeries), columnOrCategory);
    }

    @Override
    public void setSeriesColor(String category, int red, int green, int blue, int alpha) {
        int seriesIndex = this.barDataSet.getRowKeys().indexOf(category);
        if (seriesIndex < 0) {
            throw new IllegalStateException("Unknown category '" + category + "'.  You should call chartSetColor AFTER adding values to the chart.");
        }
        CategoryPlot plot = this.barChart.getCategoryPlot();
        Color c = ChartModelUtils.createColor(red, green, blue, alpha);
        plot.getRenderer().setSeriesPaint(seriesIndex, c);
        plot.getRenderer().setSeriesOutlinePaint(seriesIndex, c.darker());
    }

    @Override
    public JFreeChart getChart() {
        return this.barChart;
    }

    @Override
    public BufferedImage getFinishedChart(int width, int height, Properties additionalParams) throws IOException {
        this.applyAdditionalParams(additionalParams);
        return this.barChart.createBufferedImage(width, height);
    }

    private void applyAdditionalParams(Properties p) {
        ChartModelUtils.applyCommonParams(p, this);
        CategoryPlot plot = this.barChart.getCategoryPlot();
        String param = p.getProperty("strokeWidth");
        if (param != null) {
            plot.setOutlineStroke(new BasicStroke(Float.parseFloat(param), 0, 0));
        }
        if ((param = p.getProperty("outlines")) != null) {
            // empty if block
        }
    }
}

