/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FMCharacterStyle {
    public static final int Face_Plain = 0;
    public static final int Face_Bold = 256;
    public static final int Face_Italic = 512;
    public static final int Face_Underline = 1024;
    public static final int Face_Outline = 2048;
    public static final int Face_Shadow = 4096;
    public static final int Face_Condense = 8192;
    public static final int Face_Extend = 16384;
    public static final int Face_Strikethrough = 1;
    public static final int Face_SmallCaps = 2;
    public static final int Face_Superscript = 4;
    public static final int Face_Subscript = 8;
    public static final int Face_Uppercase = 16;
    public static final int Face_Lowercase = 32;
    public static final int Face_Titlecase = 48;
    public static final int Face_WordUnderline = 64;
    public static final int Face_DoubleUnderline = 128;
    public static final int Face_AllStyles = Short.MAX_VALUE;
    private static HashMap<String, Integer> textStylesByName = new HashMap();
    private int face;
    private int fontID;
    private int fontSize;
    private int red;
    private int green;
    private int blue;
    private int alpha;
    long cToken;
    private static final Logger log;

    public FMCharacterStyle() {
        this.cToken = this._createCharacterStyle();
    }

    public FMCharacterStyle(int fontID, int face, int fontSize) {
        this();
        this.setFontID(fontID);
        this.setFace(face);
        this.setFontSize(fontSize);
    }

    public FMCharacterStyle(long cToken) {
        this.cToken = cToken;
    }

    private native long _createCharacterStyle();

    public void setFace(int face) {
        this.face = face;
        this.jni_setface(this.cToken, face);
    }

    public void setFaces(String styles) {
        if (styles == null) {
            styles = "";
        }
        this.setFace(this.parseStyles(styles));
    }

    public void setSize(int fontSize) {
        this.fontSize = fontSize;
        this.jni_setFontSize(this.cToken, fontSize);
    }

    private native void jni_setface(long var1, int var3);

    public void setFontID(int fontID) {
        this.fontID = fontID;
        this.jni_setFontID(this.cToken, fontID);
    }

    private native void jni_setFontID(long var1, int var3);

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.jni_setFontSize(this.cToken, fontSize);
    }

    private native void jni_setFontSize(long var1, int var3);

    public void setColor(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.jni_setColor(this.cToken, red, green, blue, alpha);
    }

    private native void jni_setColor(long var1, int var3, int var4, int var5, int var6);

    public int getFace() {
        return this.jni_getFace(this.cToken);
    }

    private native int jni_getFontID(long var1);

    public int getFontID() {
        return this.jni_getFontID(this.cToken);
    }

    private native int jni_getFace(long var1);

    public int getFontSize() {
        return this.jni_getFontSize(this.cToken);
    }

    private native int jni_getFontSize(long var1);

    private int parseStyles(String styles_str) {
        int styles = 0;
        if (styles_str != null && styles_str.length() > 0) {
            String[] styleList;
            for (String aStyleList : styleList = styles_str.split("[\\+ ]+")) {
                Integer keyValue = textStylesByName.get(aStyleList.toLowerCase());
                try {
                    if (keyValue == null) {
                        styles += Integer.valueOf(aStyleList).intValue();
                        continue;
                    }
                    styles += keyValue.intValue();
                }
                catch (NumberFormatException nfe) {
                    log.log(Level.WARNING, "Invalid style: " + aStyleList);
                }
            }
        }
        return styles;
    }

    public String toString() {
        return "FMCharacterStyle{face=" + this.getFace() + ", fontID=" + this.getFontID() + ", fontSize=" + this.getFontSize() + ", red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + ", cToken=" + this.cToken + '}';
    }

    static {
        textStylesByName.put("plain", 0);
        textStylesByName.put("strikethrough", 1);
        textStylesByName.put("smallcaps", 2);
        textStylesByName.put("superscript", 4);
        textStylesByName.put("subscript", 8);
        textStylesByName.put("uppercase", 16);
        textStylesByName.put("lowercase", 32);
        textStylesByName.put("titlecase", 48);
        textStylesByName.put("wordunderline", 64);
        textStylesByName.put("doubleunderline", 128);
        textStylesByName.put("bold", 256);
        textStylesByName.put("italic", 512);
        textStylesByName.put("underline", 1024);
        textStylesByName.put("condense", 8192);
        textStylesByName.put("extend", 16384);
        textStylesByName.put("outline", 2048);
        textStylesByName.put("shadow", 4096);
        textStylesByName.put("highlight", 4096);
        log = Logger.getLogger(FMCharacterStyle.class.getName());
    }
}

