/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.Platform;
import com.prosc.fmkit.Configurable;
import com.prosc.fmkit.FMException;
import com.prosc.fmkit.FMFunction;
import com.prosc.fmkit.FileMakerOperation;
import com.prosc.fmkit.IdleHandler;
import com.prosc.fmkit.InvalidClipboardException;
import com.prosc.fmkit.MethodScanner;
import com.prosc.fmkit.NativeLibraries;
import com.prosc.fmkit.Plugin;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.PluginUtils;
import com.prosc.fmkit.StaticFunction;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMType;
import com.prosc.infrastructure.ClassUtils;
import com.prosc.infrastructure.LogUtils;
import com.prosc.io.IOUtils;
import com.prosc.laf.WindowsFontPatch;
import com.prosc.license.client.ExpiredLicenseException;
import com.prosc.shared.StringUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.EmptyStackException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sun.awt.EmbeddedFrame;
import sun.misc.SharedSecrets;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveCache;

public class PluginBridge {
    public static final short FM_PRO = 0;
    public static final short FM_DEVELOPER = 1;
    public static final short FM_RUNTIME = 2;
    public static final short FM_SERVER = 3;
    public static final short FM_WEB = 4;
    public static final short FM_MOBILE = 5;
    public static final short FM_SERVER12 = 7;
    public static final short FM_WEB12 = 8;
    public static final short IDLESTATE_IDLE = 0;
    public static final short IDLESTATE_NOTIDLE = 1;
    public static final short IDLESTATE_SCRIPT_PAUSED = 2;
    public static final short IDLESTATE_SCRIPT_RUNNING = 3;
    public static final short IDLESTATE_UNSAFE = 4;
    public static final short SCRIPT_HALT = 0;
    public static final short SCRIPT_EXIT = 1;
    public static final short SCRIPT_RESUME = 2;
    public static final short SCRIPT_PAUSE = 3;
    public static final short VERSION_40 = 11;
    public static final short VERSION_41 = 12;
    public static final short VERSION_50 = 14;
    public static final short VERSION_60 = 17;
    public static final short VERSION_70 = 50;
    public static final short VERSION_80 = 51;
    public static final short VERSION_11 = 52;
    public static final short VERSION_12 = 53;
    public static final short VERSION_13 = 54;
    public static final short BAD_VERSION = -1;
    public static final short DO_NOT_ENABLE = -2;
    public static final short VERSION_MIN = 4;
    public static final short VERSION_MAX = 255;
    private static final Logger log = Logger.getLogger(PluginBridge.class.getName());
    private static final Level DEFAULT_LOG_LEVEL = Level.CONFIG;
    private static final String CR = System.getProperty("line.separator");
    private static PluginBridge sharedInstance;
    private static boolean isMac;
    private static boolean isAwtInitialized;
    private static boolean version8Loaded;
    private static boolean version11Loaded;
    private static short applicationType;
    private static short apiVersion;
    private static short majorVersion;
    private static int callCounter;
    private static long frontWindowRef;
    private static long instanceID;
    private static AtomicInteger eventLoopDepth;
    private static String pluginClassName;
    private static String bundlePath;
    private static File logFile;
    private static File version8lib;
    private static File version11lib;
    private static File pluginFile;
    private static File pluginJar;
    private static boolean pluginJarDeletable;
    private static JarFile pluginJarFile;
    private static EmbeddedFrame embeddedFrame;
    private static Thread initThread;
    private Thread mainThread = null;
    private final PluginInfoForThread firstPluginInfo;
    private final ThreadLocal<WeakReference<PluginInfoForThread>> pluginInstanceForThread;
    private List<PluginFunction> functionsToRegister;
    private Map<Short, PluginFunction> functionIDMap;
    private boolean isInShutdown = false;
    private boolean didInstallSecurityManager;
    private Map<Long, PluginInfoForThread> mapOfPluginInfoForThread = new HashMap<Long, PluginInfoForThread>();
    private static Map<Long, EmbeddedFrame> rootFrames;
    private EnumMap<ClipboardType, String> clipboardFormatMap;

    private PluginBridge(final Class<? extends Plugin> thePluginClass) {
        try {
            this.didInstallSecurityManager = false;
            log.info("No changes will be made to SecurityManager");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.functionsToRegister = new LinkedList<PluginFunction>();
        this.functionIDMap = new HashMap<Short, PluginFunction>();
        this.firstPluginInfo = this.createPluginInfo(thePluginClass);
        if (this.isClient()) {
            this.firstPluginInfo.thePlugin.init(this);
            this.pluginInstanceForThread = null;
        } else {
            this.pluginInstanceForThread = new ThreadLocal<WeakReference<PluginInfoForThread>>(){

                @Override
                protected WeakReference<PluginInfoForThread> initialValue() {
                    PluginInfoForThread result = PluginBridge.this.createPluginInfo(thePluginClass);
                    result.thePlugin.init(sharedInstance);
                    return new WeakReference<PluginInfoForThread>(result);
                }
            };
        }
    }

    private boolean isClient() {
        return applicationType == 0 || applicationType == 1 || applicationType == 2 || applicationType == 5;
    }

    private PluginInfoForThread createPluginInfo(Class<? extends Plugin> thePluginClass) {
        PluginInfoForThread result = new PluginInfoForThread();
        try {
            result.thePlugin = thePluginClass.newInstance();
            result.thePlugin.setApplicationType(applicationType);
            result.thePlugin.setPluginBridge(this);
            result.currentContextStack = new ArrayDeque<PluginContext>();
            result.operationQueue = new LinkedList();
            result.lastErrorComplainedAbout = null;
            result.lastOperationStackTrace = null;
            result.isErrorVisible = false;
            result.nativeThreadID = PluginBridge._getCurrentThreadId();
            this.mapOfPluginInfoForThread.put(result.nativeThreadID, result);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.toString(), e);
            throw new RuntimeException("Could not instantiate plugin: " + e, e);
        }
        return result;
    }

    public void detachNativeThread(long threadId) {
        Plugin thePlugin = this.mapOfPluginInfoForThread.get((Object)Long.valueOf((long)threadId)).thePlugin;
        thePlugin.shutdown();
        this.mapOfPluginInfoForThread.remove(threadId);
    }

    public static PluginBridge sharedInstance(String bundlePathString, String bridgeVersion, short applicationType, String logpath) {
        if (sharedInstance == null) {
            File bundleFile;
            PluginBridge.applicationType = applicationType;
            bundlePath = bundlePathString;
            PluginBridge.initLogging(logpath, applicationType);
            String pathToJarFile = bundlePathString;
            int semicolonIndex = bundlePathString.indexOf(";");
            if (semicolonIndex > 0) {
                pathToJarFile = bundlePathString.substring(semicolonIndex + 1);
                bundlePathString = bundlePathString.substring(0, semicolonIndex);
            }
            if (!(bundleFile = new File(bundlePathString)).exists()) {
                throw new IllegalArgumentException("bundle path does not exist: " + bundleFile.getAbsolutePath());
            }
            try {
                if (bundleFile.isDirectory() && bundleFile.getName().equalsIgnoreCase("Resources")) {
                    PluginBridge.initMac(bundleFile);
                } else if (bundleFile.getName().endsWith(".fmx") || bundleFile.getName().endsWith(".fmx64")) {
                    PluginBridge.initWindows(bundleFile, pathToJarFile);
                } else {
                    String msg = "Unknown bundlePath format '" + bundlePath + "' -- should end in '.fmx' or 'Resources'.";
                    log.log(Level.SEVERE, msg);
                    throw new IllegalArgumentException(msg);
                }
                log.log(Level.FINE, "PluginBridge loaded successfully with bridgeVersion " + bridgeVersion);
            }
            catch (ClassNotFoundException e) {
                String msg = "Unable to locate current directory context, or could not load plugin class: " + e.getMessage();
                log.log(Level.SEVERE, msg, e);
                throw new RuntimeException(msg, e);
            }
            catch (Error e) {
                log.log(Level.SEVERE, e.toString(), e);
                throw e;
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, e.toString(), e);
                throw e;
            }
        }
        if (sharedInstance == null) {
            log.log(Level.SEVERE, "PluginBridge initialization failed");
        }
        return sharedInstance;
    }

    private static void initMac(File bundlePath) throws ClassNotFoundException {
        URL[] urLs;
        pluginFile = bundlePath.getParentFile().getParentFile();
        log.log(Level.FINE, "Initializing MAC plugin");
        pluginJar = new File(bundlePath, "Contents/Resources/Java/plugin.jar");
        for (URL url : urLs = ((URLClassLoader)PluginBridge.class.getClassLoader()).getURLs()) {
            if (!url.getPath().endsWith("plugin.jar")) continue;
            try {
                pluginJar = new File(url.toURI());
                pluginJarDeletable = !pluginJar.getAbsolutePath().contains(bundlePath.getAbsolutePath());
                break;
            }
            catch (URISyntaxException e) {
                log.log(Level.WARNING, "Unable to get plugin jar from classloader", e);
            }
        }
        version8lib = new File(bundlePath.getParentFile(), "MacOS/version8lib.jnilib");
        version11lib = new File(bundlePath.getParentFile(), "MacOS/version11lib.jnilib");
        File jniLib = new File(bundlePath.getParentFile(), "MacOS/JaCK3");
        String libPath = jniLib.getAbsolutePath();
        log.log(Level.CONFIG, "Loading dynamic library at {0}", libPath);
        if (!jniLib.exists()) {
            throw new RuntimeException("jnilib file does not exist at path: " + libPath);
        }
        System.load(libPath);
        log.log(Level.CONFIG, "Loading plugin jar at {0}", pluginJar.getAbsolutePath());
        String className = PluginBridge.getPluginClassNameForPluginJar(pluginJar);
        Class<?> pluginClass = Class.forName(className);
        sharedInstance = new PluginBridge(pluginClass);
        pluginFile = bundlePath.getParentFile().getParentFile();
    }

    private static void initWindows(File bundlePath, String pathToJarFile) throws ClassNotFoundException {
        log.log(Level.FINE, "Initializing WIN plugin");
        pluginJar = new File(pathToJarFile);
        try {
            log.log(Level.CONFIG, "Copying jar file to temp directory");
            File tempPluginJar = File.createTempFile(pluginJar.getName().replace(".fmx", ""), ".fmx");
            IOUtils.copyFile(pluginJar, tempPluginJar);
            tempPluginJar.deleteOnExit();
            pluginJar = tempPluginJar;
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unable to create temporary plugin jar, will use original instead", e);
        }
        String sharedLibPath = bundlePath.getAbsolutePath();
        version8lib = null;
        version11lib = null;
        log.log(Level.CONFIG, "Loading dynamic library at {0}", sharedLibPath);
        System.load(sharedLibPath);
        log.log(Level.CONFIG, "Loading plugin jar at {0}", pluginJar.getAbsolutePath());
        String className = PluginBridge.getPluginClassNameForPluginJar(pluginJar);
        Class<?> pluginClass = Class.forName(className);
        sharedInstance = new PluginBridge(pluginClass);
        pluginFile = bundlePath;
    }

    public static File getPluginFile() {
        return pluginFile;
    }

    public static File getPluginJar() {
        return pluginJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPluginClassNameForPluginJar(File pluginFile) {
        if (pluginClassName == null) {
            try {
                log.log(Level.FINE, "Reading Manifest file to determine plugin className");
                JarFile pluginJarFile = new JarFile(pluginFile, true);
                try {
                    Manifest manifest = pluginJarFile.getManifest();
                    pluginClassName = manifest.getMainAttributes().getValue("pluginClassName");
                    if (pluginClassName == null) {
                        pluginClassName = manifest.getMainAttributes().getValue("main-class");
                    }
                }
                finally {
                    pluginJarFile.close();
                }
            }
            catch (IOException e) {
                String message = "Unable to parse manifest data from " + pluginFile;
                log.severe(message);
                throw new RuntimeException(message, e);
            }
        }
        log.log(Level.CONFIG, "Loading Plugin class named {0}", pluginClassName);
        return pluginClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short fmxInit(short apiVersion, String versionString, long instanceID, boolean unsafeCalls, long cStartScript, long cCurrentEnv) {
        initThread = Thread.currentThread();
        log.fine("fmxInit(" + apiVersion + ", " + applicationType + ", " + versionString + ", " + instanceID + ", " + unsafeCalls + ", " + cStartScript + ", " + cCurrentEnv + ")");
        PluginBridge.apiVersion = apiVersion;
        PluginBridge.instanceID = instanceID;
        if (versionString == null) {
            majorVersion = (short)12;
        } else {
            String versionStringWithDecimals = versionString.replaceAll("[^0-9\\.]", "");
            majorVersion = Short.valueOf(versionStringWithDecimals.substring(0, versionStringWithDecimals.indexOf(".")));
        }
        if (apiVersion < 4) return -1;
        if (apiVersion > 255) {
            return -1;
        }
        if (apiVersion >= 51) {
            try {
                this.loadVersion8Lib();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Unable to load version8lib", e);
            }
        }
        if (apiVersion >= 52) {
            try {
                this.loadVersion11Lib();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Unable to load version11lib", e);
            }
        }
        try {
            if (this.mainThread == null) {
                this.mainThread = Thread.currentThread();
            }
            if (!PluginBridge.isHeadless() && !PluginUtils.isMac()) {
                try {
                    UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
                    new WindowsFontPatch().patch();
                }
                catch (UnsupportedLookAndFeelException e) {
                    log.warning("Windows Look and Feel is not installed");
                }
            }
            Plugin thePlugin = this.getThePlugin();
            log.info("Creating shared PluginBridge instance" + CR + LogUtils.getSystemInfo() + CR + ClassUtils.dumpAllClassPaths(this.getClass().getClassLoader()));
            log.config("Initialize " + thePlugin.getName());
            PluginContext pluginContext = new PluginContext(this, thePlugin, unsafeCalls, cStartScript, cCurrentEnv, 0L, Thread.currentThread(), null);
            try {
                this.pushContext(pluginContext);
                if (!thePlugin.isVersionCompatible(apiVersion, applicationType)) {
                    short s = -1;
                    return s;
                }
                this.scanFunctions(thePlugin);
                this.registerAllFunctions(thePlugin);
            }
            finally {
                this.popContext();
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, "Could not initialize plugin", e);
            throw e;
        }
        catch (Error e) {
            log.log(Level.SEVERE, "Could not initialize plugin", e);
            throw e;
        }
        log.config("Return api version: " + apiVersion);
        return apiVersion;
    }

    private void loadVersion8Lib() throws IOException {
        if (!isMac) {
            log.info("No need to load version8lib on Windows");
            version8Loaded = true;
        } else if (version8lib != null) {
            log.config("Loading the version 8 library from " + version8lib);
            try {
                System.load(version8lib.getAbsolutePath());
                version8Loaded = true;
                log.config("Version 8 lib was loaded successfully");
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable t) {
                IOException exception = new IOException("unable to load version8lib");
                exception.initCause(t);
                throw exception;
            }
        } else {
            log.config("version 8 lib is null, will not load");
        }
    }

    private void loadVersion11Lib() throws IOException {
        if (Platform.current == Platform.windows) {
            log.info("load version11Lib: false");
            version11Loaded = false;
        } else if (version11lib != null) {
            log.config("Loading the version 11 library from " + version11lib);
            try {
                System.load(version11lib.getAbsolutePath());
                version11Loaded = true;
                log.config("Version 11 lib was loaded successfully");
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable t) {
                IOException exception = new IOException("unable to load version11lib");
                exception.initCause(t);
                throw exception;
            }
        } else {
            log.config("version 11 lib is null, will not load");
        }
    }

    public static File getLogFile() {
        return logFile;
    }

    private static void initLogging(String logpath, short type) {
        File errAndOutLog = null;
        try {
            errAndOutLog = File.createTempFile("360out", ".log");
            System.setOut(new PrintStream(errAndOutLog));
            System.setErr(new PrintStream(errAndOutLog));
        }
        catch (IOException e) {
            log.log(Level.INFO, "Couldn't create stderr and stdout logs in Temp directory");
        }
        if (logpath == null) {
            try {
                logFile = File.createTempFile("360PluginLog", ".log");
            }
            catch (IOException e) {
                logFile = new File("/360PluginLog.log");
                log.log(Level.SEVERE, "Could not create a log file. logpath param is null. Will write to " + logFile, e);
            }
        } else {
            logFile = new File(logpath);
        }
        try {
            Logger proscLog = LogManager.getLogManager().getLogger("com.prosc");
            if (proscLog == null) {
                proscLog = Logger.getLogger("com.prosc");
                proscLog.setLevel(DEFAULT_LOG_LEVEL);
            }
            if (type == 4 || type == 8) {
                Logger currentLogger = Logger.getLogger("");
                do {
                    Handler[] handlers;
                    for (Handler handler : handlers = currentLogger.getHandlers()) {
                        if (!(handler instanceof ConsoleHandler)) continue;
                        currentLogger.removeHandler(handler);
                    }
                } while ((currentLogger = currentLogger.getParent()) != null);
            }
            if (!logFile.canWrite()) {
                log.log(Level.SEVERE, "Cannot write to provided log path: " + logFile);
            } else if ("true".equals(System.getProperty("com.prosc.logging.configured"))) {
                log.log(Level.CONFIG, "Logging is already configured; using the shared log handler");
            } else {
                FileHandler fmkitLogHandler = new FileHandler(logFile.getAbsolutePath(), true);
                fmkitLogHandler.setLevel(Level.ALL);
                fmkitLogHandler.setFormatter(new SimpleFormatter());
                Logger.getLogger("").addHandler(fmkitLogHandler);
                proscLog.log(DEFAULT_LOG_LEVEL, "Will write normal log file to " + logFile);
                proscLog.log(DEFAULT_LOG_LEVEL, "out/err logging to " + errAndOutLog);
                System.setProperty("com.prosc.logging.configured", "true");
            }
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Couldn't create fmkit log file.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fmxIdle(short idleState, boolean unsafeCalls, long cStartScript, long cCurrentEnv) {
        if (unsafeCalls) {
            return;
        }
        try {
            if (Thread.currentThread() != this.mainThread) {
                return;
            }
            Plugin thePlugin = this.getThePlugin();
            PluginContext context = new PluginContext(this, thePlugin, false, cStartScript, cCurrentEnv, 0L, Thread.currentThread(), null);
            try {
                this.pushContext(context);
                ((IdleHandler)((Object)thePlugin)).doIdle(idleState);
            }
            finally {
                this.popContext();
            }
        }
        catch (Exception t) {
            log.log(Level.SEVERE, "Uncaught exception in idle handler", t);
        }
    }

    public static void setPluginJarFile(JarFile pluginJarFile) {
        PluginBridge.pluginJarFile = pluginJarFile;
    }

    public void fmxShutdown(boolean unsafeCalls, long cStartScript, long cCurrentEnv) {
        try {
            float specVersion;
            this.isInShutdown = true;
            int listSize = this.mapOfPluginInfoForThread.size();
            ArrayList<PluginInfoForThread> listOfPluginInfoForThreadCopy = new ArrayList<PluginInfoForThread>(listSize);
            for (int i = 0; i < listSize; ++i) {
                listOfPluginInfoForThreadCopy.add(new PluginInfoForThread());
            }
            Collections.copy(listOfPluginInfoForThreadCopy, new ArrayList<PluginInfoForThread>(this.mapOfPluginInfoForThread.values()));
            for (PluginInfoForThread pluginInfoForThread : listOfPluginInfoForThreadCopy) {
                Plugin thePlugin = pluginInfoForThread.thePlugin;
                this.pushContext(new PluginContext(this, thePlugin, unsafeCalls, cStartScript, cCurrentEnv, 0L, Thread.currentThread(), null));
                thePlugin.shutdown();
            }
            this.unregisterAllFunctions();
            this.mapOfPluginInfoForThread.clear();
            Thread[] activeThreads = new Thread[Thread.activeCount()];
            int threadCount = Thread.enumerate(activeThreads);
            log.info("Shutting down. Active threads: " + Arrays.asList(activeThreads));
            if (pluginJarFile != null) {
                try {
                    pluginJarFile.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Could not close the pluginJarFile", e);
                }
            }
            if (isAwtInitialized) {
                log.info("Disposing root frame...");
                PluginBridge.finishedRootFrame();
                log.info("Root frame is disposed");
                RepaintManager.setCurrentManager(null);
            }
            if ((double)(specVersion = Float.valueOf(System.getProperty("java.specification.version")).floatValue()) >= 1.6) {
                SharedSecrets.setJavaNetAccess(null);
            }
            System.setIn(null);
            if (this.didInstallSecurityManager) {
                System.setSecurityManager(null);
            }
            Thread.currentThread().setContextClassLoader(null);
            long waitStartTime = System.currentTimeMillis();
            try {
                while (true) {
                    boolean eventDispatchIsRunning = false;
                    for (int n = 0; n < threadCount; ++n) {
                        if (!activeThreads[n].toString().contains("AWT-EventQueue")) continue;
                        eventDispatchIsRunning = true;
                        break;
                    }
                    long waitDuration = System.currentTimeMillis() - waitStartTime;
                    if (!eventDispatchIsRunning) {
                        log.info("Event Dispatch Thread took " + waitDuration + "ms to stop. Active threads: " + Arrays.asList(activeThreads));
                        break;
                    }
                    if (waitDuration > 3000L) {
                        log.warning("EventDispatch thread did not stop after " + waitDuration + "ms; exiting anyway. Active threads: " + Arrays.asList(activeThreads));
                        break;
                    }
                    Thread.sleep(100L);
                    activeThreads = new Thread[Thread.activeCount()];
                    threadCount = Thread.enumerate(activeThreads);
                }
            }
            catch (InterruptedException e) {
                log.log(Level.WARNING, "Thread was interrupted while waiting for EventDispatch thread to finish", e);
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, "Could not shut down plugin", e);
            throw e;
        }
        catch (Error e) {
            log.log(Level.SEVERE, "Could not shut down plugin", e);
            throw e;
        }
        finally {
            this.popContext();
        }
        if (initThread != null) {
            log.config("Init thread: " + initThread.getName());
            log.config("Init thread context class loader: " + (initThread.getContextClassLoader() == null ? null : initThread.getContextClassLoader().toString()));
            initThread.setContextClassLoader(null);
            log.config("Init thread context class loader: " + (initThread.getContextClassLoader() == null ? null : initThread.getContextClassLoader().toString()));
            initThread = null;
        } else {
            log.info("Init thread is null");
        }
        Thread thread = Thread.currentThread();
        log.config("Shutdown thread: " + thread.getName());
        log.config("Shutdown thread context class loader: " + (thread.getContextClassLoader() == null ? null : thread.getContextClassLoader().toString()));
        thread.setContextClassLoader(null);
        log.config("Shutdown thread context class loader: " + (thread.getContextClassLoader() == null ? null : thread.getContextClassLoader().toString()));
        this.removeClassLoaderFromAccessControlContext();
        this.removeClassLoaderFromLoaderCache();
        this.removeClassLoaderFromProxyClasses();
        this.removeClassLoaderFromAccessControlContext();
        this.clearKeepAliveCache();
        log.config("PluginBridge shutdown finished");
        try {
            NativeLibraries nativeLibraries = new NativeLibraries();
            HashMap libraryToClass = new HashMap();
            libraryToClass.put(PluginBridge.class.getName(), PluginBridge.class);
            Map<String, ClassLoader> libraryClassLoaders = nativeLibraries.getLibraryClassLoaders(libraryToClass);
            log.config("Native Library ClassLoaders: " + libraryClassLoaders.toString());
            for (ClassLoader classLoader : libraryClassLoaders.values()) {
                log.config("Native Libraries: " + nativeLibraries.getNativeLibraries(classLoader).toString());
                if (!(classLoader instanceof Closeable) || !(classLoader instanceof URLClassLoader)) continue;
                try {
                    log.config("Closing ClassLoader named " + classLoader.getClass().getName());
                    ((Closeable)((Object)classLoader)).close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "An error occurred while closing a classloader named " + classLoader.getClass().getName(), e);
                }
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public void fmxDoAppPreferences(final boolean unsafeCalls, final long cStartScript, final long cCurrentEnv) {
        try {
            final Plugin thePlugin = this.getThePlugin();
            if (thePlugin instanceof Configurable) {
                if (PluginBridge.isHeadless()) {
                    log.warning("Cannot show preferences in headless mode");
                    return;
                }
                Runnable pluginTask = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        log.log(Level.CONFIG, "Configuring {0}", thePlugin);
                        try {
                            PluginBridge.this.pushContext(new PluginContext(PluginBridge.this, thePlugin, unsafeCalls, cStartScript, cCurrentEnv, 0L, Thread.currentThread(), null));
                            ((Configurable)((Object)thePlugin)).configure();
                        }
                        finally {
                            PluginBridge.this.popContext();
                        }
                    }
                };
                long prefsWindow = this.getFMProWindowReference();
                log.log(Level.FINE, "Configuring preferences from window " + prefsWindow + " / {0}", PluginBridge._getWindowTitle(prefsWindow));
                this.runTask(pluginTask, true, prefsWindow);
            }
        }
        catch (ThreadDeath d) {
            throw d;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Unexpected exception while displaying preferences", t);
        }
    }

    private long getFMProWindowReference() {
        long prefsWindow = isMac ? PluginBridge._getFrontWindowReference() : PluginBridge._getWindowOwnerReference();
        return prefsWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short doFunction(short functionID, long[] parameterTokens, long resultHolderCToken, boolean unsafeCalls, long cStartScript, long cCurrentEnv) {
        long startTime = System.currentTimeMillis();
        final short[] result = new short[1];
        final PluginFunction theFunction = this.functionIDMap.get(functionID);
        try {
            block26: {
                int n;
                if (theFunction == null) {
                    throw new FMException(-3, "No function registered for code " + functionID);
                }
                log.fine("=== doFunction " + theFunction.getName() + " called on thread: " + Thread.currentThread().getName() + ", eventLoopDepth is " + eventLoopDepth + " ===");
                log.log(Level.FINER, "{0} will invoke function {1} with {2} arguments", new Object[]{this, theFunction, parameterTokens.length});
                if (log.isLoggable(Level.FINEST)) {
                    StringBuilder tokens = new StringBuilder("Parameter tokens for call to " + theFunction.getName() + ": ");
                    for (n = 0; n < parameterTokens.length; ++n) {
                        if (n > 0) {
                            tokens.append("; ");
                        }
                        tokens.append("[").append(n).append("]=").append(parameterTokens[n]);
                    }
                    log.finest(tokens.toString());
                }
                FMData[] rawParameters = new FMData[parameterTokens.length];
                for (n = 0; n < parameterTokens.length; ++n) {
                    rawParameters[n] = new FMData(parameterTokens[n], Thread.currentThread());
                }
                Thread mainThread = Thread.currentThread();
                final Plugin thePlugin = this.getThePlugin();
                final PluginContext pluginContext = new PluginContext(this, thePlugin, unsafeCalls, cStartScript, 0L, cCurrentEnv, mainThread, theFunction);
                Object[] convertedParams = new Object[]{};
                log.log(Level.FINER, "Created new PluginContext {0}", pluginContext);
                try {
                    this.pushContext(pluginContext);
                    Exception paramConvertException = null;
                    try {
                        convertedParams = theFunction.convertParams(rawParameters, pluginContext);
                    }
                    catch (Exception e) {
                        paramConvertException = e;
                    }
                    boolean spawnEventLoop = theFunction.isGuiFunction() && !PluginBridge.isHeadless();
                    final Object[] finalConvertedParams = convertedParams;
                    final Exception finalParamConvertException = paramConvertException;
                    Runnable pluginTask = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            log.config("=== Executing plugin function " + theFunction.getName() + " on thread " + Thread.currentThread().getName() + " ===");
                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                            try {
                                thePlugin.invokeFunctionNoErrors(theFunction, pluginContext, finalConvertedParams, finalParamConvertException);
                                log.log(Level.FINE, "Invocation of {0} successful on thread {1}", new Object[]{theFunction, Thread.currentThread().getName()});
                                result[0] = 0;
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(null);
                            }
                        }

                        public String toString() {
                            return "Run task for plugin function: " + theFunction;
                        }
                    };
                    this.runTask(pluginTask, spawnEventLoop, PluginBridge._getThreadWindowReference());
                    FMType functionResult = pluginContext.getFunctionResult();
                    if (functionResult == null) {
                        log.log(Level.FINE, "Function result was null in main thread " + Thread.currentThread().getName() + " for " + theFunction + "; replacing with empty string");
                        functionResult = new FMText("");
                    }
                    log.log(Level.FINE, "Result in main thread " + Thread.currentThread().getName() + ": " + functionResult);
                    FMData resultHolder = new FMData(resultHolderCToken, mainThread);
                    functionResult.writeToData(resultHolder);
                    PluginInfoForThread pluginInfoForThread = this.getPluginInfoForThread();
                    Throwable lastErrorComplainedAbout = pluginInfoForThread.lastErrorComplainedAbout;
                    Boolean isErrorVisible = pluginInfoForThread.isErrorVisible;
                    if (thePlugin.getLastError() == null || thePlugin.getLastError() == lastErrorComplainedAbout || PluginBridge.isHeadless() || thePlugin.isErrorCapture() || isErrorVisible.booleanValue()) break block26;
                    try {
                        if (thePlugin.getLastError() instanceof ExpiredLicenseException || this.getCurrentContext().evaluateExpression("Get(ErrorCaptureState)=0 and not isempty(Get(ScriptName))").getLongData() == 1L) {
                            pluginInfoForThread.lastErrorComplainedAbout = thePlugin.getLastError();
                            final String lastErrorString = thePlugin.getLastErrorString();
                            final String title = thePlugin.getName() + " Error";
                            PluginBridge.initAwt();
                            pluginInfoForThread.isErrorVisible = true;
                            SwingUtilities.invokeLater(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        if (!isMac) {
                                            PluginBridge.setRootFrameParent(PluginBridge.this.getFMProWindowReference());
                                        }
                                        JOptionPane.showMessageDialog(null, lastErrorString, title, 0);
                                    }
                                    finally {
                                        PluginBridge.this.setIsErrorVisible(false);
                                    }
                                }
                            });
                        }
                    }
                    catch (Throwable t) {
                        log.log(Level.SEVERE, "Unable to show error dialog for " + thePlugin.getLastError(), t);
                    }
                }
                finally {
                    this.popContext();
                }
            }
            if (++callCounter == 10000) {
                log.fine("Garbage collection");
                System.gc();
                callCounter = 0;
            }
        }
        catch (FMException e) {
            log.log(Level.SEVERE, "FMException: " + e.toString(), e);
            result[0] = e.getErrorCode();
        }
        catch (ThreadDeath e) {
            log.log(Level.SEVERE, "Received ThreadDeath: " + e.toString(), e);
            throw e;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Throwable: " + t.toString(), t);
            result[0] = -1;
        }
        finally {
            if (theFunction != null) {
                log.fine("finished doFunction: " + theFunction.getName());
            }
            if (this.getPluginInfoForThread().currentContextStack.size() == 0) {
                PluginBridge._clearMemory();
            }
        }
        if (log.isLoggable(Level.FINE)) {
            int duration = (int)(System.currentTimeMillis() - startTime);
            log.fine("Plugin function completed in " + duration + " milliseconds");
        }
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTask(final @Nullable Runnable task, boolean spawnEventLoop, final long currentWindowRef) throws Exception {
        block18: {
            if (spawnEventLoop) {
                final AtomicBoolean isTaskFinished = new AtomicBoolean(false);
                Runnable guiTask = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (eventLoopDepth.intValue() == 1) {
                                PluginBridge.setRootFrameParent(currentWindowRef);
                            } else {
                                log.fine("Don't create root frame parent, because eventLoopDepth is " + eventLoopDepth);
                            }
                            if (task != null) {
                                log.fine("task.run start: " + task.toString());
                                task.run();
                                log.fine("task.run stop: " + task.toString());
                            }
                        }
                        catch (Exception t) {
                            log.log(Level.SEVERE, "Error while running GUI task: " + task, t);
                        }
                        finally {
                            log.fine("guiTask finished processing: " + task);
                            if (eventLoopDepth.intValue() == 1 && isMac) {
                                PluginBridge.finishedRootFrame();
                            }
                            isTaskFinished.set(true);
                            PluginBridge.stopEventLoop();
                        }
                    }
                };
                if (!isMac) {
                    PluginBridge.enableWindow(currentWindowRef, false);
                    log.fine("Disabled window " + currentWindowRef + " / " + PluginBridge._getWindowTitle(currentWindowRef) + " / thread ID: " + PluginBridge._getWindowThreadId(currentWindowRef) + " / is child: " + PluginBridge._isChildWindow(currentWindowRef));
                }
                try {
                    PluginBridge.initAwt();
                    int newDepth = eventLoopDepth.incrementAndGet();
                    log.fine("eventLoopDepth was incremented to " + newDepth + "; Triggering main startEventLoop() for Runnable: " + task);
                    Object eventRunLock = new Object();
                    InvocationEvent event = new InvocationEvent((Object)Toolkit.getDefaultToolkit(), guiTask, eventRunLock, true);
                    log.fine("Posting plugin task to system event queue: " + task);
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(event);
                    while (true) {
                        PluginBridge.startEventLoop();
                        if (isTaskFinished.get() || eventLoopDepth.intValue() > 1) break;
                        log.info("*** Event loop finished before isTaskFinished flag was set; re-entering event loop");
                    }
                    if (eventLoopDepth.intValue() > 0) {
                        log.fine("Main event loop finished; current eventLoopDepth is " + eventLoopDepth + "; decrementing eventLoopDepth. Main thread task: " + task);
                        eventLoopDepth.decrementAndGet();
                    }
                    if (isMac) {
                        int extraLoops = 0;
                        while (eventLoopDepth.intValue() != 0) {
                            log.fine("Triggering extra event loop to finish re-entrant calls, extraLoops is now " + ++extraLoops + " and eventLoopDepth is " + eventLoopDepth);
                            PluginBridge.startEventLoop();
                            newDepth = eventLoopDepth.decrementAndGet();
                            log.fine("Decremented eventLoopLock to " + newDepth);
                        }
                        while (extraLoops > 0) {
                            log.fine("Stopping extra event loop to unwind re-entrant calls, there are " + extraLoops + " to unwind");
                            PluginBridge.stopEventLoop();
                            --extraLoops;
                        }
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("<< FINISHED ALL EVENT LOOPS for " + task + "; eventLoopDepth is " + eventLoopDepth + " >>");
                    }
                    Object object = eventRunLock;
                    synchronized (object) {
                        while (true) {
                            if (isTaskFinished.get()) break;
                            int timeToWait = 5000;
                            eventRunLock.wait(timeToWait);
                            log.warning("We have been waiting " + timeToWait + " milliseconds; may be deadlocked. This can be caused if startEventLoop() exits prematurely and stops pumping events. Will continue to wait, but this will probably not release.");
                        }
                        log.fine("isTaskFinished AtomicBoolean flag is set to true; returning from runTask()");
                    }
                    if (event.getException() != null) {
                        throw event.getException();
                    }
                    break block18;
                }
                finally {
                    if (!isMac) {
                        PluginBridge.enableWindow(currentWindowRef, true);
                        PluginBridge._setForegroundWindow(currentWindowRef);
                    }
                }
            }
            if (task != null) {
                task.run();
            }
        }
    }

    private static void setRootFrameParent(long currentWindow) {
        log.fine("FrontWindowRef is " + frontWindowRef + " / Current window is " + currentWindow + " with title " + PluginBridge._getWindowTitle(currentWindow));
        if (isMac || currentWindow != frontWindowRef) {
            log.fine("Current window changed from  " + frontWindowRef + "  to " + currentWindow + "; setting root frame parent");
            log.fine(Thread.currentThread() + ": Setting root frame to window " + currentWindow + " / thread ID: " + PluginBridge._getWindowThreadId(currentWindow) + " / is child: " + PluginBridge._isChildWindow(currentWindow));
            if (embeddedFrame != null && isMac) {
                log.warning("*** setRootFrameParent was called when there is already an embeddedFrame! Disposing.");
                PluginBridge.finishedRootFrame();
            }
            frontWindowRef = currentWindow;
            try {
                if (rootFrames.containsKey(frontWindowRef)) {
                    embeddedFrame = rootFrames.get(frontWindowRef);
                } else {
                    Class<?> nativeFrameClass = isMac ? Class.forName("apple.awt.CEmbeddedFrame") : Class.forName("sun.awt.windows.WEmbeddedFrame");
                    Constructor<?> constructor = nativeFrameClass.getConstructor(Long.TYPE);
                    Long peerInfo = frontWindowRef;
                    embeddedFrame = (EmbeddedFrame)constructor.newInstance(peerInfo);
                    embeddedFrame.pack();
                    Method setBoundsMethod = EmbeddedFrame.class.getDeclaredMethod("setBoundsPrivate", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    setBoundsMethod.setAccessible(true);
                    setBoundsMethod.invoke((Object)embeddedFrame, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, 0);
                    log.fine("About to display embedded frame...");
                    embeddedFrame.setVisible(true);
                    log.fine("Embedded frame was displayed without deadlocking");
                    rootFrames.put(frontWindowRef, embeddedFrame);
                }
                JOptionPane.setRootFrame(embeddedFrame);
            }
            catch (Exception t) {
                log.log(Level.WARNING, "Could not set the parent for the root frame, modal dialogs will not work correctly", t);
            }
        }
    }

    public static void finishedRootFrame() {
        try {
            log.fine("Disposing embeddedFrame");
            if (embeddedFrame != null) {
                embeddedFrame.dispose();
            }
            rootFrames.remove(frontWindowRef);
            embeddedFrame = null;
            frontWindowRef = 0L;
            JOptionPane.setRootFrame(null);
        }
        catch (Exception t) {
            log.log(Level.WARNING, "Could not dispose of root frame", t);
        }
    }

    public static void initAwt() {
        if (isAwtInitialized || PluginBridge.isHeadless()) {
            return;
        }
        if (isMac) {
            log.fine("initAwt called in Java");
            Runnable startAwt = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Toolkit toolkit = Toolkit.getDefaultToolkit();
                        toolkit.getSystemEventQueue().peekEvent();
                        log.info("Initialized AWT successfully  from " + Thread.currentThread());
                    }
                    finally {
                        PluginBridge.stopEventLoop();
                    }
                }
            };
            Thread awtThread = new Thread(startAwt);
            awtThread.start();
            PluginBridge.startEventLoop();
        } else {
            try {
                Class.forName("sun.awt.windows.WToolkit").getMethod("embeddedInit", new Class[0]).invoke(null, new Object[0]);
                log.info("Initialized AWT successfully from " + Thread.currentThread());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not initialize AWT", e);
            }
        }
        isAwtInitialized = true;
    }

    private void pushContext(PluginContext pluginContext) {
        PluginInfoForThread pluginInfoForThread = this.getPluginInfoForThread();
        Deque<PluginContext> currentContextStack = pluginInfoForThread.currentContextStack;
        Exception lastOperationStackTrace = pluginInfoForThread.lastOperationStackTrace;
        if (currentContextStack.size() > 0) {
            ArrayList<PluginFunction> previousCalls = new ArrayList<PluginFunction>(currentContextStack.size());
            for (PluginContext context : currentContextStack) {
                previousCalls.add(context.getWhichFunction());
            }
            log.log(Level.WARNING, "pushContext called with function (" + pluginContext.getWhichFunction() + ") when stack size is " + currentContextStack.size() + "; this either means it was called re-entrantly, an idle handler was called without waiting for a return from a previous call, or pop was not called from last invocation. Current thread: " + Thread.currentThread().getName() + StringUtils.CR + "Previous calls: " + previousCalls);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Here is the first operation on the context stack", lastOperationStackTrace);
            }
        } else if (log.isLoggable(Level.FINE)) {
            pluginInfoForThread.lastOperationStackTrace = new RuntimeException("First item on context queue is plugin function: " + pluginContext.getWhichFunction());
        }
        currentContextStack.push(pluginContext);
        LinkedList<FileMakerOperation> operationQueue = pluginInfoForThread.operationQueue;
        LinkedList<FileMakerOperation> queueCopy = new LinkedList<FileMakerOperation>(operationQueue);
        operationQueue.clear();
        for (FileMakerOperation operation : queueCopy) {
            try {
                operation.run(pluginContext);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unexpected error while calling queued FileMakerOperation", e);
            }
        }
    }

    private void popContext() {
        try {
            PluginContext context = this.getPluginInfoForThread().currentContextStack.pop();
            if (context.getWhichFunction() != null) {
                log.fine("Popped context for function " + context.getWhichFunction());
            }
        }
        catch (EmptyStackException e) {
            log.log(Level.WARNING, "popContext was called with an empty currentContextStack. Current thread: " + Thread.currentThread().getName(), e);
        }
    }

    public PluginContext getCurrentContext() {
        Deque<PluginContext> currentContextStack = this.getPluginInfoForThread().currentContextStack;
        return currentContextStack.peek();
    }

    public void executeFileMakerOperation(FileMakerOperation runnable) throws InterruptedException {
        PluginContext context = this.getCurrentContext();
        if (context.getFilemakerThread() == Thread.currentThread()) {
            runnable.run(context);
        } else {
            LinkedList<FileMakerOperation> operationQueue = this.getPluginInfoForThread().operationQueue;
            operationQueue.addLast(runnable);
            while (operationQueue.contains(runnable)) {
                operationQueue.wait();
            }
        }
    }

    public void queueFileMakerOperation(FileMakerOperation runnable) {
        PluginContext context = this.getCurrentContext();
        if (context.getFilemakerThread() == Thread.currentThread()) {
            runnable.run(context);
        } else {
            this.getPluginInfoForThread().operationQueue.addLast(runnable);
        }
    }

    private static void startEventLoop() {
        log.fine("-> Starting event loop from Thread (" + Thread.currentThread().getName() + ")...");
        try {
            PluginBridge._startEventLoop(frontWindowRef);
        }
        catch (Error e) {
            log.log(Level.WARNING, "Error occurred while starting run loop", e);
            throw e;
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "RuntimeException occurred while starting run loop", e);
            throw e;
        }
        finally {
            log.fine("event loop has finished");
        }
    }

    private static native void _startEventLoop(long var0);

    private static native void _clearMemory();

    private static void stopEventLoop() {
        log.fine("<- Stopping event loop from Thread (" + Thread.currentThread() + ")...");
        PluginBridge._stopEventLoop(frontWindowRef);
        log.fine("Event loop is now stopped");
    }

    private static native void _stopEventLoop(long var0);

    private void scanFunctions(Plugin thePlugin) {
        log.log(Level.FINE, "{0} scanning functions", this);
        for (Method eachMethod : MethodScanner.findFMFunctions(thePlugin.getClass())) {
            if (eachMethod.getName().equals("invokeFunction") || Modifier.isStatic(eachMethod.getModifiers())) continue;
            try {
                StaticFunction eachFunction = new StaticFunction(eachMethod);
                String prototype = "";
                FMFunction annotation = eachFunction.getTargetMethod().getAnnotation(FMFunction.class);
                if (annotation != null) {
                    if (!thePlugin.getVersion().isAtLeast(annotation.minimumVersion())) {
                        log.log(Level.FINE, "Plugin function " + eachMethod.getName() + " requires version " + annotation.minimumVersion() + ", but plugin is version " + thePlugin.getVersion().stringVersion);
                        continue;
                    }
                    prototype = annotation.prototype();
                } else {
                    String prototypeMethodName = eachFunction.getName() + "Prototype";
                    try {
                        Method prototypeMethod = thePlugin.getClass().getMethod(prototypeMethodName, new Class[0]);
                        prototype = (String)prototypeMethod.invoke((Object)thePlugin, new Object[0]);
                        log.finer("Found prototype method named " + prototypeMethodName + " which returned " + prototype);
                    }
                    catch (NoSuchMethodException e) {
                        log.fine("Couldn't find prototype method: " + prototypeMethodName);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Error when trying to invoke the prototype method", e);
                    }
                }
                eachFunction.setPrototype(prototype);
                int firstBracketIndex = prototype.indexOf(91);
                if (firstBracketIndex == -1) {
                    firstBracketIndex = prototype.indexOf(123);
                }
                if (firstBracketIndex >= 0) {
                    int minArgs = prototype.startsWith("[") || prototype.startsWith("{") ? 0 : prototype.substring(0, firstBracketIndex).split(";").length;
                    eachFunction.setMinArgs(minArgs);
                }
                if (!thePlugin.customizeFunction(eachFunction)) continue;
                this.queueFunction(eachFunction);
            }
            catch (FMType.UnsupportedTypeConversionException e) {
                log.log(Level.WARNING, "Can't do conversions for at least one plugin function", e);
            }
        }
    }

    private void queueFunction(PluginFunction theFunction) {
        this.functionsToRegister.add(theFunction);
    }

    private void registerAllFunctions(Plugin thePlugin) {
        for (PluginFunction aFunctionsToRegister : this.functionsToRegister) {
            this.registerFunction(aFunctionsToRegister, thePlugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunction(PluginFunction theFunction, Plugin thePlugin) {
        boolean isDuplicateId;
        log.log(Level.INFO, "{0} registering {1}", new Object[]{this, theFunction});
        Short functionId = theFunction.getFunctionID();
        String functionSignature = theFunction.getName();
        if (theFunction.getPrototype().trim().length() > 0) {
            functionSignature = functionSignature + "( " + theFunction.getPrototype() + " )";
        }
        log.fine("Registering the function in C++ with params " + thePlugin.getShortId().toString() + ", " + theFunction.getFunctionID() + ", " + theFunction.getName() + ", " + functionSignature + ", " + theFunction.getMinArgs() + ", " + theFunction.getMaxArgs() + ", " + theFunction.getFlags());
        PluginFunction oldFunction = this.functionIDMap.get(functionId);
        do {
            if (oldFunction != null) {
                if (!oldFunction.getName().equals(theFunction.getName())) {
                    Short s = functionId;
                    Short s2 = functionId = Short.valueOf((short)(functionId + 1));
                    log.warning("*** WARNING: function: " + theFunction.getName() + " assigned new ID to avoid overwriting function: " + oldFunction.getName());
                    oldFunction = this.functionIDMap.get(functionId);
                    isDuplicateId = true;
                    continue;
                }
                log.warning("*** WARNING: function " + theFunction.getName() + " with ID " + functionId + " has already been registered with the function ID for " + oldFunction.getName() + ". " + theFunction.getName() + " will replace it in the function list.");
                this._unregisterFunction(thePlugin.getShortId().toString(), theFunction.getFunctionID());
                isDuplicateId = false;
                continue;
            }
            isDuplicateId = false;
        } while (isDuplicateId);
        try {
            this._registerFunction(thePlugin.getShortId().toString(), functionId, theFunction.getName(), functionSignature, theFunction.getMinArgs(), theFunction.getMaxArgs(), theFunction.getFlags());
        }
        finally {
            log.fine("_registerFunction returned");
        }
        this.functionIDMap.put(functionId, theFunction);
    }

    private void unregisterAllFunctions() {
        HashSet<Short> ids = new HashSet<Short>(this.functionIDMap.keySet());
        for (Short functionId : ids) {
            this.unregisterFunction(functionId);
        }
    }

    public void unregisterFunction(short functionId) {
        log.log(Level.INFO, "{0} unregistering function with ID {1}", new Object[]{this, functionId});
        PluginFunction oldFunction = this.functionIDMap.get(functionId);
        if (oldFunction == null) {
            log.warning("*** WARNING: function was never registered with ID " + functionId + "; it cannot be unregistered.");
        }
        this._unregisterFunction(this.getThePlugin().getShortId().toString(), functionId);
        this.functionIDMap.remove(functionId);
    }

    public String[] getClipboardFormats() {
        String[] result;
        if (isMac) {
            result = (String[])PluginBridge._getClipboardFormatsMac();
        } else {
            int[] formats = PluginBridge._getClipboardFormatsWin();
            result = new String[formats.length];
            for (int i = 0; i < formats.length; ++i) {
                result[i] = String.valueOf(formats[i]);
            }
        }
        return result;
    }

    public String getBestFileMakerClipboardFormat() {
        HashSet<String> availableFormats = new HashSet<String>(Arrays.asList(this.getClipboardFormats()));
        for (String fmFormat : this.getClipboardFormatMap().values()) {
            if (!availableFormats.contains(fmFormat)) continue;
            return fmFormat;
        }
        throw new IllegalStateException("The clipboard does not contain data in any recognizable format");
    }

    private EnumMap<ClipboardType, String> getClipboardFormatMap() {
        if (this.clipboardFormatMap == null) {
            this.clipboardFormatMap = new EnumMap(ClipboardType.class);
            if (isMac) {
                this.clipboardFormatMap.put(ClipboardType.table, "dyn.agk8zuxnykk");
                this.clipboardFormatMap.put(ClipboardType.field, "dyn.agk8zuxngku");
                if (majorVersion >= 12) {
                    this.clipboardFormatMap.put(ClipboardType.layout, "dyn.ah62d4rv4gk8zuxnqgk");
                } else {
                    this.clipboardFormatMap.put(ClipboardType.layout, "dyn.agk8zuxnqm6");
                }
                this.clipboardFormatMap.put(ClipboardType.script, "dyn.agk8zuxnxkq");
                this.clipboardFormatMap.put(ClipboardType.scriptStep, "dyn.agk8zuxnxnq");
                this.clipboardFormatMap.put(ClipboardType.customFunction, "dyn.agk8zuxngm2");
                this.clipboardFormatMap.put(ClipboardType.plainText, "com.apple.traditional-mac-plain-text");
            } else {
                int[] intFormats = PluginBridge._getAllClipboardFormatsWin(majorVersion);
                int n = -1;
                this.clipboardFormatMap.put(ClipboardType.script, String.valueOf(intFormats[++n]));
                this.clipboardFormatMap.put(ClipboardType.scriptStep, String.valueOf(intFormats[++n]));
                this.clipboardFormatMap.put(ClipboardType.field, String.valueOf(intFormats[++n]));
                this.clipboardFormatMap.put(ClipboardType.table, String.valueOf(intFormats[++n]));
                this.clipboardFormatMap.put(ClipboardType.layout, String.valueOf(intFormats[++n]));
                this.clipboardFormatMap.put(ClipboardType.plainText, "1");
            }
        }
        return this.clipboardFormatMap;
    }

    public byte[] getClipboardData(String whichFormat, boolean isFileMaker) {
        byte[] result;
        if (isMac) {
            result = PluginBridge._getClipboardDataMac(whichFormat);
        } else {
            byte[] tempResult = PluginBridge._getClipboardData(Integer.valueOf(whichFormat));
            if (isFileMaker && tempResult.length > 4 && !"1".equals(whichFormat)) {
                result = new byte[tempResult.length - 4];
                System.arraycopy(tempResult, 4, result, 0, result.length);
            } else {
                result = tempResult;
            }
        }
        return result;
    }

    public ClipboardType getClipboardType(String xmlData) throws InvalidClipboardException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            DefaultHandler handler = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("Layout".equals(qName)) {
                        throw new StopParseException(ClipboardType.layout);
                    }
                    if ("Field".equals(qName)) {
                        throw new StopParseException(ClipboardType.field);
                    }
                    if ("Script".equals(qName)) {
                        throw new StopParseException(ClipboardType.script);
                    }
                    if ("Step".equals(qName)) {
                        throw new StopParseException(ClipboardType.scriptStep);
                    }
                    if ("BaseTable".equals(qName)) {
                        throw new StopParseException(ClipboardType.table);
                    }
                    if ("CustomFunction".equals(qName)) {
                        throw new StopParseException(ClipboardType.customFunction);
                    }
                }
            };
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlData.getBytes("UTF-8"));
            parser.parse((InputStream)bais, handler);
            throw new InvalidClipboardException("The provided XML data contains valid XML, but it is not a recognized FileMaker type");
        }
        catch (StopParseException e) {
            return e.getType();
        }
        catch (SAXException e) {
            log.warning("The clipboard does not contain valid XML");
            return ClipboardType.plainText;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public String getClipboardFormatString(ClipboardType whichType) {
        return this.getClipboardFormatMap().get((Object)whichType);
    }

    public void setClipboardData(String whichFormat, byte[] data, boolean isFileMaker, boolean clearExisting) {
        if (isMac) {
            PluginBridge._setClipboardDataMac(whichFormat, data);
        } else {
            if (isFileMaker && !"1".equals(whichFormat)) {
                byte[] newData = new byte[data.length + 4];
                byte b1 = (byte)data.length;
                byte b2 = (byte)(data.length >> 8);
                byte b3 = (byte)(data.length >> 16);
                byte b4 = (byte)(data.length >> 24);
                System.arraycopy(new byte[]{b1, b2, b3, b4}, 0, newData, 0, 4);
                System.arraycopy(data, 0, newData, 4, data.length);
                data = newData;
            }
            PluginBridge._setClipboardData(Integer.valueOf(whichFormat), data, clearExisting);
            if (clearExisting && !isMac && !"2".equals(whichFormat)) {
                this.setClipboardData("2", new byte[0], false, false);
            }
        }
    }

    private static native int[] _getAllClipboardFormatsWin(short var0);

    private static native int[] _getClipboardFormatsWin();

    private static native Object[] _getClipboardFormatsMac();

    private static native byte[] _getClipboardData(int var0);

    private static native byte[] _getClipboardDataMac(String var0);

    private static native void _setClipboardDataMac(String var0, byte[] var1);

    private static native void _setClipboardData(int var0, byte[] var1, boolean var2);

    private static native long _getFrontWindowReference();

    private static native long _getWindowOwnerReference();

    private static native long _getThreadWindowReference();

    private static void enableWindow(long windowRef, boolean enable) {
        PluginBridge._enableWindow(windowRef, enable);
    }

    private static native void _enableWindow(long var0, boolean var2);

    private static native boolean _setForegroundWindow(long var0);

    private static native String _getWindowTitle(long var0);

    private static native long _getWindowThreadId(long var0);

    private static native boolean _isChildWindow(long var0);

    private static native long _getCurrentThreadId();

    private native void _registerFunction(String var1, short var2, String var3, String var4, int var5, int var6, int var7);

    private native void _unregisterFunction(String var1, short var2);

    public long getInstanceID() {
        return instanceID;
    }

    Plugin getThePlugin() {
        return this.getPluginInfoForThread().thePlugin;
    }

    private PluginInfoForThread getPluginInfoForThread() {
        if (this.isClient()) {
            return this.firstPluginInfo;
        }
        return (PluginInfoForThread)this.pluginInstanceForThread.get().get();
    }

    public static short getApiVersion() {
        return apiVersion;
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    private void setIsErrorVisible(boolean errorVisible) {
        this.getPluginInfoForThread().isErrorVisible = errorVisible;
    }

    static void clearSharedInstance() {
        log.log(Level.WARNING, "{0} clearing sharedInstance", sharedInstance);
        sharedInstance = null;
        pluginClassName = null;
        bundlePath = null;
    }

    public String toString() {
        return "PluginBridge{instanceID=" + instanceID + '}';
    }

    public static boolean isVersion8Loaded() {
        return version8Loaded;
    }

    public static boolean isVersion11Loaded() {
        return version11Loaded;
    }

    private void removeClassLoaderFromLoaderCache() {
        String errMsg = "Unable to remove ClassLoader from Proxy loader cache";
        try {
            Field loaderToCacheField = Proxy.class.getDeclaredField("loaderToCache");
            loaderToCacheField.setAccessible(true);
            Map loaderToCache = (Map)loaderToCacheField.get(null);
            log.info("Proxy Loader Cache: " + loaderToCache.toString());
            Object remove = loaderToCache.remove(this.getClass().getClassLoader());
            if (remove == null) {
                log.log(Level.SEVERE, "Unable to remove ClassLoader from Proxy loader cache");
            } else {
                log.log(Level.INFO, "Removed ClassLoader from Proxy loader cache");
            }
        }
        catch (NoSuchFieldException e) {
            log.log(Level.SEVERE, errMsg, e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, errMsg, e);
        }
    }

    private void removeClassLoaderFromProxyClasses() {
        String errMsg = "Unable to remove ClassLoader from Proxy class cache";
        try {
            Field proxyClassesField = Proxy.class.getDeclaredField("proxyClasses");
            proxyClassesField.setAccessible(true);
            Map proxyClasses = (Map)proxyClassesField.get(null);
            log.info("Proxy Classes: " + proxyClasses.toString());
            boolean remove = false;
            if (proxyClasses.containsKey(this.getClass())) {
                proxyClasses.remove(this.getClass());
                remove = true;
            }
            if (proxyClasses.containsKey(this.getClass().getClassLoader())) {
                proxyClasses.remove(this.getClass().getClassLoader().getClass());
                remove = true;
            }
            if (remove) {
                log.log(Level.INFO, "Removed ClassLoader from Proxy class cache");
            } else {
                log.log(Level.SEVERE, errMsg);
            }
        }
        catch (NoSuchFieldException e) {
            log.log(Level.SEVERE, errMsg, e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, errMsg, e);
        }
    }

    private void removeClassLoaderFromAccessControlContext() {
        String errMsg = "Unable to remove ClassLoader from AccessControlContext";
        try {
            AccessControlContext accessControlContext = AccessController.getContext();
            Field contextField = accessControlContext.getClass().getDeclaredField("context");
            contextField.setAccessible(true);
            ProtectionDomain[] context = (ProtectionDomain[])contextField.get(accessControlContext);
            boolean remove = false;
            for (ProtectionDomain domain : context) {
                if (!this.getClass().getClassLoader().equals(domain.getClassLoader())) continue;
                Field classloaderField = domain.getClass().getDeclaredField("classloader");
                classloaderField.setAccessible(true);
                classloaderField.set(domain, null);
                remove = true;
            }
            if (remove) {
                log.info("Removed ClassLoader from AccessControlContext");
            } else {
                log.severe(errMsg);
            }
        }
        catch (NoSuchFieldException e) {
            log.log(Level.SEVERE, errMsg, e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, errMsg, e);
        }
    }

    private void removeClassFromClassLoader() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        String errMsg = "Unable to remove " + this.getClass().getName() + " from " + classLoader.getClass().getName();
        try {
            Field classesField = classLoader.getClass().getField("classes");
            classesField.setAccessible(true);
            List classes = (List)classesField.get(classLoader);
            if (classes.remove(this.getClass())) {
                log.info("Removed " + this.getClass().getName() + " from " + classLoader.getClass().getName());
            } else {
                log.severe(errMsg);
            }
        }
        catch (NoSuchFieldException e) {
            log.log(Level.SEVERE, errMsg, e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, errMsg, e);
        }
    }

    private void clearKeepAliveCache() {
        try {
            Field field = HttpClient.class.getDeclaredField("kac");
            field.setAccessible(true);
            KeepAliveCache kac = (KeepAliveCache)field.get(null);
            kac.clear();
            log.info("Cleared keep-alive cache");
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not clear keepalive cache", e);
        }
    }

    static {
        isMac = Platform.current == Platform.mac;
        isAwtInitialized = false;
        version8Loaded = false;
        version11Loaded = false;
        callCounter = 0;
        frontWindowRef = 0L;
        eventLoopDepth = new AtomicInteger();
        pluginJarDeletable = false;
        initThread = null;
        rootFrames = new HashMap<Long, EmbeddedFrame>(2);
    }

    private static class StopParseException
    extends SAXException {
        private ClipboardType type;

        private StopParseException(ClipboardType type) {
            this.type = type;
        }

        public ClipboardType getType() {
            return this.type;
        }
    }

    public static enum ClipboardType {
        layout,
        script,
        scriptStep,
        field,
        table,
        customFunction,
        plainText;

    }

    private class PluginInfoForThread {
        Plugin thePlugin;
        Deque<PluginContext> currentContextStack;
        LinkedList<FileMakerOperation> operationQueue;
        Exception lastOperationStackTrace;
        Throwable lastErrorComplainedAbout;
        boolean isErrorVisible;
        long nativeThreadID;
        String threadName = Thread.currentThread().getName();

        private PluginInfoForThread() {
        }
    }
}

