/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fmkit.Configurable;
import com.prosc.fmkit.IdleHandler;
import com.prosc.fmkit.PluginBridge;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.PluginFunction;
import com.prosc.fmkit.QuadChar;
import com.prosc.fmkit.StaticFunction;
import com.prosc.fmkit.VersionInfo;
import com.prosc.fmkit.types.FMNumber;
import com.prosc.fmkit.types.FMText;
import com.prosc.fmkit.types.FMType;
import com.prosc.shared.CaseInsensitiveMap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Plugin {
    private static final Logger log = Logger.getLogger(Plugin.class.getName());
    private Throwable lastError;
    private Short applicationType;
    private LinkedList<PluginFunction> currentFunctions = new LinkedList();
    private PluginBridge pluginBridge;
    private boolean errorCapture = false;

    public abstract QuadChar getShortId();

    public abstract String getName();

    public abstract String getHelpText();

    protected abstract VersionInfo getVersion();

    public final PluginContext getContext() {
        return this.pluginBridge.getCurrentContext();
    }

    public PluginBridge getPluginBridge() {
        return this.pluginBridge;
    }

    final void init(PluginBridge pluginBridge) {
        this.pluginBridge = pluginBridge;
        if (pluginBridge == null) {
            log.warning("Plugin Bridge is null. How is this possible?");
        }
        log.config("Created new plugin instance: " + this.getClass().getName() + " named " + this.getName() + " on thread: " + Thread.currentThread().getName() + "; version: " + this.getVersion().stringVersion);
        this.init();
    }

    public final PluginFunction getCurrentFunction() {
        return this.currentFunctions.getLast();
    }

    public final Object[] maskParameters(Object[] parameters, HashMap replacementParameters) {
        LinkedHashMap<String, Object> requiredMap = new LinkedHashMap<String, Object>();
        CaseInsensitiveMap<String> additionalMap = new CaseInsensitiveMap<String>();
        String prototype = this.getCurrentFunction().getPrototype();
        int indexOfAdditional = prototype.indexOf("{");
        String[] arguments = indexOfAdditional >= 0 ? prototype.substring(0, indexOfAdditional).replace(" ", "").split(";") : prototype.replace(" ", "").split(";");
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            if (parameter instanceof Object[]) {
                Object[] additionalParameters;
                for (Object additionalParameter : additionalParameters = (Object[])parameter) {
                    String[] nameValuePair = String.valueOf(additionalParameter).split("=");
                    if (nameValuePair.length != 2) continue;
                    additionalMap.put(nameValuePair[0], nameValuePair[0] + "=" + nameValuePair[1]);
                }
                continue;
            }
            if (i >= arguments.length) continue;
            requiredMap.put(arguments[i], parameter);
        }
        for (Object replacementParameter : replacementParameters.keySet()) {
            if (requiredMap.containsKey(replacementParameter)) {
                requiredMap.put((String)replacementParameter, replacementParameters.get(replacementParameter));
            }
            if (!additionalMap.containsKey(replacementParameter)) continue;
            additionalMap.put(replacementParameter, replacementParameter + "=" + replacementParameters.get(replacementParameter));
        }
        Object[] result = new Object[parameters.length];
        int i = 0;
        Iterator it = requiredMap.values().iterator();
        while (it.hasNext()) {
            result[i] = it.next();
            ++i;
        }
        if (!additionalMap.isEmpty()) {
            result[i] = additionalMap.values().toArray();
        }
        return result;
    }

    public void init() {
    }

    public boolean customizeFunction(StaticFunction eachFunction) {
        return true;
    }

    protected FMType handleException(Throwable e, Object[] params) {
        return this.handleExceptionByStoringError(e, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invokeFunctionNoErrors(PluginFunction whichFunction, PluginContext context, Object[] convertedParams, Exception paramConvertException) {
        if (!(whichFunction.getName().endsWith("LastError") || whichFunction.getName().endsWith("LastErrorMessage") || whichFunction.getName().endsWith("LastStackTrace"))) {
            this.lastError = null;
        }
        try {
            this.currentFunctions.addLast(whichFunction);
            if (paramConvertException != null) {
                throw paramConvertException;
            }
            if (log.isLoggable(Level.FINER)) {
                ArrayList<String> paramsForLogging = new ArrayList<String>(convertedParams.length);
                for (Object parameter : convertedParams) {
                    String eachParam = String.valueOf(parameter);
                    if (eachParam.length() > 1024) {
                        eachParam = eachParam.substring(0, 1024) + "...";
                    }
                    paramsForLogging.add(eachParam);
                }
                log.log(Level.FINER, "PluginFunction {0} invoked with converted args {1}", new Object[]{this, paramsForLogging});
            }
            try {
                FMType result = this.invokeFunction(whichFunction, convertedParams);
                context.setFunctionResult(result);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable throwable) {
            context.setFunctionResult(this.handleException(throwable, convertedParams));
        }
        finally {
            this.currentFunctions.removeLast();
        }
    }

    protected FMType invokeFunction(PluginFunction function, Object[] parameters) throws Exception {
        return (FMType)function.invoke(this, parameters);
    }

    public void shutdown() {
    }

    public boolean isVersionCompatible(short apiVersion, short applicationType) {
        return true;
    }

    protected void setLastError(Throwable t, Object[] parameters) {
        if (t == null) {
            throw new NullPointerException("lastError throwable must not be null.");
        }
        PluginFunction f = this.currentFunctions.getLast();
        this.lastError = t;
        if (parameters == null) {
            log.log(Level.SEVERE, "PluginFunction " + f + " got an error", t);
        } else {
            ArrayList<Object> paramList = new ArrayList<Object>(parameters.length);
            for (Object parameter : parameters) {
                if (parameter instanceof Object[]) {
                    paramList.add(Arrays.asList((Object[])parameter));
                    continue;
                }
                paramList.add(parameter);
            }
            log.log(Level.SEVERE, "PluginFunction " + f + " got an error with converted args " + paramList, t);
        }
    }

    protected Throwable getLastError() {
        return this.lastError;
    }

    protected FMText defaultLastError() {
        String result = this.getLastErrorString();
        return result == null ? null : new FMText(result);
    }

    protected String getLastErrorString() {
        Throwable t = this.getLastError();
        if (t == null) {
            return null;
        }
        String result = t instanceof Error || t instanceof RuntimeException || t.getMessage() == null ? t.toString() : t.getLocalizedMessage();
        return result;
    }

    protected FMType defaultVersion() {
        return new FMText(this.getVersion().stringVersion);
    }

    protected FMType defaultSetErrorCapture(boolean errorCapture) {
        log.info("errorCapture set to " + errorCapture);
        this.errorCapture = errorCapture;
        return this.successValue();
    }

    protected FMText handleExceptionByStoringError(Throwable e, Object[] params) {
        try {
            this.setLastError(e, params);
            return this.failureValue();
        }
        catch (Exception e1) {
            log.log(Level.SEVERE, "There was an error in the error handler itself!", e1);
            return new FMText("ERROR");
        }
    }

    protected FMNumber successValue() {
        return new FMNumber((Number)1);
    }

    protected FMText failureValue() {
        return new FMText("ERROR");
    }

    protected void setApplicationType(Short type) {
        this.applicationType = type;
    }

    protected Short getApplicationType() {
        return this.applicationType;
    }

    String getOptionString() {
        StringBuilder buffer = new StringBuilder(11);
        buffer.append(this.getShortId().toString());
        buffer.append("1");
        buffer.append(this instanceof Configurable ? "Y" : "n");
        buffer.append("n");
        buffer.append("Y");
        buffer.append(this instanceof IdleHandler ? "Y" : "n");
        buffer.append("n");
        buffer.append("n");
        String result = buffer.toString();
        assert (result.length() == 11);
        return result;
    }

    public void setPluginBridge(PluginBridge bridge) {
    }

    public boolean isErrorCapture() {
        return this.errorCapture;
    }
}

